"""activities_project_id

Revision: 0082
Revision ID: 3ce9106c2680
Revises: 4ae4624010e9
Create Date: 2017-01-13 10:22:40.928396

"""

# revision identifiers, used by Alembic.
revision = '3ce9106c2680'
down_revision = '4ae4624010e9'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.add_column('activities', sa.Column('project_id', sa.Integer(), nullable=True))
    op.create_foreign_key(None, 'activities', 'projects', ['project_id'], ['id'], ondelete='SET NULL')
    op.create_index(op.f('ix_activities_project_id'), 'activities', ['project_id'], unique=False)

    op.drop_index(op.f('ix_activities_object_id'), 'activities')
    op.drop_index(op.f('ix_activities_object_type'), 'activities')
    op.create_index(op.f('ix_activities_object_id_object_type'), 'activities', ['object_id', 'object_type'], unique=False)

    op.drop_index(op.f('ix_activities_sub_object_id'), 'activities')
    op.drop_index(op.f('ix_activities_sub_object_type'), 'activities')
    op.create_index(op.f('ix_activities_sub_object_id_sub_object_type'), 'activities', ['sub_object_id', 'sub_object_type'], unique=False)

    op.drop_index(op.f('ix_activities_target_id'), 'activities')
    op.drop_index(op.f('ix_activities_target_type'), 'activities')
    op.create_index(op.f('ix_activities_target_id_target_type'), 'activities', ['target_id', 'target_type'], unique=False)

    op.drop_index(op.f('ix_activities_origin_id'), 'activities')
    op.drop_index(op.f('ix_activities_origin_type'), 'activities')
    op.create_index(op.f('ix_activities_origin_id_origin_type'), 'activities', ['origin_id', 'origin_type'], unique=False)

    op.create_index(op.f('ix_activities_verb'), 'activities', ['verb'], unique=False)
    op.create_index(op.f('ix_activities_created_by_id'), 'activities', ['created_by_id'], unique=False)

    op.execute("""UPDATE activities SET project_id = cards.project_id FROM cards, card_groups
        WHERE cards.id = card_groups.parent_id AND card_groups.parent_id is not null
            AND card_groups.id = activities.object_id AND activities.object_type = 'CardGroup'""")

    op.execute("""UPDATE activities SET project_id = cards.project_id FROM cards, card_groups
        WHERE cards.id = card_groups.parent_id AND card_groups.parent_id is not null
            AND card_groups.id = activities.target_id AND activities.target_type = 'CardGroup'""")

    op.execute("""UPDATE activities SET project_id = request_forms.project_id FROM requests, request_forms
        WHERE request_forms.id = requests.request_form_id AND requests.id = activities.target_id
            AND activities.target_type = 'Request'""")

    op.execute("""UPDATE activities SET project_id = cards.project_id FROM cards
        WHERE cards.id = activities.object_id AND activities.object_type = 'Card'""")

    op.execute("""UPDATE activities SET project_id = cards.project_id FROM cards
        WHERE cards.id = activities.target_id AND activities.target_type = 'Card'""")


def downgrade():
    op.drop_index(op.f('ix_activities_project_id'), 'activities')
    op.drop_column('activities', 'project_id')
