"""requests

Revision: 0077
Revision ID: f6be47c2049
Revises: 3610446b33b5
Create Date: 2016-11-06 15:35:30.557212

"""

# revision identifiers, used by Alembic.
revision = 'f6be47c2049'
down_revision = '3610446b33b5'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.create_table('request_forms',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('project_id', sa.Integer(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('email_message', sa.Text(), nullable=True),
        sa.Column('slug', sa.String(), nullable=True),
        sa.Column('public_permission', sa.Integer(), nullable=True),
        sa.Column('allow_anonymous', sa.Boolean(), nullable=True),
        sa.Column('allow_comments', sa.Boolean(), nullable=True),
        sa.Column('tracking_group_type_id', sa.Integer(), nullable=True),
        sa.Column('add_card_to_group_id', sa.Integer(), nullable=True),
        sa.Column('ask_title', sa.Boolean(), nullable=True),
        sa.Column('title_label', sa.String(), nullable=True),
        sa.Column('card_model_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['add_card_to_group_id'], ['card_groups.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['card_model_id'], ['card_models.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['tracking_group_type_id'], ['card_group_types.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_request_forms_project_id'), 'request_forms', ['project_id'], unique=False)
    op.create_index(op.f('ix_request_forms_slug'), 'request_forms', ['slug'], unique=False)

    op.create_table('request_form_tracking_groups',
        sa.Column('request_form_id', sa.Integer(), nullable=True),
        sa.Column('group_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['group_id'], ['card_groups.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['request_form_id'], ['request_forms.id'], ondelete='CASCADE')
    )
    op.create_index(op.f('ix_request_form_tracking_groups_group_id'), 'request_form_tracking_groups', ['group_id'], unique=False)
    op.create_index(op.f('ix_request_form_tracking_groups_request_form_id'), 'request_form_tracking_groups', ['request_form_id'], unique=False)

    op.create_table('request_form_attributes',
        sa.Column('request_form_id', sa.Integer(), nullable=True),
        sa.Column('attribute_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['attribute_id'], ['attributes.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['request_form_id'], ['request_forms.id'], ondelete='CASCADE')
    )
    op.create_index(op.f('ix_request_form_attributes_attribute_id'), 'request_form_attributes', ['attribute_id'], unique=False)
    op.create_index(op.f('ix_request_form_attributes_request_form_id'), 'request_form_attributes', ['request_form_id'], unique=False)
    
    op.create_table('requests',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('request_form_id', sa.Integer(), nullable=True),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('email', sa.String(), nullable=True),
        sa.Column('token', sa.String(), nullable=True),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['request_form_id'], ['request_forms.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_requests_request_form_id'), 'requests', ['request_form_id'], unique=False)
    op.create_index(op.f('ix_requests_token'), 'requests', ['token'], unique=False)
    op.create_index(op.f('ix_requests_card_id'), 'requests', ['card_id'], unique=False)
    op.create_index(op.f('ix_requests_user_id'), 'requests', ['user_id'], unique=False)

    op.add_column('card_comments', sa.Column('show_in_request', sa.Boolean, nullable=True))
    op.create_index(op.f('ix_card_comments_show_in_request'), 'card_comments', ['show_in_request'], unique=False)
    op.execute("UPDATE card_comments SET show_in_request = false")


def downgrade():
    op.drop_index(op.f('ix_requests_request_form_id'), table_name='requests')
    op.drop_index(op.f('ix_requests_token'), table_name='requests')
    op.drop_index(op.f('ix_requests_card_id'), table_name='requests')
    op.drop_index(op.f('ix_requests_user_id'), table_name='requests')
    op.drop_table('requests')
    op.drop_index(op.f('ix_request_form_attributes_request_form_id'), table_name='request_form_attributes')
    op.drop_index(op.f('ix_request_form_attributes_attribute_id'), table_name='request_form_attributes')
    op.drop_table('request_form_attributes')
    op.drop_index(op.f('ix_request_forms_slug'), table_name='request_forms')
    op.drop_index(op.f('ix_request_forms_project_id'), table_name='request_forms')
    op.drop_table('request_forms')
