"""project_slug

Revision: 0074
Revision ID: 205096351a13
Revises: 1b3bcd25ba75
Create Date: 2016-10-04 12:10:08.029176

"""

# revision identifiers, used by Alembic.
revision = '205096351a13'
down_revision = '1b3bcd25ba75'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.add_column('projects', sa.Column('slug', sa.String(), nullable=True))
    op.create_index(op.f('ix_projects_slug'), 'projects', ['slug'], unique=True)
    op.execute("""UPDATE projects SET slug = (SELECT slug FROM cards WHERE id = projects.top_level_card_id)""")


def downgrade():
    op.drop_index(op.f('ix_projects_slug'), table_name='projects')
    op.drop_column('projects', 'slug')
