"""group_state_alias

Revision: 0068
Revision ID: 491bd448c7c8
Revises: 31f84a385d20
Create Date: 2016-08-10 16:09:04.900187

"""

# revision identifiers, used by Alembic.
revision = '491bd448c7c8'
down_revision = '31f84a385d20'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.execute("UPDATE cards SET state_alias_id = NULL")

    op.drop_index(op.f('ix_cards_state_alias_id'), table_name='cards')
    op.drop_constraint('cards_state_alias_id_fkey', 'cards')
    op.create_foreign_key(None, 'cards', 'card_groups', ['state_alias_id'], ['id'])
    op.create_index(op.f('ix_cards_state_alias_id'), 'cards', ['state_alias_id'], unique=False)
    
    op.drop_index(op.f('ix_card_state_aliases_label'), table_name='card_state_aliases')
    op.drop_index(op.f('ix_card_state_aliases_card_id'), table_name='card_state_aliases')
    op.drop_table('card_state_aliases')


def downgrade():
    pass
