"""fix behaviors

Revision: 0055
Revision ID: 50cea6671951
Revises: 4b225430041e
Create Date: 2016-04-14 19:17:31.446073

"""

# revision identifiers, used by Alembic.
revision = '50cea6671951'
down_revision = '4b225430041e'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.drop_constraint('card_behaviors_activated_by_id_fkey', 'card_behaviors', type_='foreignkey')
    op.create_foreign_key('card_behaviors_activated_by_id_fkey', 'card_behaviors', 'users', ['activated_by_id'], ['id'], ondelete='SET NULL')


def downgrade():
    op.drop_constraint('card_behaviors_activated_by_id_fkey', 'card_behaviors', type_='foreignkey')
    op.create_foreign_key('card_behaviors_enabled_by_id_fkey', 'card_behaviors', 'users', ['activated_by_id'], ['id'])
