"""views

Revision: 0051
Revision ID: 3e86e3d4ef11
Revises: 44d8f57c0e76
Create Date: 2016-03-08 19:10:41.456063

"""

# revision identifiers, used by Alembic.
revision = '3e86e3d4ef11'
down_revision = '44d8f57c0e76'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.create_table('views',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by', sa.Integer(), nullable=True),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.Column('title', sa.String(), nullable=True),
        sa.Column('icon', sa.String(), nullable=True),
        sa.Column('group_type_id', sa.Integer(), nullable=True),
        sa.Column('group_by_attribute_id', sa.Integer(), nullable=True),
        sa.Column('filter', sa.String(), nullable=True),
        sa.Column('mode', sa.String(), nullable=True),
        sa.Column('mode_options', postgresql.JSONB(), nullable=True),
        sa.Column('include_archived', sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['created_by'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['group_type_id'], ['card_group_types.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_views_card_id'), 'views', ['card_id'], unique=False)
    op.create_index(op.f('ix_views_user_id'), 'views', ['user_id'], unique=False)


def downgrade():
    op.drop_index(op.f('ix_views_user_id'), table_name='views')
    op.drop_index(op.f('ix_views_card_id'), table_name='views')
    op.drop_table('views')
