"""cards_image_cover_id

Revision: 0050
Revision ID: 44d8f57c0e76
Revises: 1336f79b826c
Create Date: 2016-03-03 11:47:53.360437

"""

# revision identifiers, used by Alembic.
revision = '44d8f57c0e76'
down_revision = '1336f79b826c'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.add_column('cards', sa.Column('image_cover_id', sa.Integer(), nullable=True))
    op.create_index(op.f('ix_cards_image_cover_id'), 'cards', ['image_cover_id'], unique=False)
    op.create_foreign_key(None, 'cards', 'card_files', ['image_cover_id'], ['id'], ondelete='SET NULL')


def downgrade():
    op.drop_index(op.f('ix_cards_image_cover_id'), table_name='cards')
    op.drop_column('cards', 'image_cover_id')
