"""more_indexes

Revision: 0047
Revision ID: 3457fda0cf2a
Revises: 381538a31a10
Create Date: 2016-02-21 14:33:32.219648

"""

# revision identifiers, used by Alembic.
revision = '3457fda0cf2a'
down_revision = '381538a31a10'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.create_index(op.f('ix_card_groups_group_type_id_parent_id'), 'card_groups',
        ['group_type_id', 'parent_id'], unique=False)
    op.create_index(op.f('idx_card_groups_cards_card_id'), 'card_groups_cards',
        ['card_id'], unique=False)
    op.create_index(op.f('idx_card_groups_cards_group_id'), 'card_groups_cards',
        ['group_id'], unique=False)
    op.create_index(op.f('idx_cards_parent_id_is_archived'), 'cards',
        ['is_archived', 'parent_id'], unique=False)


def downgrade():
    op.drop_index(op.f('idx_cards_parent_id_is_archived'), table_name='cards')
    op.drop_index(op.f('idx_card_groups_cards_group_id'), table_name='card_groups_cards')
    op.drop_index(op.f('idx_card_groups_cards_card_id'), table_name='card_groups_cards')
    op.drop_index(op.f('ix_card_groups_group_type_id_parent_id'), table_name='card_groups')
