"""can_create_projects

Revision: 0046
Revision ID: 381538a31a10
Revises: 34d8e77407
Create Date: 2016-02-12 13:52:07.229731

"""

# revision identifiers, used by Alembic.
revision = '381538a31a10'
down_revision = '34d8e77407'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.add_column('organizations', sa.Column('can_create_private_projects', sa.Boolean(), nullable=True))
    op.add_column('organizations', sa.Column('can_create_projects', sa.Boolean(), nullable=True))
    op.add_column('users', sa.Column('can_join_organizations', sa.Boolean(), nullable=True))
    op.add_column('users', sa.Column('is_observer', sa.Boolean(), nullable=True))
    op.execute("UPDATE organizations SET can_create_projects = true, can_create_private_projects = can_create_private_boards")
    op.execute("UPDATE users SET can_join_organizations = true, is_observer = false")


def downgrade():
    op.execute("UPDATE organizations SET can_create_private_boards = can_create_private_projects")
    op.drop_column('organizations', 'can_create_projects')
    op.drop_column('organizations', 'can_create_private_projects')
    op.drop_column('users', 'can_join_organizations')
    op.drop_column('users', 'is_observer')