"""group_type_display

Revision: 0032
Revision ID: 21a6d541bc0f
Revises: 3db4ee6d1d77
Create Date: 2015-11-11 15:20:54.101344

"""

# revision identifiers, used by Alembic.
revision = '21a6d541bc0f'
down_revision = '3db4ee6d1d77'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


enum_type = sa.Enum('label', 'border', name='card_group_type_display')

def upgrade():
    enum_type.create(op.get_bind(), checkfirst=False)
    op.alter_column('card_group_types', 'display_on_card', new_column_name='display_on_card2')
    op.add_column('card_group_types', sa.Column('display_on_card', enum_type, nullable=True))
    op.execute("UPDATE card_group_types SET display_on_card = 'label' WHERE display_on_card2")
    op.drop_column('card_group_types', 'display_on_card2')
    op.add_column('card_group_types', sa.Column('auto_random_color', sa.Boolean(), nullable=True))


def downgrade():
    op.drop_column('card_group_types', 'display_on_card')
    op.drop_column('card_group_types', 'auto_random_color')
    op.add_column('card_group_types', sa.Column('display_on_card', sa.Boolean(), nullable=True))
    enum_type.drop(op.get_bind(), checkfirst=False)