"""group_type_builtin

Revision: 0031
Revision ID: 3db4ee6d1d77
Revises: 11c328aaee9c
Create Date: 2015-11-06 13:15:47.394461

"""

# revision identifiers, used by Alembic.
revision = '3db4ee6d1d77'
down_revision = '11c328aaee9c'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.add_column('card_group_types', sa.Column('builtin', sa.String(), nullable=True))
    op.add_column('card_group_types', sa.Column('copied_from_id', sa.Integer(), nullable=True))
    op.create_foreign_key(None, 'card_group_types', 'card_group_types', ['copied_from_id'], ['id'], ondelete='SET NULL')
    op.create_index(op.f('ix_card_group_types_copied_from_id'), 'card_group_types', ['copied_from_id'], unique=False)

    op.execute("UPDATE card_group_types SET builtin = upper(name) WHERE name in ('Lists', 'Milestones')")

def downgrade():
    op.drop_index(op.f('ix_card_group_types_copied_from_id'), table_name='card_group_types')
    op.drop_column('card_group_types', 'copied_from_id')
    op.drop_column('card_group_types', 'builtin')
