"""card_group_type_display_on_cards

Revision: 0030
Revision ID: 11c328aaee9c
Revises: 25e88bf7445c
Create Date: 2015-11-03 21:05:05.038813

"""

# revision identifiers, used by Alembic.
revision = '11c328aaee9c'
down_revision = '25e88bf7445c'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.add_column('card_group_types', sa.Column('singular_name', sa.String(), nullable=True))
    op.add_column('card_group_types', sa.Column('plural_name', sa.String(), nullable=True))
    op.add_column('card_group_types', sa.Column('icon', sa.String(), nullable=True))
    op.add_column('card_group_types', sa.Column('display_on_card', sa.Boolean(), nullable=True))
    op.execute("UPDATE card_group_types SET display_on_card = true, icon = 'flag-checkered', singular_name = 'milestone', plural_name = 'milestones' WHERE name = 'Milestones'")
    op.execute("UPDATE card_group_types SET display_on_card = false, singular_name = 'list', plural_name = 'lists' WHERE name = 'Lists'")


def downgrade():
    op.drop_column('card_group_types', 'singular_name')
    op.drop_column('card_group_types', 'plural_name')
    op.drop_column('card_group_types', 'icon')
    op.drop_column('card_group_types', 'display_on_cards')
