"""stripe

Revision: 0026
Revision ID: 4c29125461b8
Revises: 568bf972b726
Create Date: 2015-09-21 12:07:24.890658

"""

# revision identifiers, used by Alembic.
revision = '4c29125461b8'
down_revision = '568bf972b726'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.create_table('invoices',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('ref', sa.String(), nullable=True),
        sa.Column('currency', sa.String(length=3), nullable=True),
        sa.Column('subtotal', sa.Float(), nullable=True),
        sa.Column('total', sa.Float(), nullable=True),
        sa.Column('tax_rate', sa.Float(), nullable=True),
        sa.Column('tax_amount', sa.Float(), nullable=True),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('email', sa.String(), nullable=True),
        sa.Column('address_line1', sa.String(), nullable=True),
        sa.Column('address_line2', sa.String(), nullable=True),
        sa.Column('address_city', sa.String(), nullable=True),
        sa.Column('address_state', sa.String(), nullable=True),
        sa.Column('address_zip', sa.String(), nullable=True),
        sa.Column('address_country', sa.String(), nullable=True),
        sa.Column('country', sa.String(length=2), nullable=True),
        sa.Column('customer_special_mention', sa.String(), nullable=True),
        sa.Column('issued_at', sa.DateTime(), nullable=True),
        sa.Column('charge_id', sa.String(), nullable=True),
        sa.Column('external_id', sa.String(), nullable=True),
        sa.Column('customer_id', sa.Integer(), nullable=True),
        sa.Column('is_eu_country', sa.Boolean(), nullable=True),
        sa.Column('eu_vat_number', sa.String(), nullable=True),
        sa.Column('eu_exchange_rate', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['customer_id'], ['organizations.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_invoices_customer_id'), 'invoices', ['customer_id'], unique=False)

    op.create_table('invoice_items',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('invoice_id', sa.Integer(), nullable=True),
        sa.Column('amount', sa.Float(), nullable=True),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('quantity', sa.Integer(), nullable=True),
        sa.Column('subtotal', sa.Float(), nullable=True),
        sa.Column('currency', sa.String(length=3), nullable=True),
        sa.Column('external_id', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['invoice_id'], ['invoices.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_invoice_items_invoice_id'), 'invoice_items', ['invoice_id'], unique=False)

    op.add_column('organizations', sa.Column('billing_address_city', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_address_country', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_address_line1', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_address_line2', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_address_state', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_address_zip', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_brand', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_country', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_exp_month', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_exp_year', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_ip_address', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_last4', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('billing_name', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('email', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('eu_vat_country', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('eu_vat_number', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('eu_vat_rate', sa.Float(), nullable=True))
    op.add_column('organizations', sa.Column('has_stripe_source', sa.Boolean(), nullable=True))
    op.add_column('organizations', sa.Column('plan_last_charge_amount', sa.Float(), nullable=True))
    op.add_column('organizations', sa.Column('plan_last_charge_successful', sa.Boolean(), nullable=True))
    op.add_column('organizations', sa.Column('plan_last_charged_at', sa.DateTime(), nullable=True))
    op.add_column('organizations', sa.Column('plan_name', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('plan_next_charge_at', sa.DateTime(), nullable=True))
    op.add_column('organizations', sa.Column('plan_status', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('stripe_customer_id', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('stripe_subscription_id', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('telephone', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('company', sa.String(), nullable=True))
    op.create_index(op.f('ix_organizations_trial_ends_at'), 'organizations', ['trial_ends_at'], unique=False)
    op.create_index(op.f('ix_organizations_has_stripe_source'), 'organizations', ['has_stripe_source'], unique=False)
    op.create_index(op.f('ix_organizations_plan_next_charge_at'), 'organizations', ['plan_next_charge_at'], unique=False)
    op.create_index(op.f('ix_organizations_plan_status'), 'organizations', ['plan_status'], unique=False)
    op.create_index(op.f('ix_organizations_stripe_customer_id'), 'organizations', ['stripe_customer_id'], unique=False)
    op.create_index(op.f('ix_organizations_stripe_subscription_id'), 'organizations', ['stripe_subscription_id'], unique=False)
    op.execute('UPDATE organizations SET plan_status = status')
    op.drop_column('organizations', 'status')


def downgrade():
    op.add_column('organizations', sa.Column('status', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.execute('UPDATE organizations SET status = plan_status')
    op.drop_index(op.f('ix_organizations_stripe_subscription_id'), table_name='organizations')
    op.drop_index(op.f('ix_organizations_stripe_customer_id'), table_name='organizations')
    op.drop_index(op.f('ix_organizations_plan_status'), table_name='organizations')
    op.drop_index(op.f('ix_organizations_plan_next_charge_at'), table_name='organizations')
    op.drop_index(op.f('ix_organizations_has_stripe_source'), table_name='organizations')
    op.drop_index(op.f('ix_organizations_trial_ends_at'), table_name='organizations')
    op.drop_column('organizations', 'company')
    op.drop_column('organizations', 'telephone')
    op.drop_column('organizations', 'stripe_subscription_id')
    op.drop_column('organizations', 'stripe_customer_id')
    op.drop_column('organizations', 'plan_status')
    op.drop_column('organizations', 'plan_next_charge_at')
    op.drop_column('organizations', 'plan_name')
    op.drop_column('organizations', 'plan_last_charged_at')
    op.drop_column('organizations', 'plan_last_charge_successful')
    op.drop_column('organizations', 'plan_last_charge_amount')
    op.drop_column('organizations', 'has_stripe_source')
    op.drop_column('organizations', 'eu_vat_rate')
    op.drop_column('organizations', 'eu_vat_number')
    op.drop_column('organizations', 'eu_vat_country')
    op.drop_column('organizations', 'email')
    op.drop_column('organizations', 'billing_name')
    op.drop_column('organizations', 'billing_last4')
    op.drop_column('organizations', 'billing_ip_address')
    op.drop_column('organizations', 'billing_exp_year')
    op.drop_column('organizations', 'billing_exp_month')
    op.drop_column('organizations', 'billing_country')
    op.drop_column('organizations', 'billing_brand')
    op.drop_column('organizations', 'billing_address_zip')
    op.drop_column('organizations', 'billing_address_state')
    op.drop_column('organizations', 'billing_address_line2')
    op.drop_column('organizations', 'billing_address_line1')
    op.drop_column('organizations', 'billing_address_country')
    op.drop_column('organizations', 'billing_address_city')

    op.drop_index(op.f('ix_invoice_items_invoice_id'), table_name='invoice_items')
    op.drop_table('invoice_items')
    op.drop_index(op.f('ix_invoices_customer_id'), table_name='invoices')
    op.drop_table('invoices')
