"""state_alias

Revision: 0024
Revision ID: 188181cb15ef
Revises: 47192ad682c6
Create Date: 2015-09-15 11:12:02.013563

"""

# revision identifiers, used by Alembic.
revision = '188181cb15ef'
down_revision = '47192ad682c6'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.create_table('card_state_aliases',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('label', sa.String(), nullable=True),
        sa.Column('icon', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_card_state_aliases_card_id'), 'card_state_aliases', ['card_id'], unique=False)
    op.create_index(op.f('ix_card_state_aliases_label'), 'card_state_aliases', ['label'], unique=False)
    op.add_column('cards', sa.Column('state_alias_id', sa.Integer(), nullable=True))
    op.create_foreign_key(None, 'cards', 'card_state_aliases', ['state_alias_id'], ['id'])
    op.create_index(op.f('ix_cards_state_alias_id'), 'cards', ['state_alias_id'], unique=False)


def downgrade():
    op.drop_index(op.f('ix_cards_state_alias_id'), table_name='cards')
    op.drop_column('cards', 'state_alias_id')
    op.drop_index(op.f('ix_card_state_aliases_label'), table_name='card_state_aliases')
    op.drop_index(op.f('ix_card_state_aliases_card_id'), table_name='card_state_aliases')
    op.drop_table('card_state_aliases')
