"""change_history

Revision: 0023
Revision ID: 47192ad682c6
Revises: 10cf30e1e791
Create Date: 2015-09-08 11:41:30.716768

"""

# revision identifiers, used by Alembic.
revision = '47192ad682c6'
down_revision = '10cf30e1e791'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.create_table('card_change_history',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.Column('list_id', sa.Integer(), nullable=True),
        sa.Column('list_title', sa.String(), nullable=True),
        sa.Column('state', sa.String(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['list_id'], ['card_lists.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_card_change_history_card_id'), 'card_change_history', ['card_id'], unique=False)
    op.create_index(op.f('ix_card_change_history_list_id'), 'card_change_history', ['list_id'], unique=False)
    op.create_index(op.f('ix_card_change_history_state'), 'card_change_history', ['state'], unique=False)
    op.create_index(op.f('ix_card_change_history_created_at'), 'card_change_history', ['created_at'], unique=False)
    
    op.add_column('board_template_lists', sa.Column('card_state', sa.String(), nullable=True))
    op.add_column('card_lists', sa.Column('card_state', sa.String(), nullable=True))
    op.add_column('cards', sa.Column('state', sa.String(), nullable=True))
    op.create_index(op.f('ix_cards_state'), 'cards', ['state'], unique=False)

    op.execute(("INSERT INTO card_change_history (card_id, list_id, created_at, created_by_id) "
        "SELECT s.card_id, l.id, s.created_at, u.id FROM stream s JOIN card_lists l ON l.id = s.subject_id "
        "LEFT JOIN users u ON u.id = s.created_by_id WHERE item_type='activity' AND label='created'"))

    op.execute(("INSERT INTO card_change_history (card_id, list_id, created_at, created_by_id) "
        "SELECT s.card_id, l.id, s.created_at, u.id FROM stream s JOIN card_lists l ON l.id = s.subject_id "
        "LEFT JOIN users u ON u.id = s.created_by_id WHERE item_type='activity' AND label='moved' "
        "AND message='{user} moved {target} to {subject}' ORDER BY s.id"))
    op.execute("UPDATE card_change_history SET list_title = (SELECT title FROM card_lists WHERE id = card_change_history.list_id)")

    op.execute("UPDATE board_template_lists SET card_state = 'completed' WHERE mark_card_as_done")
    op.execute("UPDATE card_lists SET card_state = 'completed' WHERE mark_card_as_done")
    op.execute("UPDATE cards SET state = 'undecided'")
    op.execute("UPDATE cards SET state = 'completed' WHERE done")
    op.execute("INSERT INTO card_change_history (card_id, state, created_at) SELECT id, 'undecided', created_at FROM cards")
    op.execute("INSERT INTO card_change_history (card_id, state, created_at) SELECT id, 'completed', done_at FROM cards WHERE done")

    op.alter_column('cards', 'state', nullable=False)


def downgrade():
    op.drop_index(op.f('ix_card_change_history_created_at'), table_name='card_change_history')
    op.drop_index(op.f('ix_card_change_history_list_id'), table_name='card_change_history')
    op.drop_index(op.f('ix_card_change_history_card_id'), table_name='card_change_history')
    op.drop_index(op.f('ix_card_change_history_state'), table_name='card_change_history')
    op.drop_table('card_change_history')

    op.drop_index(op.f('ix_cards_state'), table_name='cards')
    op.drop_column('cards', 'state')
    op.drop_column('card_lists', 'card_state')
    op.drop_column('board_template_lists', 'card_state')
