"""refactoring_members

Revision: 0021
Revision ID: d4628b068b5
Revises: 51ef836d17f
Create Date: 2015-08-21 14:16:56.533919

"""

# revision identifiers, used by Alembic.
revision = 'd4628b068b5'
down_revision = '51ef836d17f'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('card_member_permissions',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('member_id', sa.Integer(), nullable=True),
    sa.Column('card_id', sa.Integer(), nullable=True),
    sa.Column('permission', sa.Integer(), nullable=True),
    sa.Column('created_by_id', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['member_id'], ['card_members.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_card_member_permissions_card_id'), 'card_member_permissions', ['card_id'], unique=False)
    op.create_index(op.f('ix_card_member_permissions_member_id'), 'card_member_permissions', ['member_id'], unique=False)
    op.create_index(op.f('ix_card_member_permissions_permission'), 'card_member_permissions', ['permission'], unique=False)
    op.add_column('card_members', sa.Column('email', sa.String(), nullable=True))
    op.create_index(op.f('ix_card_members_email'), 'card_members', ['email'], unique=False)
    op.drop_index('ix_card_members_permission', table_name='card_members')
    op.add_column('cards', sa.Column('members_cache_id', sa.String(), nullable=True))
    op.add_column('organization_members', sa.Column('email', sa.String(), nullable=True))
    op.create_index(op.f('ix_organization_members_email'), 'organization_members', ['email'], unique=False)
    op.add_column('users', sa.Column('perm_cache_id', sa.String(), nullable=True))
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('users', 'perm_cache_id')
    op.drop_index(op.f('ix_organization_members_email'), table_name='organization_members')
    op.drop_column('organization_members', 'email')
    op.drop_column('cards', 'members_cache_id')
    op.create_index('ix_card_members_permission', 'card_members', ['permission'], unique=False)
    op.drop_index(op.f('ix_card_members_email'), table_name='card_members')
    op.drop_column('card_members', 'email')
    op.drop_index(op.f('ix_card_member_permissions_permission'), table_name='card_member_permissions')
    op.drop_index(op.f('ix_card_member_permissions_member_id'), table_name='card_member_permissions')
    op.drop_index(op.f('ix_card_member_permissions_card_id'), table_name='card_member_permissions')
    op.drop_table('card_member_permissions')
    ### end Alembic commands ###
