"""add mongo_id columns for migration

Revision: 0002
Revision ID: 8c4d6851928
Revises: 34eb10cee620
Create Date: 2015-06-03 20:27:44.740583

"""

# revision identifiers, used by Alembic.
revision = '8c4d6851928'
down_revision = '34eb10cee620'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.add_column('board_templates', sa.Column('mongo_id', sa.String(length=24), nullable=True))
    op.add_column('card_lists', sa.Column('mongo_id', sa.String(length=24), nullable=True))
    op.add_column('card_models', sa.Column('mongo_id', sa.String(length=24), nullable=True))
    op.add_column('cards', sa.Column('mongo_id', sa.String(length=24), nullable=True))
    op.add_column('milestones', sa.Column('mongo_id', sa.String(length=24), nullable=True))
    op.add_column('organizations', sa.Column('mongo_id', sa.String(length=24), nullable=True))
    op.add_column('users', sa.Column('mongo_id', sa.String(length=24), nullable=True))
    op.create_index(op.f('ix_users_mongo_id'), 'users', ['mongo_id'], unique=False)
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_users_mongo_id'), table_name='users')
    op.drop_column('users', 'mongo_id')
    op.drop_column('organizations', 'mongo_id')
    op.drop_column('milestones', 'mongo_id')
    op.drop_column('cards', 'mongo_id')
    op.drop_column('card_models', 'mongo_id')
    op.drop_column('card_lists', 'mongo_id')
    op.drop_column('board_templates', 'mongo_id')
    ### end Alembic commands ###
