"""Add updated_at and last_activity_at fields

Revision: 0001
Revision ID: 34eb10cee620
Revises: d45177564c9
Create Date: 2015-06-03 15:21:22.002183

"""

# revision identifiers, used by Alembic.
revision = '34eb10cee620'
down_revision = 'd45177564c9'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.add_column('board_templates', sa.Column('created_at', sa.DateTime(), nullable=True))
    op.add_column('board_templates', sa.Column('created_by_id', sa.Integer(), nullable=True))
    op.add_column('board_templates', sa.Column('updated_at', sa.DateTime(), nullable=True))
    op.create_foreign_key(None, 'board_templates', 'users', ['created_by_id'], ['id'])
    op.add_column('card_attributes', sa.Column('updated_at', sa.DateTime(), nullable=True))
    op.add_column('card_lists', sa.Column('updated_at', sa.DateTime(), nullable=True))
    op.add_column('card_members', sa.Column('updated_at', sa.DateTime(), nullable=True))
    op.add_column('card_models', sa.Column('created_at', sa.DateTime(), nullable=True))
    op.add_column('card_models', sa.Column('updated_at', sa.DateTime(), nullable=True))
    op.add_column('cards', sa.Column('last_activity_at', sa.DateTime(), nullable=True))
    op.add_column('cards', sa.Column('updated_at', sa.DateTime(), nullable=True))
    op.create_index(op.f('ix_cards_last_activity_at'), 'cards', ['last_activity_at'], unique=False)
    op.add_column('milestones', sa.Column('updated_at', sa.DateTime(), nullable=True))
    op.add_column('organizations', sa.Column('updated_at', sa.DateTime(), nullable=True))
    op.add_column('organization_members', sa.Column('updated_at', sa.DateTime(), nullable=True))
    op.add_column('users', sa.Column('updated_at', sa.DateTime(), nullable=True))
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('users', 'updated_at')
    op.drop_column('organization_members', 'updated_at')
    op.drop_column('organizations', 'updated_at')
    op.drop_column('milestones', 'updated_at')
    op.drop_index(op.f('ix_cards_last_activity_at'), table_name='cards')
    op.drop_column('cards', 'updated_at')
    op.drop_column('cards', 'last_activity_at')
    op.drop_column('card_models', 'updated_at')
    op.drop_column('card_models', 'created_at')
    op.drop_column('card_members', 'updated_at')
    op.drop_column('card_lists', 'updated_at')
    op.drop_column('card_attributes', 'updated_at')
    op.drop_constraint(None, 'board_templates', type_='foreignkey')
    op.drop_column('board_templates', 'updated_at')
    op.drop_column('board_templates', 'created_by_id')
    op.drop_column('board_templates', 'created_at')
    ### end Alembic commands ###
