"""Init db

Revision: 0000
Revision ID: d45177564c9
Revises: 
Create Date: 2015-06-01 17:42:30.683311

"""

# revision identifiers, used by Alembic.
revision = 'd45177564c9'
down_revision = None
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.create_table('users',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('signup_at', sa.DateTime(), nullable=True),
        sa.Column('signup_from', sa.String(), nullable=True),
        sa.Column('signup_provider', sa.String(), nullable=True),
        sa.Column('auth_providers', postgresql.ARRAY(sa.String()), nullable=True),
        sa.Column('last_login_at', sa.DateTime(), nullable=True),
        sa.Column('last_login_from', sa.String(), nullable=True),
        sa.Column('last_login_provider', sa.String(), nullable=True),
        sa.Column('username', sa.String(), nullable=True),
        sa.Column('email', sa.String(), nullable=True),
        sa.Column('password', sa.String(), nullable=True),
        sa.Column('avatar_filename', sa.String(), nullable=True),
        sa.Column('unread_notifications', sa.Integer(), nullable=True),
        sa.Column('trello_oauth_token', sa.String(), nullable=True),
        sa.Column('trello_oauth_token_secret', sa.String(), nullable=True),
        sa.Column('trello_user_id', sa.String(), nullable=True),
        sa.Column('trello_username', sa.String(), nullable=True),
        sa.Column('github_access_token', sa.String(), nullable=True),
        sa.Column('github_username', sa.String(), nullable=True),
        sa.Column('github_id', sa.String(), nullable=True),
        sa.Column('github_email', sa.String(), nullable=True),
        sa.Column('asana_token', sa.String(), nullable=True),
        sa.Column('asana_name', sa.String(), nullable=True),
        sa.Column('asana_id', sa.String(), nullable=True),
        sa.Column('asana_email', sa.String(), nullable=True),
        sa.Column('can_create_organizations', sa.Boolean(), nullable=True),
        sa.Column('locale', sa.String(), nullable=True),
        sa.Column('timezone', sa.String(), nullable=True),
        sa.Column('currency', sa.String(), nullable=True),
        sa.Column('enable_email_notifications', sa.Boolean(), nullable=True),
        sa.Column('user_org_id', sa.Integer(), nullable=True),
        sa.Column('is_special_user', sa.Boolean(), nullable=True),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('email'),
        sa.UniqueConstraint('username')
    )
    op.create_index(op.f('ix_users_asana_id'), 'users', ['asana_id'], unique=False)
    op.create_index(op.f('ix_users_github_id'), 'users', ['github_id'], unique=False)
    op.create_index(op.f('ix_users_is_special_user'), 'users', ['is_special_user'], unique=False)
    op.create_index(op.f('ix_users_trello_user_id'), 'users', ['trello_user_id'], unique=False)

    op.create_table('organizations',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('is_user_org', sa.Boolean(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('default_card_model_id', sa.Integer(), nullable=True),
        sa.Column('can_invite_guest_collabs', sa.Boolean(), nullable=True),
        sa.Column('can_create_private_boards', sa.Boolean(), nullable=True),
        sa.Column('trial_ends_at', sa.DateTime(), nullable=True),
        sa.Column('status', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_foreign_key(None, 'users', 'organizations', ['user_org_id'], ['id'])

    op.create_table('organization_members',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('org_id', sa.Integer(), nullable=True),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('permission', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['org_id'], ['organizations.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )

    op.create_table('api_keys',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('value', sa.String(), nullable=True),
        sa.Column('last_accessed_at', sa.DateTime(), nullable=True),
        sa.Column('last_accessed_from', sa.String(), nullable=True),
        sa.Column('expires_at', sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('value')
    )

    op.create_table('board_templates',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('owner_id', sa.Integer(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('builtin', sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(['owner_id'], ['organizations.id'], ),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_board_templates_builtin'), 'board_templates', ['builtin'], unique=False)
    op.create_index(op.f('ix_board_templates_name'), 'board_templates', ['name'], unique=False)

    op.create_table('board_template_lists',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('board_template_id', sa.Integer(), nullable=True),
        sa.Column('title', sa.String(), nullable=True),
        sa.Column('bgcolor', sa.String(length=7), nullable=True),
        sa.Column('show_flow_indicator', sa.Boolean(), nullable=True),
        sa.Column('mark_card_as_done', sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(['board_template_id'], ['board_templates.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )

    op.create_table('card_models',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('owner_id', sa.Integer(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('builtin', sa.Boolean(), nullable=True),
        sa.Column('listable', sa.Boolean(), nullable=True),
        sa.Column('available_for_all', sa.Boolean(), nullable=True),
        sa.Column('extends_id', sa.Integer(), nullable=True),
        sa.Column('board_template_id', sa.Integer(), nullable=True),
        sa.Column('children_default_model_id', sa.Integer(), nullable=True),
        sa.Column('indicator', sa.String(), nullable=True),
        sa.Column('card_color', sa.String(length=7), nullable=True),
        sa.Column('created_in_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['board_template_id'], ['board_templates.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['owner_id'], ['organizations.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_card_models_builtin'), 'card_models', ['builtin'], unique=False)
    op.create_index(op.f('ix_card_models_name'), 'card_models', ['name'], unique=False)
    op.create_foreign_key(None, 'card_models', 'card_models', ['extends_id'], ['id'], ondelete='SET NULL')
    op.create_foreign_key(None, 'card_models', 'card_models', ['children_default_model_id'], ['id'], ondelete='SET NULL')
    op.create_foreign_key(None, 'organizations', 'card_models', ['default_card_model_id'], ['id'], ondelete='SET NULL')

    op.create_table('card_model_attributes',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('card_model_id', sa.Integer(), nullable=True),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('title', sa.String(), nullable=True),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('type_name', sa.String(), nullable=True),
        sa.Column('container', sa.String(), nullable=True),
        sa.Column('position', sa.Integer(), nullable=True),
        sa.Column('options', sa.PickleType(), nullable=True),
        sa.Column('default_value', sa.PickleType(), nullable=True),
        sa.ForeignKeyConstraint(['card_model_id'], ['card_models.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_card_model_attributes_position'), 'card_model_attributes', ['position'], unique=False)
    op.create_index(op.f('ix_card_model_attributes_type_name'), 'card_model_attributes', ['type_name'], unique=False)

    op.create_table('cards',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('owner_id', sa.Integer(), nullable=True),
        sa.Column('parent_id', sa.Integer(), nullable=True),
        sa.Column('parents_ids', postgresql.ARRAY(sa.Integer()), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('is_link', sa.Boolean(), nullable=True),
        sa.Column('link_to_id', sa.Integer(), nullable=True),
        sa.Column('link_has_own_attributes', sa.Boolean(), nullable=True),
        sa.Column('ref', sa.Integer(), nullable=True),
        sa.Column('ref_counter', sa.Integer(), nullable=True),
        sa.Column('title', sa.String(), nullable=True),
        sa.Column('slug', sa.String(), nullable=True),
        sa.Column('model_id', sa.Integer(), nullable=True),
        sa.Column('default_child_card_model_id', sa.Integer(), nullable=True),
        sa.Column('list_id', sa.Integer(), nullable=True),
        sa.Column('list_position', sa.Integer(), nullable=True),
        sa.Column('public_permission', sa.Integer(), nullable=True),
        sa.Column('org_members_can_observe', sa.Boolean(), nullable=True),
        sa.Column('org_members_can_autojoin', sa.Boolean(), nullable=True),
        sa.Column('default_org_member_permission', sa.Integer(), nullable=True),
        sa.Column('is_archived', sa.Boolean(), nullable=True),
        sa.Column('is_list_archived', sa.Boolean(), nullable=True),
        sa.Column('is_parent_archived', sa.Integer(), nullable=True),
        sa.Column('archived_at', sa.DateTime(), nullable=True),
        sa.Column('meta', postgresql.JSONB(), nullable=True),
        sa.Column('children_attributes_ctx', sa.PickleType(), nullable=True),
        sa.Column('cache_id', sa.String(), nullable=True),
        sa.Column('board_bgcolor', sa.String(), nullable=True),
        sa.Column('done', sa.Boolean(), nullable=True),
        sa.Column('done_at', sa.DateTime(), nullable=True),
        sa.Column('reopened', sa.Boolean(), nullable=True),
        sa.Column('milestone_id', sa.Integer(), nullable=True),
        sa.Column('image_cover_url', sa.String(), nullable=True),
        sa.Column('board_created', sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['default_child_card_model_id'], ['card_models.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['link_to_id'], ['cards.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['model_id'], ['card_models.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['owner_id'], ['organizations.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('slug')
    )
    op.create_index(op.f('ix_cards_archived_at'), 'cards', ['archived_at'], unique=False)
    op.create_index(op.f('ix_cards_board_created'), 'cards', ['board_created'], unique=False)
    op.create_index(op.f('ix_cards_done'), 'cards', ['done'], unique=False)
    op.create_index(op.f('ix_cards_done_at'), 'cards', ['done_at'], unique=False)
    op.create_index(op.f('ix_cards_is_archived'), 'cards', ['is_archived'], unique=False)
    op.create_index(op.f('ix_cards_is_list_archived'), 'cards', ['is_list_archived'], unique=False)
    op.create_index(op.f('ix_cards_is_parent_archived'), 'cards', ['is_parent_archived'], unique=False)
    op.create_index(op.f('ix_cards_list_position'), 'cards', ['list_position'], unique=False)
    op.create_index(op.f('ix_cards_meta'), 'cards', ['meta'], unique=False)
    op.create_index(op.f('ix_cards_parents_ids'), 'cards', ['parents_ids'], unique=False)
    op.create_index(op.f('ix_cards_ref'), 'cards', ['ref'], unique=False)
    op.create_index(op.f('ix_cards_reopened'), 'cards', ['reopened'], unique=False)
    op.create_foreign_key(None, 'cards', 'cards', ['parent_id'], ['id'], ondelete='CASCADE')
    op.create_foreign_key(None, 'card_models', 'cards', ['created_in_id'], ['id'], ondelete='SET NULL')
    op.create_foreign_key(None, 'card_model_attributes', 'cards', ['card_id'], ['id'], ondelete='CASCADE')

    op.create_table('card_subscriptions',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('auto', sa.Boolean(), nullable=True),
        sa.Column('send_emails', sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )

    op.create_table('card_attributes',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('type_name', sa.String(), nullable=True),
        sa.Column('value', postgresql.JSONB(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_card_attributes_name'), 'card_attributes', ['name'], unique=False)
    op.create_index(op.f('ix_card_attributes_type_name'), 'card_attributes', ['type_name'], unique=False)
    op.create_index(op.f('ix_card_attributes_value'), 'card_attributes', ['value'], unique=False)

    op.create_table('card_behaviors',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.Column('enabled_by_id', sa.Integer(), nullable=True),
        sa.Column('enabled_at', sa.DateTime(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('options', postgresql.JSONB(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['enabled_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_card_behaviors_name'), 'card_behaviors', ['name'], unique=False)

    op.create_table('card_enabled_models',
        sa.Column('model_id', sa.Integer(), nullable=True),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['model_id'], ['card_models.id'], ondelete='CASCADE')
    )

    op.create_table('card_lists',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('parent_id', sa.Integer(), nullable=True),
        sa.Column('title', sa.String(), nullable=True),
        sa.Column('parents_ids', postgresql.ARRAY(sa.Integer()), nullable=True),
        sa.Column('position', sa.Integer(), nullable=True),
        sa.Column('is_archived', sa.Boolean(), nullable=True),
        sa.Column('is_parent_archived', sa.Integer(), nullable=True),
        sa.Column('archived_at', sa.DateTime(), nullable=True),
        sa.Column('meta', sa.PickleType(), nullable=True),
        sa.Column('bgcolor', sa.String(), nullable=True),
        sa.Column('show_flow_indicator', sa.Boolean(), nullable=True),
        sa.Column('mark_card_as_done', sa.Boolean(), nullable=True),
        sa.Column('default_card_model_id', sa.Integer(), nullable=True),
        sa.Column('auto_assign_user', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['default_card_model_id'], ['card_models.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['parent_id'], ['cards.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_card_lists_archived_at'), 'card_lists', ['archived_at'], unique=False)
    op.create_index(op.f('ix_card_lists_is_archived'), 'card_lists', ['is_archived'], unique=False)
    op.create_index(op.f('ix_card_lists_parents_ids'), 'card_lists', ['parents_ids'], unique=False)
    op.create_index(op.f('ix_card_lists_position'), 'card_lists', ['position'], unique=False)
    op.create_foreign_key(None, 'cards', 'card_lists', ['list_id'], ['id'], ondelete='CASCADE')

    op.create_table('card_members',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('permission', sa.Integer(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )

    op.create_table('milestones',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('parent_id', sa.Integer(), nullable=True),
        sa.Column('ref', sa.Integer(), nullable=True),
        sa.Column('title', sa.String(), nullable=True),
        sa.Column('start_date', sa.DateTime(), nullable=True),
        sa.Column('end_date', sa.DateTime(), nullable=True),
        sa.Column('color', sa.String(length=7), nullable=True),
        sa.Column('closed', sa.Boolean(), nullable=True),
        sa.Column('cache_id', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_milestones_closed'), 'milestones', ['closed'], unique=False)
    op.create_index(op.f('ix_milestones_end_date'), 'milestones', ['end_date'], unique=False)
    op.create_index(op.f('ix_milestones_ref'), 'milestones', ['ref'], unique=False)
    op.create_foreign_key(None, 'cards', 'milestones', ['milestone_id'], ['id'], ondelete='SET NULL')
    op.create_foreign_key(None, 'milestones', 'cards', ['parent_id'], ['id'], ondelete='CASCADE')

    op.create_table('stream',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('item_type', sa.String(length=10), nullable=True),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.Column('message', sa.Text(), nullable=True),
        sa.Column('is_pinned', sa.Boolean(), nullable=True),
        sa.Column('label', sa.String(), nullable=True),
        sa.Column('subject_type', sa.String(), nullable=True),
        sa.Column('subject_id', sa.Integer(), nullable=True),
        sa.Column('subject_value', sa.PickleType(), nullable=True),
        sa.Column('args', sa.PickleType(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_stream_is_pinned'), 'stream', ['is_pinned'], unique=False)
    op.create_index(op.f('ix_stream_item_type'), 'stream', ['item_type'], unique=False)

    op.create_table('invites',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('email', sa.String(), nullable=True),
        sa.Column('org_id', sa.Integer(), nullable=True),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.Column('params', sa.PickleType(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['org_id'], ['organizations.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_invites_email'), 'invites', ['email'], unique=False)

    op.create_table('users_pins',
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('card_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['card_id'], ['cards.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE')
    )


def downgrade():
    op.drop_table('users_pins')
    op.drop_index(op.f('ix_users_trello_user_id'), table_name='users')
    op.drop_index(op.f('ix_users_is_special_user'), table_name='users')
    op.drop_index(op.f('ix_users_github_id'), table_name='users')
    op.drop_index(op.f('ix_users_asana_id'), table_name='users')
    op.drop_table('users')
    op.drop_index(op.f('ix_stream_item_type'), table_name='stream')
    op.drop_index(op.f('ix_stream_is_pinned'), table_name='stream')
    op.drop_table('stream')
    op.drop_table('organization_members')
    op.drop_table('organizations')
    op.drop_index(op.f('ix_milestones_ref'), table_name='milestones')
    op.drop_index(op.f('ix_milestones_end_date'), table_name='milestones')
    op.drop_index(op.f('ix_milestones_closed'), table_name='milestones')
    op.drop_table('milestones')
    op.drop_index(op.f('ix_invites_email'), table_name='invites')
    op.drop_table('invites')
    op.drop_index(op.f('ix_cards_reopened'), table_name='cards')
    op.drop_index(op.f('ix_cards_ref'), table_name='cards')
    op.drop_index(op.f('ix_cards_parents_ids'), table_name='cards')
    op.drop_index(op.f('ix_cards_meta'), table_name='cards')
    op.drop_index(op.f('ix_cards_list_position'), table_name='cards')
    op.drop_index(op.f('ix_cards_is_parent_archived'), table_name='cards')
    op.drop_index(op.f('ix_cards_is_list_archived'), table_name='cards')
    op.drop_index(op.f('ix_cards_is_archived'), table_name='cards')
    op.drop_index(op.f('ix_cards_done_at'), table_name='cards')
    op.drop_index(op.f('ix_cards_done'), table_name='cards')
    op.drop_index(op.f('ix_cards_board_created'), table_name='cards')
    op.drop_index(op.f('ix_cards_archived_at'), table_name='cards')
    op.drop_table('cards')
    op.drop_table('card_subscriptions')
    op.drop_index(op.f('ix_card_models_name'), table_name='card_models')
    op.drop_index(op.f('ix_card_models_builtin'), table_name='card_models')
    op.drop_table('card_models')
    op.drop_index(op.f('ix_card_model_attributes_type_name'), table_name='card_model_attributes')
    op.drop_index(op.f('ix_card_model_attributes_position'), table_name='card_model_attributes')
    op.drop_table('card_model_attributes')
    op.drop_table('card_members')
    op.drop_index(op.f('ix_card_lists_position'), table_name='card_lists')
    op.drop_index(op.f('ix_card_lists_parents_ids'), table_name='card_lists')
    op.drop_index(op.f('ix_card_lists_is_archived'), table_name='card_lists')
    op.drop_index(op.f('ix_card_lists_archived_at'), table_name='card_lists')
    op.drop_table('card_lists')
    op.drop_table('card_enabled_models')
    op.drop_index(op.f('ix_card_behaviors_name'), table_name='card_behaviors')
    op.drop_table('card_behaviors')
    op.drop_index(op.f('ix_card_attributes_value'), table_name='card_attributes')
    op.drop_index(op.f('ix_card_attributes_type_name'), table_name='card_attributes')
    op.drop_index(op.f('ix_card_attributes_name'), table_name='card_attributes')
    op.drop_table('card_attributes')
    op.drop_index(op.f('ix_board_templates_name'), table_name='board_templates')
    op.drop_index(op.f('ix_board_templates_builtin'), table_name='board_templates')
    op.drop_table('board_templates')
    op.drop_table('board_template_lists')
    op.drop_table('api_keys')
