#!/bin/bash

export KANTREE_SKIP_CONFIG_CHECK=1

CONFIG_FILE=${CONFIG_FILE:-/app/config-docker.yml}

DB_HOST=${DB_HOST:-postgres}
DB_PORT=${DB_PORT:-5432}
DB_USER=${DB_USER:-postgres}
DB_NAME=${DB_NAME:-${DB_USER}}

REDIS_HOST=${REDIS_HOST:-redis}
REDIS_PORT=${REDIS_PORT:-6379}
REDIS_DB=${REDIS_DB:-0}

if [ -z "$KANTREE_NO_DOCKER_CONF" ]; then
  cat > $CONFIG_FILE <<EOL
upload_dir: /uploads
database_uri: postgresql://${DB_USER}:${DB_PASSWORD}@${DB_HOST}:${DB_PORT}/${DB_NAME}
redis_uri: redis://${REDIS_HOST}:${REDIS_PORT}/${REDIS_DB}
EOL
fi

/app/platform "$@"
