# Kantree Changelog


## 10.6.9 (2025-10-09)

### Features
 - Introduced actions toolbar in cards. Action buttons can be filtered using a KQL expression or for specific roles. Includes a small rework of the automations interface.
 - Drag & drop images in rich text or comments now use the insert image toolbar item for better integration.
 - Updated add view modal UI for improved user experience.

### Fixes
 - Fixed batch actions on selected cards that could not be opened anymore.
 - Fixed an issue with drag and drop of files in rich text editor and comments.
 - Improved performance optimizations on import.
 - Fixed workspace copy issues with automation actions sub sequences and relationship field options.
 - Fixed workspace copy of card toolbars.
 - Prevented metadata in title when creating cards through automation (#label, @member ...).
 - Fixed occasional display issues on views when updating workspace appearance or guide.
 - Fixed performance issue when updating workspace color with a view grouped by members opened.
 - Fixed issue with cardModel not found on some actions in Kantree (leading to desynchronized offline data).
 - Fixed color of category input not readable when theme name is 'topbar'.
 - Fixed issue where double clicking or using the rename option didn't work.
 - Fixed admin panel oauth editor where keys were not showing.
 - Fixed imports that did not trigger automations.
 - Fixed issue where bullet points in rich text fields don't show in table view.
 - [Self-hosted] Fixed issue when exporting an organization where team workspaces were not correctly exported.


## 10.6.8 (2025-09-09)

### Features
 - New UI for query charts: Filter and computation now have their own dedicated inputs
 - Added option in members field to filter users by role

### Fixes
 - Fixed bug where the selected model was not displayed in automation rules or relationship field options
 - Attributes are no longer highlighted on card type switch
 - Card move button is now correctly labeled "duplicate then move" when "keep a copy" is toggled on
 - Fixed {id} KQL attribute that was not working anymore
 - Fixed issue where calling automation from another automation was losing the real current user
 - Sub-board views are now copied/moved when copying cards or moving them to another project 


## 10.6.7 (2025-08-27)

### Features
 - Added a "rename" entry to attribute widget options menu
 - Added batch action for card types
 - Added new file field options: Limit file types and limit max file size
 - Added "does not include" operator for Labels fields in filter builder

### Fixes
 - When deleting a project, it is properly removed from the list in organization hub 
 - Fixed card background in iframe
 - Fixed an issue on forms where newly added/removed form fields were not editable
 - Fixed an issue on forms where "Text content" static field was not displayed
 - Show KQL results in editor for "0"
 - Fixed a bug in automation editor where "Switch card type" field doesn't show value 
 - Fixed a widescreen issue on card fields display
 - Fixed an issue with filtering "group by" options in portfolio
 - In charts, only show decimals on the Y-axis when data is float
 - When sorting cards, nulls will always be last
 - Removed the possibility of adding members with no role to a Workspace
 - Fixed an issue with KQL editor results preview not working in some cases
 - Fixed multiple issue in Workspace copy (some field options and some automation rules blocks were not copied correctly)
 - Fixed an issue on filter builder with "today"operator on date fields

## 10.6.6 (2025-07-30)

### Features

 - Enhanced highlighting and management of required options when creating new fields.
 - When configuring relationship or dependency fields, you can now restrict search and card creation to a specific card type.
 - Added a "Show in full screen" option in the appearance menu: Users can now expand views to full screen for improved focus and usability.
 - Added a "Community" link to the help modal: Users can now access the Kantree community directly from the help section.

### Fixes

#### Automations
 - Fixed automation duplication to re-map IDs: When duplicating workspaces with automation rules, all internal references and IDs are now properly updated to prevent issues.
 - Ensured user context is not preserved in automations triggered by other automations: Automations triggered during the execution of another automation no longer inherit the user context, restoring expected behavior.
 - Improved automation stability.

#### UI/UX & Display
 - Special character "&" is now correctly rendered in the UI.
 - Improved the card field drop zone in the card modal sidebar when empty: The drag-and-drop area is now more visible and user-friendly when no items are present.
 - Fixed default avatars in the card activity stream: User avatars now display correctly in card activity streams, even when using default images.
 - Cards now appear in the calendar view: Resolved an issue where cards were missing from the calendar display.
 - The bidirectional option of relationship fields can now be reset.

#### Miscellaneous
 - Improved loading performance in workspaces with dozens of members.


## 10.6.5 (2025-07-01)

### Features
 - Added action buttons to the topbar and the ability to lock a view's configuration
 - Introduced a new date picker supporting single date selection, range selection, and precision units
 - Added the option to delete cards during import
 - Display an indicator when a long-running automation is in progress
 - Added an iteration loop block for automations
 - Configure field visibility for sub-cards in Kanban and Checklist views
 - Integrated a new PDF viewer with improved performance and features

### Fixes

#### Quadrant View
 - Multiple fixes for the Quadrant view:
   - Added an animation when no axis pair is selected
   - Object and zone positions/sizes now adapt to dynamic quadrant size changes
   - Major performance improvements
   - Removed ghost objects
   - Fixed formula field handling
   - Fixed point size management

#### UI/UX & Display
 - The "Show Archives" button is now visible in the Team Hub
 - Fixed column width issues in table view
 - Corrected date display in Lookup fields
 - Fixed display issues in the recurring card menu
 - Subcards are now displayed when opening archived cards from a table view
 - Toggling the "Strike done cards" option in the calendar view now works as expected
 - The view menu can now be opened on inbox views
 - Fixed the location field by enabling the use of an interactive map
 - Resolved an issue preventing card editing when created from the topbar shortcut

#### Permissions & Roles
 - Removed the ability to change the role of a guest invited by email who does not have a Kantree account yet
 - Fixed project member roles for projects moved between organizations

#### Data & Sync
 - Logs are now loaded correctly in the logs view
 - Fixed scoping issues with collected variables
 - Card copy now triggers the "card created" event and updates the project cards cache
 - Personal Workspaces are now correctly counted in the User Admin Page

#### Integrations & Endpoints
 - OAuth server issues resolved
 - The /export/json and /org/search endpoints now work when filters are provided


## 10.6.4 (2025-04-28)

### Features
 - Add a new iframe field. Open an external URL inside you card.
 - Improve the "set field from formula" auto action by refactoring user vars to not only be string based
 - Add "Capture IP" in forms dynamic fields
 - Add {archived at} field in kql, added archived related automation triggers
 - Add ARRAY_JOIN, ARRAY_REMOVE, ARRAY_MERGE, ARRAY_DISTINCT and SPLIT KQL functions to manipulate list of members or labels
 - Add REGEX KQL function to extract data from text fields
 - Add with_time option to AS_DATERANGE KQL function
 - Add MONTH_NUMBER([Date]) and YEAR([Date]) to KQL functions
 - [Technical] Group by in charts is now performed in 2 steps to allow any kind of KQL queries


### Fixes
 - Fix for email localization when default_locale is set
 - Deactivate Print action for timeline view temporarily (until we rework it to use gantt component)
 - Showing title of card when sharing as qrcode
 - Fix the lock to show when it actually locked and added a description
 - File explorer no longer opens twice on chrome, better attachement settings visibility & image icon
 - public_template_library config was not correctly applied leading to workspace access issue 
 - Issue on card creation when a multiple choices field has a default value
 - Several icons were not shown across the app
 - Canceling the creation of a new context doesn't create a new context with the name 'False' anymore
 - In KQL, Handle empty values in as_number() and fix FIRST() in aggregation function like SUM()
 - Canceling the creation of a new card type doesn't create a new card type with the name 'False' anymore
 - Can now remove icon from group list (labels for ex)
 - In automated action "Send email", there was an issue when aborting the creation of a new email template 
 - In email template editor there was an issue with text containing @ 
 - In automation rule, "set field" action was mistakenly marked as non editable in the last release
 - On dashboard "Query" widget, grouping options cannot be cleared 
 - Issues on card position after relocate call
 - In a query widget with a selected grouping, handle cases where there is no card in some groups or where an Error occured in some groups  
 - Workspace settings button was not available on org hub 
 - Select image from existing files was not working in comment/richtext editors 
 - On firefox, download files from pdf viewer does not work
 - Some fixes to missing translations
 - Fix "set field from formula" action category
 - typo in french translation
 - [Self-hosted][Technical] Only check NEW_USERS_LIMIT_DOMAINS and NEW_USERS_BLOCK_DOMAINS config key on signup


## 10.6.3 (2025-02-11)

 - Update French translation

## 10.6.2 (2025-02-07)

### Features
 - Workspace structure can now be locked in settings. Card types and fields won't be editable while this option is enabled 
 - View can be hidden for specific user Roles (but not for builtin roles)
 - Better Workspace automations hub: categorized triggers and actions, changes on UI
 - [Technical] Add notify parameter to export api call

### Fixes
 - Import was broken when some automation_states rows where included
 - Fix offline sync
 - Drag and drop cards were not working in some cases 
 - Fix issue on cumulative flow diagram
 - Fix login issue
 - Displaying card cover images was not working in public shared views
 - Fix on saving conditional branches changes in automation rules 
 - Keep scroll position on entering/exiting an automation rule
 - Fix issue on retreiving files in Workspace (in some specific cases)
 - Some settings were not displayed correctly in user account
 - Open export file in new tab and wait for 5sec so that export file upload is finished in most cases 
 - Archived workspaces from Teams were not loaded in Organization hub
 - Reccurrence editor better placement of hours
 - Workspaces with forms that can create request by emails cannot be deleted 


## 10.6.1 (2025-01-23)

### Fixes
 - Now Organization fields are always at the top of card tabs and card sidebar. Fix other field move issues as well 
 - Reindex attribute positions


## 10.6.0 (2025-01-23)

### Features
 - [Technical] Big update on backend server + Real-time collaboration server
 - Re-add csv stream link in integration export modal
 - [Self-hosted][Technical] Updates to use ubuntu 24 as base docker image
 - [Self-hosted][Technical] Update platform script
 - [Self-hosted][Technical] kantree.service.example updated for v10.6 deploys
 - [Self-hosted][Technical] added missing flags to import-org command

### Fixes
 - Real time collaboration now works correctly, no more need to refresh pages
 - Fix many translation issues
 - Builtin role description and name were never translated 
 - Language was not correctly set (based on browser language) when the user is not logged (in forms, shared views...) 
 - Translation issue on dashboard widgets 
 - Teams are now correctly exported in org export
 - My work "assigned to me" list now has clickable card refs
 - Period options was not correctly updated when we switch between widgets in Dashboard view editor 
 - Email template modal could not be opened 
 - Project cover image now works in this order : cover_image > background_image > color
 - Do not trigger automations on archived or template projects
 - Update list cards cache when project or models are updated
 - Superadmins were not able to see some organization and workspace settings
 - Archived Workspaces are not loaded in org hub 
 - Issue on executing automation on related Card update, related Card can be undefined
 - Labels from Org field or shared Card type were editable without being Org admin 
 - Org Invites are not displayed correctly
 - In Gantt, fix wrong week number in timeline view
 - Toast UI elements disappear after 10sec
 - [Technical] fix issue with url files in import db


## 10.5.2 (2024-12-02)

### Features
 - Gantt: Small UI/UX evolutions
 - Link to Power Bi guide in integration page
 - Press "Escape" key now closes dropdowns 
 - [Self-hosted] Handle default color palette in server config
 - [Technical] Offline cache is saved faster
 - [Technical] Workspaces are loaded faster if they have already been visited by someone since their last update 
 - [Technical] uploaded files are not authentified

### Fixes
 - In a Workspace, in Appareance menu, first click on "strike done Cards" does not seem to work
 - "Remove member" button was not visible in Member list because of long user display name 
 - Limit org field delete action to org admins 
 - Some builtin queries with dates were not working in report view 
 - In shared view, only_show_fields_from_view_settings was not working on fields from card types 
 - [Technical] Update automation timeout from 300 to 600s (5 to 10 min) 
 - Harmonize error message when trying to delete user account 
 - Issue with desyncronized column sizes in table views 
 - Prevent issue with draft views when clicking on filter button in kql editor 
 - Give an appropriate default name for new private view and persist it after creation
 - When opening sub-boards, default view is not correctly selected if there are view categories 
 - Style issue on archived workspaces 
 - If export templates contain deleted fields, it will export all fields instead 
 - Mentions in Rich text editor were not working anymore 
 - Make sure ago() and ahead() in KQL can work inside as_date()
 - Workspace cannot be loaded if one card as a dependency that no longer exists 
 - Issue when accessing a Workspace that does not exist anymore 
 - Converting Workspace to Card was not working anymore 
 - Automation could spawn a rare error on rules with query loops 
 - Fix KQL full text search boolean op
 - Fix parent was not working in automation branch condition
 - In auto action rules, in editor, there could be an error popup if cards that trigger an automation error did not exist anymore 
 - Share btn was hidden in card type tab of workspace settings 
 - Never collapse ungrouped cards if there is no grouping selected in the view 
 - Hide Minimize/Maximize groups in table/list/timeline if no grouping has been selected 
 - Optim: Improve smoothness of UI when workspace is "Refreshing cards" (in big workspaces)
 - Do not allow to select the same grouping twice in groupable views (kanban, table...) 
 - Worskpace background image were not displayed as cover in Organization hub 
 - Workspace members could not leave a workspace by themselves 
 - View categories could not be reordered 
 - When opening cards listed in a relationship field, the card data could be outdated 
 - Inbox cards data could be outdated, when cards were opened 
 - Some table views with no grouping were in a strange state were all cards were hidden 
 - Remote choices fields does not show any value in card modal 
 - Sometimes sub-boards in workspace could not be accessed 
 - In dashboard view, in Query widget, Members and Relationships fields could not be filtered when used as grouping option 
 - Portfolio views cannot be grouped by relationships fields 
 - In table view, sums of card fields are correclty computed even if card fields with the same name have been merged in the same column 
 - Merge card types with the same name in card type breakdown chart 
 - there could be some display issue in swimlanes view sort by a date attribute 
 - Card Move (and copy) from one workspace to another was not working 
 - In shared report view, widget should not be editable nor resizable 
 - In shared report view, widgets are not displaying their content 
 - in shared kanban view, cards do not show up if "descendants" options is toggled in appeareance menu 
 - In relationship editor, if a pre-filter has been set in attribute options, a UI issue happens 
 - In "Add member" modal, in a Team Workspace, "only show {team name} member" checkbox was not working 
 - In swimlanes, any other grouping value than Labels or Context makes card drag and drop bug 
 - [Admin] In admin page, the reset password popup does not show up for users 
 - In card move modal, search results were not selectable easily  (refactor needed)
 - Members were not correctly listed in batch actions 
 - Renaming and moving fields in Card logs was not working 
 - Display 0 value for number fields in table views or card tiles 
 - When removing a value on field with a simple input editor (text field, number field, ...) the old value was staying in the input


## 10.5.1 (2024-07-29)

### Features
 - [New] [BETA] New Gantt view : let you manage dates, dateranges, milestones and dependencies between cards visually. Display your project critical path
 - [New] New Dependency field, better used with gantt views

 - [Technical] Now rows in Table view are rendered faster
 - [Technical] Optim on initial load after logging, now the Home page loads instantly even with dozens of workspaces and users
 - [Technical] Added endpoint to easily get data in powerbi

### Fixes
 - Fix an issue with Trello integration
 - Re-added nb_finished_children in export
 - Issue when opening Team page as user permission were not correctly initialized + Org Settings menu is visible again on small screens 
 - Do not display "Manage Team/Org Members" button when the user cannot effectively manage them
 - Issue in displaying roles in Team Members section when the User cannot edit them
 - Hourly schedule for automations was not triggered
 - Replace "Attribute" by "Field" in calendar, timeline and gantt views empty placeholders
 - Erratic issue on some screens (workspaces card type settings for instance)
 - Card type could not be edited from workspace settings 
 - Hide "Remove" button on cards of relationships fields when the field is not editable
 - Disable context menu on sub-cards if it is already disabled on the parent card
 - In Share pages (Cards and Views), display related cards properly in fields
 - Shared views could be loaded empty
 - [Cloud] Some customers could not add new org members and manage seats, on specific billing configuration
 - [Cloud] Fixing unavailable org hub, when specific billing requirements are met
 - Fix auth on msteams app
 - When org is not available anymore, reroute user to Mywork inbox, to prevent potential infinite loop
 - When more than 3 modals were opened, dropdown menus were displayed behind the last modal 
 - When changing the role of a team member, the ui needed a refresh to display the new role
 - Do not let user try to create a template in personal workspaces 
 - Remove "Save as a template" button from workspace settings in user workspaces
 - Process file attachments in email templates even if no card is provided
 - Timeline alignment issue
 - When the "hide empty groups" option was enabled, empty groups were briefly shown at view load
 - Yes/No field value were not correctly displayed in editable form request 
 - Editable Request fields were not saved correctly leading to loss of field value 
 - Fix loading issues on teams hub
 - Fix style of members in org header
 - Fix "use as home" button on orgs
 - When clicking on card breadcrumbs in card modal, the view behind the modal were reset to the first of the list
 - In Kanban view, when clicking on sub-sub-cards, sub-cards were opened instead 
 - Load workspaces when visiting team hubs
 - Sorting issue in workspaces when sorting by attribute 
 - Sometimes, Save button disapears from Workspace Form editor 
 - Mark all Notif as read in notification dropdown in workspaces was not working
 - Upload image in comments was not working
 - Copy card url action was not working
 - Fix role selection in workspaces
 - Group by Yes/No value was not working
 - Optimization on card list refresh when there is an active filter in a workspace view
 - Inbox optimizations
 - Scroll in sidebar menu was not working
 - Hide Filter in Member List if there is only one member
 - Hide "Manage roles" button in portfolios
 - Portfolio is no accessible nor visible by org/team members by default
 - Rich text fields were empty in editable workspace form request page
 - Render asynchronous field in table view
 - Filter builder were not correctly set in widget cards editor of dashboard views in workspaces
 - When workspace views add filter, created cards that match the filter were not added directly
 - Issue with dynamic group by (members fields, yes/no fields, etc) in swimlanes
 - Cards were not displayed in swimlanes
 - Card with type could not be created from quick add menu in the top bar
 - Fix embedding card/view
 - Card modal couldn't be opened without active websocket connection
 - Better fr translation for "Step increment"


## 10.5.0 (2024-05-31)

### Features
 - [New] [BETA] Introducing Portfolio a new way to create and share multi-Workspaces dashboards
 - [New] Percentage Field: Manually set a value with a Slider component; Optionnal Min, max and step increment; It can be set through automation
 - [Technical] Large overhaul of the application, switching to a new UI framework, SolidJS. Our old framework is still being used though. The 2 coexists until we switch all of the UI component to SolidJS. 50% of the migration has been done.
 - [Public cloud] Update to new pricing (ONLY FOR NEW CUSTOMERS; for our existing customers, old pricing still applies until they switch to a new plan)

 - [New] Help links
 - [New] Workspace View options not to strike title when cards are done 
 - [New] option for card types which let you only show fields of this card type 
 - New icons for Workspaces
 - Design update to Organization pages, only "my teams" are visible in the hub, new teams tab
 - Better member tiles
 - Style updates (various + automation editor)
 - Improved file thumbnails
 - Better UI/UX for Workspaces selection 
 - Adjusted default color palette
 - Group by Workspace/Team/Org in multi-Workspaces Dashboard Query widget
 - In multi-Workspaces views, added new entries in filter builder for Workspace, Team and Organization
 - Re-organize system sidebar menu using new icons for Workspaces and Portfolios, and show sections when needed
 - Better way to add/remove builtin app to sidebar
 - Added week numbers options on calendar
 - Rework project menu, favorite is now a star in header
 - Change the way the "update" activity is stored
 - Hide "add view" button when category is collapsed
 - [Technical] Add healthcheck endpoint
 - [Technical] Refactor feature flag system to allow individual feature flags on organization
 - [Technical] Updated OS of docker image to ubuntu 22, keep python 3.7 as default version (our minimum compat) but allow for override
 - [Technical] Add option to disable cert validation for idp metadata download from url

### Fixes
 - Optimized querying of data in offline storage
 - Optimized automations to reduce number of transactions
 - Optimized management of favorites
 - Large Workspaces could not be copied to other organization
 - Sometimes new notifications count was unsync between sidebar and Inbox feed
 - Hide Filter control in Member List if there is only one member
 - Some dropdowns were loaded empty whereas it should have picked a default value from the list
 - In cross-workspaces views, when grouping by workspace, use the workspace color on columns/sections
 - In Workspace views, in Appearance menu, board progress bar could not be displayed
 - When you are editing a view, but someone else updated it, open a popup with choices of discard or create new view based on your unsaved changes
 - When someone else has deleted the context the user is currently using, this one is correctly removed, and the view is grouped by nothing
 - Better handle of fields with same name in Timeline and Calendar apps
 - Rename Team field in Organization field
 - Switching card type doesn't work for a card if it has no value in a relationship field
 - Handle card tab visibility with the newly added model option: hide workspace and organisation fields 
 - In rare cases, cards in relationships fields were not correctly displayed
 - A popup was wrongly displayed when trying to make a shared card type private to a workspace
 - In automation rules, it was impossible to set variables as part of loops
 - In "send email" automated action, static emails and from card fields could not be used at the same time
 - In "send email" automated action, static emails and from card fields could not be used at the same time
 - [Admin] Enter a number in filter of organization list in admin page spawns an error


## 10.4.2 (2024-02-27)

### Features
 - Add the ability to switch camera when taking pictures in a file field 
 - When importing cards from a csv, update existing cards based on card ref
 - Add qr codes on card, view and form links
 - Use lookup and formula fields in timeline : YYYY-MM-DD -> YYYY-MM-DD for daterange
 - Better formatting for lookup and formula fields that output dates
 - New charts to compute burndown and velocity for sprints defined as cards
 - Relationships can be clicked and edited on table view
 - Relationhips are clickable on card tiles
 - In filter editor, Add possible values selection for state and type fields
 - Improved the "quick add" menu in the workspace top bar
 - Clickable group header when grouped by relationships
 - [Technical] Introduce AttrTypeValidationWarning and make them ignorable (for automations)
 - [Self-hosted] New script to reindex views positions of a workspace/user/all


### Fixes
 - Reorder project views or "My Work" dashboards is buggy 
 - When adding a card using the + button in the topbar, you couldn't add labels on it 
 - When adding a card using the + button in the topbar, take card type into account
 - Lookup display in timeline was not working with sub-cards
 - Cards fields with special characters in their name, were not editable anymore. 
 - Issue with the CARD kql function 
 - Issue when loading the filter menu 
 - Issue in Table view when card field name contained "" 
 - Video capture was not centered when used on smartphone
 - Scheduled automation rules cannot be paused/resumed 
 - In automation rules, "Set field" action on number fields doesn't work 
 - In automation rules "Set field", Selected Labels values were not shown anymore 
 - In "Set field" automated action and others, first item of the list were shown when the saved value was not found anymore or was unset: multiple fixes on pretty-select component
 - Ignore user not found errors when running "Set field" automation action 
 - Raise an error when set field automated action is done on an unavailable field or when field is unset 
 - Collected variables must be added to the collection point user_variable_ctx rather than the top most one (fixes issues with setting variables in sub queries in automations)
 - Bi-directionnal relationships field were not push updated for the person doing the action
 - Consistency on input select design
 - Displayed element selector was not working in report query widget 
 - Card selector in relationships editor was causing issues when a search was used + use get_choices when possible in the card browser
 - Ungrouped was not working when grouping by relationships
 - Clear individual cache card when setting card fields via import
 - Columns were not displayed in shared kanban view if it was grouped by an card field from a specific card type 
 - When importing cards, if more than one card fields have the same name, only one of them is available on the mapping list 
 - Remove google ads from requirements as it is causing issues with pyyaml (and we are currently not using the google ads sync)
 - Handle hash based routing in baseUrl.absolute (for cordova support)


## 10.4.1 (2023-09-18)

### Features
 - In "set field from formula" auto action, clear field when the computed value is null
 - Show which step is erroring in automation rule editor
 - Runner now uses the configuration file for its default values
 - Optim: On imports, batch attribute computations on related card and batch automations, faster handling of groups
 - Optimizations to related card handling in automations
 - Don't log AutomationSequenceExecutionErrors, they are handled by the automation error management
 - Use batch actions instead of custom function when archiving group + its cards
 - Added queue-info command

### Fixes
 - Correct timeout is used for async tasks for import pages > 0
 - Only ensure field with values are used in card variables
 - Trigger card_updated event when updating fields in forms
 - Activities are not aggregated correctly 
 - When importing big files, first line was ignored for pages > 1 when no_header=True
 - When computing formulas after an attribute change, card with models were skipped
 - Formula fields were not listed in some options of automation actions 
 - In "when a related card has been updated" automation trigger, fields of any type could be selected
 - Static email field was displayed in forms even if another field has been chosen for getting the email of submitters
 - On requests page, style issue on confirmation message
 - Typo prevented automation rules from being triggered by buttons in emails 
 - Fix handling of infinite loops in automations
 - Filter editor was not converting sub conditions to kql correctly
 - Prevent recursive automation rules through run auto rule action
 - Fix cross workspace lookup attributes
 - Sometimes sort by cards does not work
 - Swimlanes were not correctly displayed when "hide empty groups" option was on
 - Second argument to relationships?() was not taken into account
 - In automation, clear available attributes cache when card model is changed


## 10.4 (2023-07-19)

This release includes many improvements on automations and introduces new possibilities to convey info between workspaces

### Features

On Automations:

- **New Query block**: let you define a new context for the next actions that will be executed. It can be a filtered list of cards, sub cards, parent card or related cards a relationship fields. Those actions will be listed in a new column in your rule editor
- **New Event and action variables**: Those variables can be used in some type of actions, for exemple "post a comment", "send email", "set attribute from formula"...
- New Event type: Related card change
- New action types:
    - Set attribute from formula
    - Remove card from group
    - Create child cards
    - Export the project
    - Define variable
    - Create a card in another workspace
- List automation rules errors in automation rules editor 
- Nested sequences. Some action types let you create new sequence of actions on a new context (for exemple actions on a copied card, on a created card...)
- Edit email templates directly in automation rule editor
- "Send email" action can optionnally take email addresses instead of taking those email adressess in a specified card field
- Automation rules triggered on button click on cards...
  - ...auto add a button on cards (as a new card field) when created
  - ...are now executed by Kantree by default (but can be optionnally executed by the current user)
  - ...can be displayed in Table views in workspaces

On Card Relationship:

- **New Lookup fields**: Display the value of a field of the first related card listed in the specified card relationship field
- Bidirectionnal relationship attributes: Auto add/remove card in the specified card relationship field when adding/removing related cards
- Group by relationship

Other feature worth to mention:

- In appearance menu, display field menu has been reworked a bit


## 10.3.2 (2023-06-28)

### Features
 - In run command, adjust worker scales per queue
 - Provide a Software Bill of Materials (CycloneDX format)


## 10.3.1 (2023-05-17)

### Features
 - Block billing form validation if vat number is not valid
 - 2 new options for shared view/card to restrict visibility on card fields and comments : 
    - Only show comments visible in form requests
    - In cards, only show fields selected in view settings
 - Added systemd service unit file example
 - "Hide empty groups" option in appearance menu can now be activated even when there isn't any filter

### Fixes
 - Clear list_cards cache when formula is recomputed at project level
 - Formula result was not updated when the query was updated 
 - Newly created groups were not displayed on next page reload 
 - Issue when creating personal workspace from public workspace
 - Handle vat number update error (for team and business customer)
 - Org card fields were not displayed in shared views and shared cards 
 - Cleanup card_attributes where value are json 'null'
 - Copy card logs with cards and not log types, otherwise ends up with orphan records in export 
 - Escape ':' in kql names 
 - Empty columns were not hidden in shared views 


## 10.3.0 (2023-03-09)

This release marks the start of a massive effort to modernize our frontend codebase.
This work will be split among many releases and should have no impact on users.

### Breaking Changes
 - honcho (the process runner we are using being ./platform run) is now fully integrated in Kantree,
   there is no more Procfile. You can generate configuration for other process runners using the
   CLI command export-runner-config

### Features
 - office365 integration is renamed microsoft365
 - Added Microsoft Teams integration
 - Improved UI and new options for relationships fields
 - Added new translations: PT and IT
 - Improve iframe embedding behavior
 - Added support to flag oauth apps as auto created
 - Added template marker for share url in email templates
 - Show reset password link to admin when resetting password
 - Add role indicator in system sidebar
 - More customization for msteams package generation
 - Handle formulas stuck in computing, re-attempt computing 3 times and then fail
 - Notification when an automation rule enters an error state and when it recovers
 - Optimization to card loading on projects (caching) 
 - Optimization to when formula are computed: only compute them if the value or a dependant value has changed
 - Added ascendants?() and relationships?()(BETA) kql conditional funcs
 - Export more metadata about activities from Journal view
 - Added suppress_activities parameter to import (only through API at the moment)
 - Disable kantree coach by default

### Fixes
 - Wrong sql query for scheduled automations prevented them from being dispatched
 - Localized links on organization hub
 - Delete views associated to sub boards when they are disabled/de-activated
 - Remove categories on views that were copied without setting it null
 - Prevent attribute position namespaces from being null which prevents project from being loaded
 - Ensure that a special user is never considered disabled
 - Shared card with sub cards was showing an error message on load on shared url
 - "using field" button label was bugged in French
 - Allow expose all headers in CORS
 - Workspace specific card model cannot be deleted 
 - Shareable urls for card/view were not available for workspace members, if they have already been generated 
 - Issue on workspace view switch
 - recurring card couldn't be created
 - Send billing_account_updated signal at the end of trials/periods
 - Issues on system sidebar for Contractors
 - Hide some workspace actions to Manager role
 - Show system app toggles in menu only to workspaces admins
 - Show "Leave this workspace" action in menu only to workspace members
 - automation event "on card field updated" has to react to any group change for group_type attributes 
 - Correctly hide "Invite new member" button in org hub if the user doesn't have the perm to do it
 - Private workspaces in orgs were not correctly created (they were visible by org members)
 - card url in export always using kantree.io for domain
 - properly handle escaping KQL names
 - Alignement issue on timeline 
 - Formula editor opens pre-filled with the computed value instead of the formula
 - Permission check was not done correctly on Formula editor in rare cases 
 - Highlighted files in organization hub replace Kantree in the same browser tab. Now they are opened in another tab 
 - Text color was not updated when adding an image as cover on card modal header 
 - Colors are off on bar charts with multiple queries 
 - Embedded Kantree in iframe doesn't work anymore, issue on csp_header 
 - prevent some automated actions to act on card links
 - Add Google drive attachments to cards stopped working with the last update 
 - commit the automation state on creation as an error in the execution of the rule may trigger a rollback, preventing further manipulation of the state
 - auto add add_to_parent option to forms when they are created from a sub-board in workspaces 
 - Forms could be without any slug if their name was first changed by editing the view name (instead of the form name itself)
 - Style issue on forms with long field labels
 - Sometimes the first view in sidebar was not activated when opening a workspace
 - Temporarly limit cumulative flow diagram period to 30 days max
 - Apply SAML SP cert settings when idp metadata is loaded via url
 - Hide "your email is not validated" message on account page when email validation is not enabled
 - Do not show cards in calendar if they don't have access to active date attributes 
 - Email templates list is now sorted alphabetically
 - Redirect to login page when accessing a non public form without being logged in 
 - Load Error on shared dashboard views with card widgets with no filter
 - In admin, the orgs list did not count workspaces inside teams
 - Delete null values from card_attributes - Prevents frontend to deal with this unwanted card attribute values 
 - when importing, if the process() of a value fails, remove the CardAttributeValue object related to the attribute
 - SAML: avoid login loop when logging out and added possibility to sync identifiers
 - Fix an issue to connect Kantree forms with MS power apps
 - Title field was translated in KQL using filter editor
 - Css fix for gap in dropdown arrow on chrome
 - Sometimes dropdown couldn't be closed (if nested dropdowns)
 - Journal filters and date range are now correctly initialized and saved in views
 - Sometimes card list is not displayed when switching workspaces
 - Dates in American timezones always appeared one day before the ones selected
## 10.2.0 (2022-07-27)

### Breaking Changes
 - Requires at least Python 3.7
 - Renaming export-team CLI command to export-org
 - Renaming import-team CLI command to import-org

### Features
 - Inbox & global dashboards are merged into "My Work", a new coherent hub:
   - New assigned cards & my calendar pages
   - Add workspace views (read & write) to my work
   - "My requests" to list all the user's requests (after form submission)
 - Rework the way org focus was handled because it prevented using orgs and personal projects at the same time and made it harder to navigate across orgs
 - 2022 UI Refresh:
   - New font
   - Modernization of overall UI
   - New kanban style
   - Improved list view
   - Automation rules list
   - Improved organization hub with new navigation and workspace tiles
 - Added view categories
 - New filter editor replaces search box and dropdown
 - Added quick search (ctrl+f) that highlights matching cards. Complements filtering cards
 - Improved "Group By" dropdown
 - Improved batch edition: card selection (via menu or ctrl+click) + standardized batch menu
 - New Integrations tab in workspace sidebar that replaces workspace settings tab
 - Add + button in workspace top bar to create a card using modal
 - New "Use field" button for view modes that require a field
 - Add new Sort button in top bar
 - Better UX for form creation
 - Edit and create card types from workspace settings + added back "edit workspace fields" button in workspace settings using card view
 - New base workspace templates system to showcase kantree capabilities
 - Manage org templates from the template library
 - Disable access to group type modal from a group type attribute ("Labels" and "Multiple choices" types of card field)
 - Added possibility to delete a group from groups menu
 - Standardize style for "use as home" button
 - New Forms page on org hub
 - Remove Github sync (was not maintained) + removed login via github
 - Automations end-user API
 - Api key revokation
 - Move formula field to important group in add field menu
 - Introducing beta of Kantree Coach

### Fixes
 - Disable row d&d in table view on small screens
 - Hide group header in timeline if grouped by nothing 
 - Custom order is correctly disabled when it needs to be in sort by menu
 - In table App, title column doesn't resize properly if only this one is displayed (and all the other columns are hidden)
 - Show/Hide fields from + button in header of table app was not working properly
 - Add an empty notice on calendar app when no date field exists
 - Going to /search should not start a search on all available cards
 - Sort by in swimlanes was broken
 - Correctly disable custom ordering on swimlanes
 - Do not append ?view= to url on project load


## 10.1.5 (2022-07-22)

### Fixes
 - Fix assets build issue


## 10.1.4 (2022-07-13)

### Fixes
 - Migration to fix models had a missing variable declaration in some code paths


## 10.1.3 (2022-04-10)

### Features
 - Added "form submitted by" field

### Fixes
 - Clear cache of groups when changing the project owner 
 - Automation rules were not properly handled when chaging project owner
 - catch a miss-formated options value in chart widgets preventing projects from being copied
 - Fix in migration regarding card links with models
 - Incorrect pasting image when it was text from Powerpoint files
 - New workspace button was not working in sidebar for personal workspaces menu
 - Personal workspaces couldn't be created
 - Only watch for card model and project model to update card modal panels
 - Project with no project attributes will constantly call /descendants when viewing a card modal that already contains sub-cards
 - Models with no overrides to field positions should adopt the project field positions
 - Forms from personal WS couldn't be submitted by guests 


## 10.1.2 (2022-03-31)

### Fixes
 - Do not reset the is_auto_disabled flag when editing a user in admin
 - Properly handle missing rights to create templates from workspaces 
 - Attribute value editor in options editor couldn't list available choices of fields is coming from models 
 - "Make unlicensed" was not working in admin batch user edition
 - Sort choices list in relationships fields
 - Sort field list in options editor
 - Default value for "group type"-based field types was case sensitive but it shouldn't be
 - Add missing run automation role for members
 - Swimlanes fixed height feature 
 - Card links cannot have models anymore 
 - Select a card type in group actions menu was not working 
 - Issue with Create cards by email checkbox 
 - Users matching approved domain when not correctly flagged as normal users when new_users_as_observers is true
 - Improve selection of users to auto disabled (when this feature is enabled)


## 10.1.1 (2022-03-03)

### Fixes
 - Better handle matching selected groups in automation actions
 - Warnings instead of errors for some automation actions which allows the sequence to continue anyway
 - Migration to fix broken view positions
 - Add missing run automation permission to roles


## 10.1.0 (2022-02-28)

WARNING: one of the migration processes a significant amount of data and can take a few seconds to complete

### Features
 - Automations v2:
    - Can now be triggered manually and from various events (card creation, modified field, etc...)
    - Can create run trees with multiple actions and branches based on KQL conditions
    - Can wait on further event to trigger to continue
    - Visual and easy to use editor
    - Manual rules can be triggered via public links (with easy embed in email templates)
    - Removed bolt icon on groups header in cards views
 - Refactoring of project apps:
    - This release includes a massive refactoring of the way project apps work which will help us
      unlock new possibilities for the future.
 - Enterprise: rename "observers" user (at the system level, not the project role) to "free".
   This clears up the confusion.
 - New toast notification system + card loader for the card workspace use toast
 - Added possibility to create buttons in email templates
 - Better global view draft management
 - Use new toolbar buttons for form view (save button in toolbar)
 - Improved featured items management on org page
 - Added possibility to add links as featured items
 - Improve management of orgs for kantree admins and fix issues 
 - Added ability to synchronize users from CSV file
 - Added support for time attributes in KQL sum_logs() 
 - Optim: batches when computing card formulas are now ran in parallel batches
 - Added possibility to invite people to an organization using a link
 - Added {last comment by} KQL attribute on cards
 - User can define which day starts the week
 - Render filtered cards only when the user manually change the filter (switching between views doesn't count)
 - Render cards from a collapsed group only when we expand the group for the first time
 - New support modal replaces support menu
 - Recompute formulas with a value that is dependent on the current time every 2 hours (called "time bound formulas")
 - Added possibility to duplicate forms, card types and automation rules.
 - Remove model editor from workspace settings (was deprecated)

### Fixes
 - State of archived and finished cards was not displayed in table view
 - Draft views in sub-boards could prevent to go back to parent board
 - rename old analytics view modes to report
 - Keep last global search in modal
 - Projects coming from teams I'm not member of, are correctly displayed in sidebar and org hubs
 - Fixes some issues with unlicensed users seeing action buttons that they have no right to click
 - Migration to rebuild parents_ids for cards where it was missing due to previous bug
 - Migration to remove unlicensed users from all workspaces as it should have been
 - SAML: Allow reset password even if saml_only is set to true
 - Added a loading message when filtering cards and API is taking more than one sec to respond
 - Cancel loading of paginated requests when leaving project page
 - Reset password link hidding was not based on the right config variable
 - Issue in view position in Workspace sidebar 
 - Issue with opening a new card when a card is already opened
 - Fix wrong parents_ids of cards
 - group type with scope=project were not properly checked in card_groups api 
 - Permission issue when moving personal workspaces 
 - Rake into account last_login_date when computing auto disabled users in case last_access_at is null
 - If only the filter was changed on a workspace, it was not taken into account when performing batch actions on groups
 - "Minimize/maximise all cards" action was not working on swimlanes  
 - Set session cookie to SameSite=None when using SAML to handle cross site redirects
 - Catch missing username attribute error in SAML because of wrong config
 - Project import error modal was not displayed 
 - Owner of personal workspaces was not appearing in members list anymore + @ mentions autocomplete was broken on personal workspaces  
 - Listed sub boards coming from card mirrors don't work in workspaces 
 - Issue if we remove all views from a workspace
 - In checklist sub-cards are displayed as finished if their parent is [UI bug] 
 - Issue with navigation between views in workspace's sub-boards 
 - Group stats now correctly take into account only the cards that match the filter 
 - Sometimes cards in card modal breadcrumbs couldn't be opened
 - Notify user of their assignation after duplication
 - team admin couldn't access to teams with unchecked "members can observe" when they are not members
 - allow to create account without password in admin
 - when NEW_USERS_AS_OBSERVER is true, allow account creation even if max number of licensed users is reached
 - Better style on checklist view when workspaces have a background image
 - "Display all columns" action in table app was not working
 - Prevent redirect loop when failing SAML user match and log SAML payload data
 - Default workspace model applies to all descendants 
 - Hide header when grouped by nothing in checklist app


## 10.0.1 (2021-10-25)

### Fixes
 - Fix in a migration that cleans up models used in a project


## 10.0.0 (2021-10-25)

### Important changes
 - Renamed "projects" to "workspaces"
 - Renamed "card models" to "card types"
 - Renamed "reports" to "dashboard"
 - Renamed "global reports" to "global dashboards"
 - Renamed "configure auto actions" to "automations" in group menu
 - New ways of managing views: features can now be added to projects via adding views (click "add view" in sidebar)
 - User who are member of single org will be focused automatically on update
 - IE11 is not supported at all anymore

### Features
 - Redesigned navigation with new system sidebar
 - New Inbox: see all your activities across projects and leave comments
 - Interface can be focused on a single org
 - Formula editor
 - Creating a new project now always goes through the library
 - Improvements to table view: added aggregations in header, small style update, order by in column headers
 - Design improvements to list view
 - User account UI redesign
 - Redesigned auth pages + improved onboarding flow
 - Redesigned template library
 - Added files view, improved preview modals style
 - Improvements to shared cards and views with empty fields and anonymous users
 - Added possibility to use the api via OAuth 2.0 apps 
 - Group aggregations are now refreshed with the board filter
 - Email can now be optional on public forms
 - Request pages can be disabled
 - Render markdown comments in notification emails
 - Better relationships card tiles
 - Organization settings in user menu
 - Better user menu
 - Always escape KQL identifiers
 - Per organization theme color
 - Remove only show this list in group menu
 - Icon and color picker in team creator
 - Reorganized group menu + subscription indicator on groups
 - Move attachments under description in from scratch project config, increase empty description height
 - New organization hub customization process
 - New color palette in picker
 - Extend export task timeout
 - Show templates suggestions on org home
 - Added "go to parent board" link in sidebar when in sub board
 - Move 3 dots menu from project sidebar header to right-most of topbar as cog menu
 - Rename public board to shareable board
 - New default style for org banner
 - Better label for ungrouped button and column
 - Round for sum of numbers in logs
 - Confirm view deletion when not a cards view
 - New UI design for admin
 - Show the fact that card is being shared with link in card modal header
 - Simplify right click menu for cards
 - Improved object permissions modal
 - Allow to edit title when clicking on color dot in groups mennu in fields
 - Simpler team selector when moving project
 - Added event tracking via posthog
 - New unsubscribe pages with manual button click to avoid auto unsubscribe by email analysis tools
 - Added merge_parent_attributes_into_children option to exporters
 - Improvement: when exporting from the view menu, auto-select only visible attributes and keep the order of attributes
 - Perf: Better perf for Drag and Drop on filtered boards Ignore hidden cards when refreshing positions for DnD system
 - Optim: improvements to loading time of cards in projects
 - New display for embedded shared cards
 - Detect if page is in iframe + add ways to customize embedded pages (page_only url param)
 - Shared cards possible actions are more restricted + small fixes in design
 - Added a shotcut hotkey to toggle the sidebar (shift+/)
 - Redirect /p to /templates

### Fixes
 - Do not add card ref to url if outside of project or if card is not from current project
 - Added entry in card menu to copy the card url
 - Eecurring time parsing errors were not properly handled
 - Wrong arguments in wrapper in github integration
 - Add error handling for missing target group in auto action
 - Cards widgets in shared dashboards was empty
 - Big translations update (fixing many missing trads)
 - Hide and/or disable some project buttons to anonymous user
 - Roles menu were empty in members list in project settings with slow network connection
 - Prevent script injection in some user-editable strings
 - Design issue with long title in group by dropdown
 - Clear cache of shared cards
 - Project guests didn't have access to team fields.
 - Some types of fields were available for logs whereas it shouldn't (Multiple choices, empty submenus)
 - Team fields are hidden in card modal if the card has card relationships
 - Group aggregations are now refreshed with the board filter
 - Card Relationship modal was closed unexpectedly when starting a search.
 - Fixing a js error on pretty menu, missing to check for defaultPath existence onChanges
 - Import/export projects from cli
 - Fixing a non impactful js error when leaving a project
 - Fixing an issue with Kantree logo not being displayed in Webkit based browser (Safari...):
 - Fixing an issue with a persisting or missing shadow in project topbar
 - Fixing sorting cards on their relationship field values
 - Fixing issue with empty attribute value when reverse sorting cards
 - In global searches grouped by teams, there could be multiples groups displayed for the same team
 - Fixing an issue with global search groups not being updated when changing the group by
 - Possibility to import projects with only team write permission and not org write perms
 - Views were accumulating in base template config as config object was directly modified
 - Fix bug where builtin panels where wrongly shown in hidden menu and css spacing issue with empty attribute groups on card modal
 - URL files were not exported correctly
 - Sometimes workspaces failed to load
 - API: State validation issue when using an unknown string
 - Ensure that subqueries never error because of duplicate related rows
 - Maintain order of sub-cards when copying 
 - Detect locale based on ?locale parameter in url, pass locale parameter to template lib api call
 - Allow to pass parameters to run in docker-start command
 - Support touch interaction again on Windows
 - Fix version of setuptools to avoid incompatibilities with older packages
 - Trigger auto actions when request fields are updated
 - Dashboard crashed when a pinned card was not accessible
 - When opening a card on a new browser page, the card is auto opened again on close.
 - Card Alignement issue with sidebar on Timeline mode
 - Sometimes the card dock system could be left opened while the card is closed
 - Fix bug when opening card modal on /dashboard or from favorites
 - Fix for sidebar and topbar display for shared and embed pages
 - Recurring task settings was buggy when used in timezone with half-hours in it like India (+5:30)
 - Subscription were not loaded when opening card modals from outside of project
 - Migration to rename old analytics view modes to report


## 9.2.4 (2022-01-11)

### Fixes
 - Fix version of WTForms causing segfault in Enterprise releases


## 9.2.3 (2021-09-14)

### Fixes
 - Allow to pass parameters to run in docker-start command


## 9.2.2 (2021-09-08)

### Fixes
 - Use version of setuptools<58 to prevent incompatibilities with older packages


## 9.2.1 (2021-05-12)

### Features
 - Added show_sso_login and login_only settings to SAML

### Fixes
 - On forms, force markdown editor and remove default 'Empty' placeholder on input field
 - Anonymous users will use their preferred browser language as their default language in Kantree
 - Fixes in setup process with dependencies versionning
 - Extend timeout to 10min for project copy tasks
 - Multiple choices attributes couldn't be edited once a value has been chosen in anonymous forms
 - All fields in CSV export are quoted except numeric ones


## 9.2.0 (2021-04-07)

### Features
 - Added possibility to stream export directly to client
 - Improved relationship attribute
 - Now links in editable texts like project guides, card descriptions or card comments will be opened in new browser tabs

### Fixes
 - Delay push events to after all auto actions have been executed to prevent race condition in cache update 
 - When the user is logged on a projet and submits a form, a new browser tab containing the request should be opened
 - Hide the project onboarding popup by default on small screen
 - When copying a project, created_at and last_activity_at were not resetted
 - We were overriding sqlalchemy constructor causing default values to be ignored
 - JS error due to typo when going offline
 - Avatar in ldap were not encoded properly
 - Order by didn't apply correctly on Table and Timeline 
 - Issue on request edition after submission 
 - Log were blurry on high dpi screen 
 - On some projects and for some users, opening the project settings results in an error popup 


## 9.1.1 (2021-02-10)

### Fixes
 - One of our dependencies was using a newer version of a package than us causing bugs in the KQL parsing. We have upgraded to the latest version.
 - Copying a project was also copying user requests and causing request token duplication 
 - Cards can't be scrolled easily on small screens, fields get constantly dragged 
 - On global reports, cards widgets grouped by project or team were not editable

About duplicated requests:

During the database migration, a log file will be generated named "requests-duplicates.csv" which will contain the list of duplicated requests.
A new token has been generated for each of them. Feel free to send an email to affected users. However, as the only way to create duplicates was to perform the copy of a project,
duplicates shouldn't be relevant requests and can be ignored or deleted.


## 9.1.0 (2021-02-08)

### Features
 - Add embed button and modal
 - Filter dimension in query charts
 - Added possibility to logout from all devices
 - Added support for access tokens for mobile authentification
 - Added email validation
 - Use search API for cards widgets in reports
 - Paginated card search + search per_page=50 max
 - Added possibility for admin to impersonate users

### Fixes
 - Cards which parent has been archived were returned in list_cards even when with_archived was false 
 - Ensure the order of automated actions 
 - Sometimes recurring tasks weren't displayed correctly 
 - Groups were not included in email template markers data
 - Handle copy of empty card groups when converting projet to card 
 - Project auto actions were not copied
 - Fix in handling of optionref when serializing 
 - Webhook editor was not setting properly the events to react to 
 - Fix append to group auto action for group type attributes 
 - Alignment issues on cards in timeline mode 
 - Search sometimes doesn't start on cards widgets, infinite loading 
 - CSP headers were not added from integrations
 - Wrong auto selection of plugin used to read xlsx file triggered an error since pyexcel-xls plugin does not read xlsx file anymore. Now forcing pyexcel-xlsx plugin for xlsx file
 - Bugs when accessing or creating global reports (messing with the URL)
 - Reminder dates were wrong when using the mouse to increment the reminder span
 - Useless loading of data when starting to create a new global report
 - CSS fixes for responsive


## 9.0.1 (2020-12-09)

### Features
 - Added support for CentOS 7

### Fixes
 - Encoding problems in LDAP extension
 - Selected projects were not saved correctly when replacing an existing global view
 - When creating a project from the template library, context of creation was not handled correctly


## 9.0.0 (2020-12-07)

### Features
 - Move to Python 3.6+ and PostgreSQL 12+
 - Improved organizations:
     - Added teams to organizations
     - Better UI for org pages
      - Added featured items on org pages
 - New global reports:
     - New report grid layout
     - Cards view widgets: Kanban, table, checklist, calendar and timeline available
 - Redesigned template library
 - New onboarding flow and tour in project
 - Focus card creator in ungrouped column after project creation
 - Rename ungrouped column to a context aware name
 - Seach bar with suggestions
 - Added possibility to prevent deletion of organizations by their admins 
 - UI changes on sidebar
 - Added: create a project from another one without copying cards 
 - Added SUM_LOGS and COUNT_LOGS KQL functions 
 - Added possibility to limit workload chart to some users 
 - Allow to ponderate charts with formula attributes 
 - Added "delete request on card" auto action
 - Remove "Only applies to current board" view option 
 - Add migration to make sure build_tsvector() is compatible with PG10+ for older kantree installation
 - Added pgsql_adapter extension (experimental)
 - Refactoring: moved integration extensions to kantree.integrations package
 - Renamed ungrouped columns in swimlanes and timeline modes (to a context aware name)
 - Card now takes their model color in the calendar 
 - Added CONCAT() kql func
 - Try guessing if a KQL expression is arithmetic to avoid manually converting its members to int
 - Display automatic action errors 
 - Formulas that produce date are now correctly displayed in cards 
 - Extracted email templates feature as an extension + added possibility to use custom smtp connection
 - SQL based charts queries can now be computed on a different db connection
 - Added ability to configure which worker queues to use for different background jobs
 - Added support for postgres multi host URI
 - Added card creation on calendar view
 - Improved velocity charts, added historical tasks completion chart under workload
 - Added support for hCaptcha
 - Added support for Plausible analytics
 - Allow configuration of thumbnail image in template library
 - Better move project modal
 - Always show "Save as a template" button in project settings but disable it for personal projects
 - Added project and team name in header of project menu. Added button to copy/move/archive project from project menu header
 - Make more obvious that the template library is public when publishing (wording + confirmation popup)
 - Template library is not accessible to unauthenticated users by default anymore (set PUBLIC_TEMPLATE_LIBRARY=True to re-enable)
 - Editable requests now open directly on edit mode 
 - Log fields can be reordered and renamed 
 - Updated dashboard sidebar to match the future layout of the inbox

### Fixes
 - Fields can be added, deleted and options can be modified in logs. They cannot be re-ordered at the moment.
 - Simplify handling of KQL IFs in SQL queries, reducing errors due to using subqueries before
 - Display remote value fields in table view 
 - Avoid casting member of arithmetic expression if not needed
 - Sometimes adding fields in a card would make the existing ones appearing twice 
 - KQL: week_end(), workweek_end(), month_end(), year_end() now returns dates which is the actual last day of the period, count_days() and count_working_days() include the upper bound in the count parameters are now optional for count_days() and count_working_days(). if not specified, they use month_start() and month_end()
 - Alias states coming from label fields were not properly removed when switching projects 
 - Fix Javascript issue caused by null group name
 - Login via google might have failed because we were using get_current_user() in a context where user might be anonymous
 - Fixed : In Calendar the end date of cards was displayed one day earlier 
 - Posting new comments now recomputes formulas
 - "Hide empty group when filtering" option wasn't working on checklist mode 
 - Fix jump to subboard button in card view
 - Fix issues with shared views (skip model loading + debounce update active view while cards are inserted)  
 - Clear cache of shared cards when changing groups
 - {updated at} kql attribute now uses the last activity date rather than the internal Card.updated_at
 - Added missing check for currentUser.isAuthenticated() to prevent push from needlessly connecting
 - Do not show edit button when formula attribute is not editable
 - state != was not working correctly
 - Dropdown could be closed if you clicked accidentally outside of it while selecting text in a textarea or input
 - Better UX in auto action menu for groups
 - "use template" button was not visible to anonymous users in template library, fix onboarding flow when starting with a template
 - disable_inactive_users() now take into account users who never used kantree
 - Increased batch task timeout to 300s
 - Update last_activity_at on card creation
 - Chart library could make the page lag when opening the add widget window 
 - Order by Menu was not working on columns in most of the cases 
 - "Show ungrouped cards" option wasn't working on swimlanes


## 8.13.0 (2020-09-11)

### Features
 - Users can now login to an existing account during an oauth flow
 - When logging via office365, github or google, auto associate with an existing account using the same email rather than forcing a new signup
 - Added mailjet_inbound extension

### Fixes
 - Issue with email notifications sent whereas it shouldn't 
 - Grouping by fields was not working using query chart 
 - New fields couldn't be added to models using the model editor in project settings or team panels 
 - Global views are almost always shown as incorrectly active
 - Don't fail when creating cards or comments via email from users which are not part of the project but when allow from any addresses is checked
 - XSS issue in card activities 


## 8.12.1 (2020-08-10)

### Fixes
 - On Edge, required email field on forms could be displayed as empty in request editor 
 - Attachment handling for form inbound emails were broken
 - Do not display the card modal loader if we don't need to


## 8.12.0 (2020-07-16)

### Features
 - Design updates:
      - Move navbar user section to bottom of sidebar
      - Merge quick project switcher into global search dropdown
      - Remove border of buttons in navbar
 - Added Spanish translation
 - KQL: add ROUND function
 - Increase formula task timeout and ensure that formulas are still marked as computed when timeouting
 - Do not show formula input field when a card has no value of a formula attribute but the formula has been computed
 - Added possibility to create requests on existing cards as well as deleting requests
 - Added auto action to create requests
 - Added possibility to make requests editable after submission
 - Added role_before_disabled column in admin users export
 - Added deprecated browser banner (for Internet Explorer 11 and older versions)
 - Added: view options on checklist mode
 - No need to map the title field when only updating cards when importing
 - Groups matching is now case insensitive when importing from spreadsheet
 - Performance improvements:
      - Type descriptions, comments or project guide is smoother on heavy board
      - do not trigger digest loop on typing in content-composer that don't rely on ng-model
      - Optimization when filtering groups
      - Cards were queried twice from frontend store on table and timeline

### Fixes
 - It was not possible to set a value of remote choice attributes
 - Issue with create card by email checkbox 
 - "recently active" project sorting options was reversed. Oldest projects was displayed first. 
 - Empty text field was focused when opening a card.
 - Builtin panels could be duplicated in card modal, leading to display issues 
 - Cards were sometimes not displayed in the right swimlane in global views 
 - Some special card fields in KQL were not aggregatable
 - Clear model cache when formula computing status is updated
 - Push events were not properly suppressed when importing
 - If title only contains number, it caused an error when trying to use as matching field when updating via import
 - Import finished emails were sent to project creator instead of current user
 - Copy of empty attributes groups
 - Subcards in kanban/checklist/timeline were still ordered by ref instead of using their new custom position property
 - User org creation with multiple access
 - Reindex card and attribute positions scripts were not working
 - Sometimes, created projects were not loaded correctly (some features were missing and needed a page reload)
 - Wrong param name preventing importing db backup from file
 - When updating a project using a spreadsheet, if the field used to match cards is of type text but the content of the cell an int, then an error would trigger
 - Do not strip ASCII control chars when removing illegal characters for XLSX export
 - While resizable, labels were still locked to max-width=90px on table mode
 - In some areas of the app, data could fail to update
 - Invites where not processed correctly when signuping via SAML
 - Unsubscribe page now unsubscribed via form submit after 500ms to avoid auto unsubscribing users because of some client emails link preloading mechanism
 - Replaced formula dependency resolver to fix issues where formula depending on others were not computed
 - Timeline cards were not correctly loaded
 - Models having other models defined for cards children were not copied properly
 - CREATE activities on cards didn't have project ids when importing or creating cards via requests


## 8.11.1 (2020-04-30)

### Fixes
 - Table had rows height issues on Microsoft Edge
 - Shared cards weren't loaded correctly 
 - Only show import errors to the user doing the import
 - Don't raise an error when an attribute is still linked to an integration but the integration has been removed
 - Wrong activity verb being used when removing an integration
 - Make sure the text representation of files fields works with files which have no URLs
 - Check email is properly returned when seting up Gsuite
 - Ensure list is returned in cached property to avoid serializing issues
 - Additional check to make sure parent is not None when moving a top level card to another project
 - Catch wrong number of args error for condition funcs in KQL
 - Make sure attribute value is not None in send_email auto action
 - Sync with github was not done when opening new issues in github
 - Issues with swimlanes drag and drop


## 8.11.0 (2020-04-23)

### Features
 - Added selection of default view modes when not using a template when creating projects
 - Added possibility to use members fields for send email auto action
 - Subcards can be reordered in card modal
 - Allow ordering of cards when ungrouped.
 - Allow updating cards from spreadsheet import using any field to match existing cards
 - Added possibility to select an email field to use as the anonymous email field in forms
 - Added: Option to fix the height of swimlanes 
 - Added FORCE_TERMS_VALIDATION_AFTER_SIGNUP option
 - Remove email authentification on requests comments via email
 - Track who created or invited a user 
 - New message on import errors and possibility to apply the previous mapping quickly when importing cards
 - Select active date fields in calendar views 
 - Resizable column in table mode 
 - List view

### Fixes
 - Board scoped groups weren't disabled when moving sub-cards in them.
 - Dates fields weren't updated with card relationships 
 - Improving perfs when hiding ungrouped cards on kanban and timeline view
 - Added unique index on share_objects to avoid case where there is a duplicate for the same object causing queries to fail for the project
 - Model field positions when moved as part of project fields was not correctly kept during a copy 
 - Big spreadsheets are now imported by batch of 500 rows in worker to prevent worker timeout
 - Reset card refs when creating project from a template without cards
 - Users with no user orgs already couldn't create a project because it was failing loading used templates from the library
 - Wrong service called for loading terms
 - Renaming card fields of label type was triggering errors
 - The "Send a confirmation email" form option was not correctly used


## 8.10.2 (2020-03-27)

### Features
 - Team fields can no longer be deleted from card window
 - Do not stop importer on errors but report errors to users after finishing
 - Added new admin filters and filter through display name when not specifying any property 
 - Project members are kept when changing project ownership
 - Increase task timeout for import from db backup task

### Fixes
 - Hide "keep a copy" when moving projects
 - Do not remove line breaks and special control chars in tabular data exports
 - Assigned notification emails were not taking emails disabling on projects
 - Only copy shared objects for public views
 - Calendar and Timeline weren't working with card date fields containing unexpected null value
 - Error when filtering in admin: wrong display_name property was used
 - Year wasn't displayed in date field in table or kanban mode
 - Arrow keys were triggering filter in project filter box
 - Batch relocate wasn't working
 - Fix kantree special user avatar filename
 - Added ability to access the current user before kantree special user is used to property execute auto actions and formulas
 - When creating a project from another one (template, copy, ...) the creator of the project was not reassigned 
 - Fix issues with convert project to card
 - Fixes when converting cards to projects
 - Fixes when relocating team projects to personal projects
 - Do not add oner of personal project to copied project when published in template lib
 - Search box helper was not working correctly in global views
 - Sub cards were all reassigned to new parent when moved across projects 
 - Card's path was not flushed when cache was cleared
 - Help icon was missing on header fields


## 8.10.1 (2020-03-09)

## Fixes
 - Fix version of setuptools in platform script to avoid issue with python 2.7


## 8.10.0 (2020-02-19)

### Features
 - Improved and simplified form editor UI
 - New filters and actions in admin
 - Added move and duplicate batch action
 - Added password policy tooltip on signup page
 - Localized tags for template library
 - Reporting and search actions can be scoped by projects
 - Compatibility with latest Maxmind API for GeoIP database

### Fixes
 - The "Kantree" special user will now be used to execute auto actions
 - Handle all types of scopes in charts
 - Call remote url auto action was missing a parameter
 - Properly remap "group by" option in chart widgets when importing project
 - Keep members when changing project of owners and remap roles
 - Delete subscription when copying project without members
 - Looking up users in admin by username or email did not match all possible entries
 - Dropdown were sometimes constraint in small areas
 - Error on opening card with subcards in a new brwoser tab
 - Field layout issue on card view tabs
 - Auto actions couldn't be set on sub-projects 
 - Global views weren't saving swimlanes 
 - Setting attributes using a list was not working anymore when creating cards
 - Relocate batch action was setting the parent but it shouldn't have 
 - Config parameter navbar_logo_url was not working in sidebar mode
 - "Create new project from this one" action wasn't working in some cases
 - Users couldn't create projects from their own personal projects published in template library


## 8.9.2 (2020-02-19)

### Fixes
 - Pin all dependencies versions to avoid installation problems
 - Fix deprecation warnings from some dependencies


## 8.9.1 (2020-01-17)

### Features
 - Avoid confusion in model name for field in card modal
 - Added LAST_MOVED_IN_GROUP_AT() function
 - Added "teams" column in export of users from admin
 - Invalidate redis cache instead of updating objects

### Fixes
 - Take into account display name when creating users from admin
 - Global views couldn't be saved
 - create_admin command was failing due to accessing the request object outside of request context
 - Group type fields were not searchable using field comparison operators
 - Sub-cards were not displayed on cards, if they do not belong to the active project
 - Immediatly set "release_notes_version_read" when the user signs up
 - Group change history dropdown was not showing due to error
 - Some charts could fail due to missing data and formatter crashing
 - Ignore 404 errors in mailchimp_sync when removing a member
 - Copying card when converting to project was failing due to transaction block being used in combination with enqueue_task_now()
 - Convert card to project was failing due to missing transaction
 - Missing error handling when project is not found in inbound emails
 - JSON Tabular exporter was failing
 - Couldn't set ref via API using string digit
 - Copy for projects without groups in some case
 - Card relationship modal are unexpectedly closed when searching cards 
 - List color was not properly updated in table mode 
 - Relationship modal was sometimes automatically closed when searching for cards 


## 8.9.0 (2019-12-20)

### Features
 - Change main color of Kantree UI
 - New toggle collapse sidebar button
 - New way to add attributes in card views
 - New "save view" dropdown
 - Simplified group menu
 - Simplified button style in card modal header, moved board button to "subcards" tab
 - Simplified project menu:
   - Some actions moved to project settings
   - Project title opens menu when clicked
 - Added "empty space" field type
 - Added option to include descendant cards or not in export 
 - Better style for auth pages side panel
 - Possibility to hide builtin tabs in card view, better d&d indicator for tabs
 - Hide contexts in project settings unless project uses org contexts
 - Add delete context button in group type modal
 - Remove label on view options button and add title in menu to avoid confusion with project menu
 - Added mailchimp_sync extension to keep a mailchimp list synchronized with users who selected to signup to our newsletter
 - Remove email using inbound domain from CCs when receiving requests inbound emails
 - Added IGNORE_INBOUND_EMAIL_CC to ignore more than emails with the inbound domain in CCs
 - Added button to remove custom avatar
 - Import from spreadsheet: match model names and fields
 - Added confirmation before batch deleting cards
 - Added: You can hide card fields values in cards widgets in project reports 
 - Added XFRAME_SAMEORIGIN_HEADER option
 - Added kill_zombie_push_processes command in platform script
 - Always install all extensions reqs when installing venv in platform script
 - Added API endpoints to manage auto actions (also added new permissions)
 - Added extension global_webhooks to define webhooks in the config that will trigger for all projects
 - Added demo mode to do fast signups during presentations

### Fixes
 - Appropriate options for personal projects in project menu and settings
 - Do not use the default value of a group_type field if the card is being created with a group from this group_type 
 - Auto actions on field of type group_type or on contexts are now scoped to a group_type (by name) instead of just a group name 
 - Default card model id was not re-assigned properly when copying or moving projects
 - Archive with cards action for group was disabled 
 - Mirror cards can display the same group 2 times on their tile
 - Auto actions weren't displayed correctly for groups coming from card fields 
 - Card field value 0 wasn't displayed
 - When a project filter is active, the new duplicated card was hidden 
 - Fix css for card view header buttons when custom color
 - New project button was hidden in sidebar 
 - Issue when changing group color multiple times in a row and using back a previous color
 - Fix updating cards after batch action when a single card is concerned
 - Fix asana importer to support latest changes to asana api
 - Sidebar display state was not correctly saved in view in timeline mode 
 - Card field default values were displayed on existing cards whereas it shouldn't 
 - Formulas weren't computed, infinite loading 
 - Some email notifications weren't sent correctly 
 - Issues with empty card sidebar 
 - be able to delete archived cards in batch
 - Sub-boards navigation url was broken 
 - Archiving cards was making them disappear when "include archived cards" was enabled
 - Card tiles were rendered each time views were updated 
 - Fields values were not displayed in the chosen order in cards in Kanban mode 
 - "archive all cards" batch action was not hiding the cards on the frontend
 - Fix batch actions on archived cards in a group
 - Copy all descendant cards when copying a card, assigned new ref to descendants when copying
 - Map image url needs to use https or it is blocked
 - Fix Ubuntu OS detection in platform script


## 8.8.0 (2019-09-09)

### Features
 - New template library
 - Small design improvement of card tiles
 - New design for authentification pages (login/signup)
 - Using new service worker for cache and offline support
 - UI changes in project top bar: actions for the current view now appear in the top bar
 - Backend optimizations: less database queries are done and caching is handled better under high load
 - Start week on monday in calendar
 - Updated UI of calendar and timeline with collapsed by default sidebar containing unscheduled cards
 - Added possibility to expand report widgets to better see one widget at a time
 - Move "sub-boards" section in project sidebar panel to bottom of list
 - Show "include descendants" and "include archived" in view options menu
 - Filter box is expanded on focus and on active
 - Batch actions button in top bar
 - Control visibility of fields on cards per kanban views
 - Select the display density on kanban
 - Perf: Avoid resetting project filter when switching view if they have the same filter
 - Perf: Don't refresh table rows twice on init
 - Added KQL conditional functions parent?(), children?() and descendants?() to filter cards based on their parent, children or descendants respectively
 - Redesign of top bar in projects to better emphasis individual actions
 - Option to show only notifications of the current project
 - New design for Kantree when it is embedded in an other webpage 
 - Updated email templates
 - Auto lock teams when spamming activity is detected
 - Improved onboarding with one step less, more visual
 - Improved project creator in line with onboarding when creating project for first time
 - Added build scripts and associated files to unify kantree and kantree-enterprise repos
 - Better content type field representation in table cells 
 - Added reporting postgresql views which contain no sensitive information
 - Added sql commands to cleanup database of old tables and columns which are not used anymore (our migrations do not delete tables or columns)
 - Indicate user 2FA status in admin panel
 - Notifications center keeps its scroll state when it closes 
 - Allow to configure api endpoints in Github extension so it can be used with Github Enterprise
 - Added delete card batch action
 - Added archived card automated action
 - Added "show logged out page" option to show a page after logout instead of redirecting
 - Added possibility to disable the developer panel from user accounts and preventing users from getting api keys

### Fixes
 - TOS validation was not done correctly
 - Missing border in table mode when grouped by nothing
 - JS error when opening label fields editor in table mode
 - Small report widgets couldn't be edited easily
 - Remove duplicate notifications
 - Switching from very similar view wasn't working as expected (descendants or archived wasn't displayed as expected)
 - Deleting projects wasn't working
 - "No cards" message was displayed on cards widgets whereas there were cards
 - Sometines in custom query widgets, contexts and attributes were mixed in group by selector
 - Project filter menu couldn't be opened in personal projects
 - Comment and rich text field editor weren't working on personal projects
 - Observers permission on project when invited with high permission was not properly downgraded
 - Disable all editing in project settings when project is archived
 - Sometimes sidebar wasn't properly switching to project mode
 - Some activities weren't displayed in Journal mode whereas it should
 - projects/activities must returns all group creations related to the project
 - Do not log error when code is access_denied in google authentification
 - In switch project windows, Space key was used to open currently selected project
 - Group selector in recurring cards editor wasn't working
 - Card Formula editor was displayed even if the user wasn't allowed to edit them
 - Users were seeing the "open card" button in datasource fields whereas they didn't have rights on this card
 - Change groups history dropdown was locked in infinite loading if the card had not been moved on any group
 - Cards were not correctly displayed in Ungrouped when their column is archived
 - Archived groups weren't correctly removed from "mark as..." menu


## 8.7.1 (2019-08-16)

### Fixes
 - Fixes to Google authentification to use authlib Session instead of old mechanism
 - "Add card link" was not working anymore on kanban board


## 8.7.0 (2019-08-14)

### Features
 - Added mentions in comments by role using double-at syntax and @all mention
 - Added support for matching users based on roles in KQL (double-at syntax)
 - Updated style of board tiles
 - Updated: Better expand/collapse sidebar button
 - Updated: Cleaner sidebar section header
 - New tiles for forms in team page
 - Improved style for menus and modal

### Fixes
 - It was not obvious if an image was used as card cover or not
 - The card header was not correctly rendering if image cover was set or not
 - Comments on request could be lost if before they were submitted
 - Labels of old models were still visible in the header of cards
 - Project views that displayed descendants in timeline mode could be laggy
 - Pasting images was being prevented by CSP header
 - CSS fixes on projects with background images
 - Back navigation was broken after first visit to a project
 - Refresh filter after a push event
 - Modals were closed when click started inside an input/textarea and were released outside the modal (typically when selecting text in card modal title) 


## 8.6.1 (2019-07-25)

### Fixes
 - Invitations where deleted when a copy was performed due to an improperly scoped delete statement when cleaning up copy
 - Project background image was not showing when using custom project color with top bar layout


## 8.6.0 (2019-07-23)

### Features
 - UI style update: refresh of color palette (brighter colors) and white background
 - Updating cards with importer now clears existing attribute values and contexts before setting/appending new values
 - Config options for task timeouts
 - Improved support for attribute types with multiple values when importing data
 - Added support for appending cards by ref in relationships attribute type
 - Do not automatically copy contexts when moving/copying cards (back to previous behavior). Groups from attributes are all copied. Hide groups from attributes in move/copy modal
 - Added download button in file thumb or file with previews
 - Wide layout for admin area, improved help text
 - Type hint for KQL queries
 - Computing in progress indicator for formulas
 - Added: swimlanes on global search views 
 - Added possibility to provide a name for links in Files attributes 
 - Added new dynamic field in forms to save the requester email in a field
 - New template marker in email templates for the request url 
 - Added roles for import/export 
 - Open links in form text fields in new tab 
 - Allow to override email sender name in request forms
 - Email notifications from requests never use the user notifications anymore, even if the user was authentified to keep the 2 systems clearly separated
 - No Kantree branding in email notifications from requests
 - New support menu with embedded support form

### Fixes
 - Copy project was failing when it had email templates
 - Call to /api/1.0/projects was raising an error when user had no personal org
 - Fix unicode issues when bulk importing users in admin
 - Improved reporting for errors in formulas
 - Start realtime connection when a card ref is present in the url when directly browsing to a project
 - When moving card to other project, duplicate card groups could occur triggering an error
 - When moving card to other project, new ref was not given
 - It was impossible to change the selection of a multiple choice field after first selection in forms 
 - In global search, grouping was not completely case insensitive
 - Display of group_type attributes on card tiles 
 - Button label was not appearing in options form in menus
 - name_id_format will now override the value provided in the idp metadata xml
 - Disable buttons in content-composer while submitting is in progress


## 8.5.2 (2019-07-08)

### Fixes
 - Email parsing in email_inbound extensions had an issue if the request had certain content type


## 8.5.1 (2019-07-03)

### Fixes
 - Ensure new slug is generated when project is created
 - Fix issue when remapping groups when moving/copying a card with groups


## 8.5.0 (2019-07-01)

### Features
 - Refactor copy/relocate/convert of cards and projects which should fix a lot of issues
 - Use {$date} instead of translated {due date} for filters in pre-defined search sections on the dashboard
 - Add flag to ignore server name mismatch error
 - Improved handling of requests inbound emails and notifications
 - Added limits and warnings when sending emails via email templates
 - Better CLI commands for import/export of projects and teams


## 8.4.0 (2019-06-19)

### Features
 - Added possibility to send emails from email templates from a different domain
 - Added config flag to disable 2FA
 - Sort user items in menus alphabetically
 - Allow updates of existing cards when importing from spreadsheet 
 - Added command to reindex positions

### Fixes
 - If a request was made by an authentified user, then redirect to auth if not authentified
 - Ensure page and per_page parameters in pagination are within bounds
 - Cards couldn't be moved as new project 
 - Forms panel in team page was always empty 
 - In role exception window, roles were not correctly displayed if there were too many of them 
 - Custom project roles weren't available for guests in public projects 
 - Allow admins to create project in orgs
 - In comment auto action, show_in_request option can be unset
 - Call to get_log_type() was returning the wrong data
 - When there was no title field present on form, it would trigger an error if first field is optional
 - Issue with assignements on swimlanes grouped by assignees  
 - Group selector was not working in card's move window


## 8.3.5 (2019-05-23)

### Features
 - Log server_name mismatch

### Fixes
 - Fix bulk import of users in admin


## 8.3.4 (2019-05-15)

### Fixes
 - On complex card layout, sometimes labels were not correctly displayed 


## 8.3.3 (2019-05-14)

### Fixes
 - Cards was not correctly scoped in "logs numbers sum by user" charts 
 - Teams and projects date fields wasn't properly retrieved in timeline and calendar global views 
 - Some Url were missing in our Content-Security-Policy White list


## 8.3.0 (2019-05-03)

### Features
 - Speed up card opening in new page 
 - Two factor authentification 
 - Add Content-Security-Policy header
 - Required yes/no fields in forms now only validate when value is yes 
 - iCalendar feed can be limited to a single attribute 
 - Support loading SAML metadata from file or url
 - New Checklist mode on global search views 
 - Add OneDrive integration
 - Options to hide empty groups when view is filtered 
 - Display an info box when creating a card while having an active filter 
 - Optim: avoid constantly having all cards and activities from all visited projects in memory
 - Only trigger recompute of formulas when needed, formula computation on low queue

### Fixes
 - Disable convert scope modal
 - Fix scheme in SAML settings
 - Make sure admins can always see all forms
 - KQL: always consider quoted strings as strings
 - Poor performance on browsing cards in card browser 
 - Card refs were not properly resetted when copying template with cards and selecting "do not include cards" 
 - Scope batch actions to board  
 - Groups bound to builtin states weren't displayed when clicking card checkbox
 - Handle empty strings in KQL
 - Issue on filtering when offline


## 8.2.0 (2019-03-29)

### Features
 - Added login with Office 365
 - Prompt a modal that helps converting deprecated board-scoped contexts into project-scoped ones 
 - Add toolbar item to insert markers in email template editor
 - Attachments for email templates
 - More forms dynamic fields

### Fixes
 - "name" parameter was not marked as required on create_org
 - Name of request forms couldn't be updated
 - Subscribed user weren't receiving email notifications when they were mentionned and when project email notifs were turned off 
 - Shared views where not properly indicated and updatable
 - Model field was not visible anymore in form editor
 - Alignment issue on stretched swimlanes, partial fix for webkit browser and firefox 65+ 
 - Only notify requester of group change for groups in tracking groups
 - Don't send email notifications to requesters on their own comment
 - Fix email template sender to be a name instead of an email


## 8.1.0 (2019-03-22)

### Features
 - Add notification for requests when changing groups
 - Added "post comment" auto action
 - Added email templates and "send email" automated action
 - Added: support file type field conversion in spreadsheet import 
 - Activities now show email address of requester when posting forms from anonymous users
 - Improved title of cards when submitting forms that have no mapped title
 - Add ability to capture client information in forms using dynamic fields
 - Added support for submitting forms via email

### Fixes
 - Sometimes pasting image into cards was failing 
 - Clicking on image thumb with the same filename was not opening the correct one 
 - Ensure user is notified through notification center when assigned
 - Load card first if project url contains a card ref
 - Better type handling in project importer mapping


## 8.0.21 (2019-03-15)

This is a major release with BREAKING changes to the configuration file location and format.

Visit the following page for more information: <https://kantree.io/help/enterprise/migrating-old-versions#migrating-from-version-before-80>

### Updating
 - The configuration file is now located at the root of the installation under the name *config.yml*
 - A lot of the configuration keys have changed
 - Possible options values are listed in kantree/config.py
 - Default location of uploaded files is now the *uploads* folder at the root of the installation. You will need to move your previous folder.
 - Kantree doesn't include a runner anymore, only a Procfile. Although this should be hidden under ./platform run

### Features
 - Global views (BETA)
 - Refactored the way kantree is configured (BREAKING)
 - KQL: Added support for comparisons with expressions on the left side
 - Added: support tab and ctrl+enter hotkeys on text editor 
 - Improved error management
 - Added RQ panel to dashboard
 - Export in admin use XLSX as format
 - Better error messages for KQL
 - Added support for reporting errors to Sentry
 - Add auto disabling of inactive users
 - Better handle computing errors in charts and KQL queries
 - Added support for previewing video files
 - Added support for previewing PDF
 - SAML2 integration

### Fixes
 - observer was allowed to collaborate
 - better handle missing tokens in google drive integration
 - on org projects, members < admin were having an error
 - Rich text fields were bugging saving empty text
 - Better handling of response from Google for autocomplete
 - Display Board empty notice in timeline view, when there isn't any date field available
 - Draft view was unselected when leaving offline mode
 - Group By Assignees wasn't working correctly in Shared Views
 - Issue with unsaved view when getting online again
 - Issue with include descendants options in Calendar mode 
 - Avoid notifying slack from action perform through a slack command
 - Timezone issues in ical feed
 - Deleted comments sometimes weren't properly removed in card activities
 - Card refs in sub cards weren't clickable


## 7.3.0 (2019-01-22)

### Features
 - Share views via url
 - Added "call remote url" action for groups
 - Add editing for card actions
 - Hide file providers when not logged in when must be authenticated to work
 - Replace "organization" with "team" and "attribute" with "field" in front strings

### Fixes
 - Do not fail card creation via email when the subject contains hashtags but the user does not have the permissions to move/create cards in groups
 - RequestForm::add_to_parent_id was not correctly binded after a project copy
 - The get_member method was not returning anything for the project owner in his user org
 - "Include all descendants" option was not taken into account when doing actions for all card in a group
 - Pinned cards from external projects were not correctly loaded
 - Contractors couldn't access to the list of projects they have access to
 - Contractors should not be allowed access org settings and project creation
 - Archived projects couldn't be displayed in organization's page in some specific cases


## 7.2.0 (2019-01-10)

### Features
 - Added attributes to connect to external data sources
 - Added: Shared attributes are displayed in project settings

### Fixes
 - Toggle archives and descendants before filtering a board
 - Simple card links weren't accessible when their targets were deleted
 - Templates were listed in recently open projects in sidebar
 - Active dates attribute was not properly updated when switching between 2 saved timeline views
 - The invite button was visible in project templates
 - Unable to edit a template form
 - Timeline groups were not hidden correctly when filters are applied 
 - Project guide button was displayed in mobile app whereas it shouldn't 
 - Make sure title value is a string in spreadsheet importer
 - Archived columns didn't have a fixed position when displayed
 - Sub-cards were not properly loaded when duplicating a card 
 - When license count is reached, user data couldn't be changed
 - Restore batch actions on filters was not working 
 - Deduplicate refs and make sure generating a new ref is not transaction-bound
 - Org attributes were visible in group by menu even if they were disabled in the project
 - Fix progress bar on admin overview


## 7.1.0 (2018-12-04)

### Features
 - Track users last access date
 - Added support for importing from spreadsheets 
 - Emails sent to requester who are not member of kantree use the name of the org as the sender name to avoid confusion for the requester who do not know kantree
 - Allow to select which parent to use for cards created through forms Fix order of groups in form editor
 - Mailgun inbound feature: Take into account In-Reply-To header to detected when an email has been forwarded
 - Added KQL func: substring()
 - Share cards via url
 - Improvements to forms: added text and header field types, added customizable header color, better editor UI
 - Better UI for attribute widgets actions
 - Show full image in thumbnails

### Fixes
 - Force version of python-redis in requirements.txt to avoid compatibility problems with redis>3.0.0
 - Sidebar and navbar were displayed on embedded forms and shared cards 
 - Clear cards cache after group rename
 - Fix full text search for longer strings
 - Model editor menu was not properly opened in cards
 - Sub-boards were randomly sorted in project's sidebar
 - Sidebar header was not correctly refreshed when switching to sub-board
 - Don't consider a required yes/no attribute as empty in forms
 - Card modal kept re-opening if a project was accessed from a link containing a card ref
 - Make sure window.applicationCache is defined in frontend
 - Moving projects does not clear attributes of type members, date and like


## 7.0.0 (2018-10-12)

### Features
 - Refreshed interface to navigate faster through projects
 - Customizable interface color

### Fixes
 - Support all unicode range in KQL
 - Fix: mentions in comments were not properly scoped to project


## 6.7.0 (2018-10-12)

### Features
 - Add deleted cards/models/groups in the journal filter
 - Allow filtering among archived cards if "Include archive cards" is checked
 - Optimizations when loading cards on large projects

### Fixes
 - Use official google button for "sign in with google"
 - Renaming of tabs in models
 - In trello importer: ignore title meta in checklist tasks


## 6.6.0 (2018-10-08)

### Features
 - Added notion of super admin to distinguish admins who can access any projects and admins who cannot 
 - Added "Manage integrations" item in project menu
 - Added "re-authorize" button in integrations panel in org settings
 - Added "Do not show notifications in Slack" option to Slack integration
 - Added options to allow anonymous inbound emails
 - Go directly to create project after first org creation More obvious pricing on billing panel
 - Updated Asana importer to support most asana features

### Fixes
 - KQL: Stop auto casting members of an expression to Float. Added as_date() and as_number()
 - Ensure importer can mark the project status even if there is a db error during the process
 - Fix: in the export of users from the admin, the role column will now be marked as "disabled" when the user is disabled


## 6.5.1 (2018-09-18)

### Features
 - Take into account filter when executing batch action on groups

### Fixes
 - Roles were not created on user orgs
 - Ensure an error during reminders sending does not affect all users
 - Delete reminders and commit before bulk sending emails
 - Removed multiple property declaration in js to fix IE11 bug
 - Fix (not final) in KQL to handle empty value for numbers and bools
 - Fix updating store for groups when loading a project


## 6.5.0 (2018-09-05)

### Features
 - Added if() to KQL
 - Added formula attribute 
 - Added is_subscribed?() function in KQL
 - Added option to display Zapier integration
 - Add reminders to cards
 - Added possibility to set default number of points in burndown charts
 - Allow users can set their own display name 
 - Added support for labels when using multiple queries in charts
 - Added: Card creation + contextmenu on cards in sidebar on timeline view mode 
 - Added: Display sub cards in timeline view + Big design update of the timeline view 
 - Speed optimizations
 - Added: Browse projects directly from creation popup
 - Added: Projects views are referenced in URL, making project URL sharing easier
 - Added project export templates
 - Breaking: Changed return type for async endpoint
 - Added tabular json export format
 - Better UI for export attribute selection + re-ordering of attributes
 - Added German translation

### Fixes
 - Follow pagination when loading archives
 - Fix creating personal projects for members who cannot create private projects
 - Members couldn't be removed from organization if org is locked
 - Files were not correctly displayed in project forms
 - Error when opening rules tab on attribute group menu in personal projects
 - Default views use an obsolete filter (due:week)
 - KQL query for retrieving cards with date attributes set on older weeks, months, years
 - Github webhook
 - User was displayed an error message when trying to expand children list on unauthorized mirror cards. Now it cannot expand the list in the first place.
 - At board's loading, cards could fail to load, if some of them were linked to unavailable model (linked to another org's card for instance)
 - Now quick group color and icon edition in menu works also in Firefox and IE


## 6.4.0 (2018-07-14)

### Features
 - Added: Reverse card stream flow 
 - Added: Quick edit for group color and icon directly in attribute menu
 - Added "Hide map" option on Location attribute type
 - Better dropdown menu for "add member" button (from org) in project settions
 - Rename "Groups" attribute type into "Labels" and add "Multiple choice" as an alias of this type
 - Include user email in signup url in invite emails
 - Better handling of frontend cache update
 - Added "clear offline data" button in account section
 - Regexps for NEW_USERS_BLOCK_DOMAINS and USERS_APPROVED_DOMAINS
 - Added NEW_USERS_BLOCK_DOMAINS
 - Improvements to Trello importer (attachments, members, custom fields, label colors)
 - Updated dates of related cards through relationships
 - Use the default org role instead of none when creating a new project
 - Allow org to self export raw data

### Fixes
 - **IMPORTANT**: Fix major issue with positionning system when using sub-cards
 - Copy group actions
 - Make sure auto loaded locales assets do not appear in cache manifest
 - Bool attribute had an empty value in export if never setted 
 - Fixes to exporter
 - Sub-boards were not accessible if a project view specific for current board was active.
 - Swimlane mode was available on small screens whereas it shouldn't be.
 - Always ensure there is a distinguishable enough order by clause in /cards pagination
 - Fix issue on signup page where button was not clickable after a first failed validation
 - Update role of project members when disabling public mode
 - Fix ordering of cards in groups after moving up and down the hierarchy
 - Weird behaviour after selecting colors for models, groups or projects. Colors don't blink anymore.
 - Private views were not displayed in archived projects or when the user was offline. Now they are available.
 - Drop menus were closed when clicking on a checkbox inside them. Now it won't.
 - In table view mode, if I hid the card creation button of a group, I had to reload the page to effectively hide it.
 - Group actions were wrongly enabled when user was offline. Now they will be disabled.
 - Card creation in kanban mode was not disabled when project was archived
 - In project templates, it was not possible to add cards from the table view mode
 - Project's title was not properly updated if we were changing the title of the top level card
 - Activities of same type were aggregated in streams if they were emitted during the same day. We are reducing this duration down to 15min
 - On move, card position was not properly updated when it was in two groups of the current group by
 - Card was not properly styled when dragging it in table view mode
 - Fix disabling of custom ordering when include descendants is activated
 - Fix content type on /projects/cards api endpoint
 - Project email notification had empty body
 - Cards loading was weird in timeline and table view modes
 - Activity relative displayed date was not properly updated
 - Fix options check in Date attr
 - Groups position after a project copy
 - Groups of active board groupby were hidden in sub-cards
 - 3rd party's import wasn't working to create personal projects
 - Fixes in permissions and project creation from templates
 - Comments could not be edited when they were containing user mentions


## 6.3.0 (2018-06-13)

### Features
 - Added support for default value on group_type attr type
 - Added support for taking picture when attaching files
 - Display archived projects that the current user has created
 - Full text search applies to title and all attributes
 - Convert attributes of type 'choice' to 'groups'
 - Convert group types of scope "card" with a single level of groups to scope "project" following deprecation of scopes
 - Convert all attribute group types to scope "org" for better UX
 - Added: Paste image from clipboard in cards
 - Added recaptcha support
 - Paginate call to /projects/{}/cards
 - Added compliance section in org settings for privacy data
 - Added "last year" in date navigator
 - Allow folders in Google Picker Allow all users to choose stream items to display
 - Added terms validation popup + better handle of email settings
 - Added ability to mark attributes as containing Personally Identifiable Information (PII) and extracting reports from them.
 - Added webhooks for projects
 - New KQL functions to better handle dates

### Fixes
 - Clean: delete projects without a top level card
 - Fix bug when converting project to card when user is an org manager (can_create_item)
 - Fixed archived attr in KQL
 - Copy of org scoped grouptypes
 - When duplicating a project, it was generating issues on project/card move modal
 - Fix copy of attribute group type when some options are enabled
 - Fix checking model ownership in swimlane card matrix
 - Comment draft lifecycle was not managed properly
 - Better sync recovering, after loosing the real-time connection 
 - Kanban background was not influenced by customizable color
 - Style issue on card tiles with sub-cards displayed
 - Display cards in ungrouped if they have a choices attributes value that differ from the options available in the chosen groupby
 - In swimlanes, do not display cards that don't have access to the chosen attribute in the groupby


## 6.2.1 (2018-05-11)

### Fixes
 - Wrongly switch to unsaved view when selecting a log saved view
 - Loading loop in some cases in report view


## 6.2.0 (2018-05-10)

### Breaking changes

 - Kantree extension features now have contained configuration, no need to configure multiple dependencies

### Features
 - Added Dropbox integration
 - Rename option ORG_MAX_TOTAL_INVITES to MAX_TOTAL_INVITES and also apply it to projects
 - Do not include full org object in project object, just embedded version.
 - Refactored swimlanes for better loading performance 
 - Better style for template board notice
 - Added Google integration (sign in + attach from gdrive)
 - Added Gsuite integration
 - Add third-party accounts panel in user account settings
 - Improvements to KQL to support comparisons on list types
 - Better attribute system for integrations
 - Rebuilt Github integration  
 - Rebuilt third-party service integration system
 - Log any access by an admin to a project or org who is not a member of

### Fixes
 - Fix issue which was showing org objects even though user was not a member on dashboard
 - Check for empty for attributes containing list values in KQL
 - Attributes disappearing any time the dashboard or project switcher where loaded
 - Previewing images was not opening
 - Issue with saved views and report mode
 - Issue when moving cards to/from Ungrouped column when group by attributes
 - Bug on shift+i hotkey
 - "Show ungrouped cards" options was not activable
 - Local changes on project layout sometimes reset themselves
 - Open card view of broken links
 - Delete target of card links


## 6.1.0 (2018-04-21)

### Features
 - Optimized open modal of parent cards when clicked via path in modal
 - Open view sidebar by default
 - Added option to view all descendants on a single board
 - Added support for checking if card is in group type with KQL
 - Make opening card modal faster
 - If only one state alias, do not show drop down menu on tile checkbox
 - Hide settings for attribute group types and make them available through attribute options
 - Add embed flag in URL to embed public projects as iframe (no navbar, some items hidden)
 - Added more automatically generated reports
 - Added refresh and clear all buttons on reports
 - Propose automatic reports when report page is empty
 - Allow cards in templates
 - Possibility to order by creation date and last modification date
 - In logs view, select log types with some logs by default

### Fixes
 - Fix x axis legend in burndown chart
 - Fix possible type issue in members velocity chart
 - Selected log type was not stored in saved view
 - Fix warning about coerce param in cache directive
 - Hide button pointing at org page to non org-user in public project
 - Unsaved view conflict popup opens randomly
 - Create views with no name shouldn"t be possible
 - Show proper error message if user cannot access target of link
 - Hide checkbox on card tiles if user does not have the rights to edit cards
 - Lower delay to display data on dashboard
 - Fix click on card tiles not closing dropdown
 - Fix order by for null values in admin
 - Avoid circular hierarchy on expand/collapse tasks in card
 - No weird variations on cards height when interacting with a card which has visible sub-cards
 - Hide pin/unpin from dashboard for anonymous users


## 6.0.1 (2018-04-11)

### Fixes
 - Migration to fix roles for organizations where the user who created it was deleted (and thus with an empty created_by_id column)
 - Fix error when showing projects used by context
 - Properly handle attribute validation errors when submitting logs
 - Fix issues with permissions on private projects
 - Fix deletion of private projects from admin
 - Fix link building in reset password page triggering 500 error


## 6.0.0 (2018-04-09)

### Features
 - Enhanced: Improve UX of view mode selection:
    - No more menu to select view modes on the right of the filter, everything has been merged in the main view mode menu
    - New way to manage changes to saved views: we now use a draft view which gets updated until you save it
 - New role-based permission system for projects:
    - Complete rewrite of permissions for projects
    - Includes builtin roles which matches the existing roles and cannot be modified for consistency
    - Create your own roles at the org level
    - Override role per project and per object inside the project
    - This first release supports overrides down to groups and attributes

### Fixes
 - Hide decorative attributes in attribute group menus


## 5.12.0 (2018-04-09)

### Features
 - Added: Minimize and maximize all cards on Kanban mode 
 - Added: Task in tiles 
 - Toggle to select / unselect all in export modal + check to only export cards matching filter in modal
 - Options for activity stream in card views are now global to the project
 - Aggregate time attributes in logs
 - All text fields are now displayed in the filter builder
 - Added language switcher on login & signup pages
 - Do not allow creation of group types of "card" scope on new projects
 - Bulk import/delete of users in admin 
 - Bulk actions in admin
 - Export to csv of users and orgs in admin
 - Added the notion of "users from unapproved domains"
 - Sortable columns in admin tables
 - Possibility to define advanced password policy

### Fixes
 - Attributes on card tiles are always shown in the same order
 - Hide archived groups in form editor
 - Fix double login issue
 - Make sure attributes of type "groups" are displayed under attributes and not contexts
 - Correctly update column titles when switching between 2 attributes group by


## 5.11.1 (2018-03-20)

### Fixes
 - Auto scroll to top when drag and dropping card on ordered columns
 - Fixes to docker files


## 5.11.0 (2018-03-19)

### Features
 - Added: Enabling card filter in calendar mode 
 - Cards in reminder email are grouped by projects
 - Added unsubscribe link in emails s
 - Added possibility to have max amount of allowed users in orgs
 - Creation of org contexts is now deprecated
 - Added support escaping chars in KQL 
 - Store username of users in activities, comments and logs to know who did it even after the user has been deleted
 - Add monthly frequency to recurring cards
 - In org card model and context editors, you will know exactly how many projects used them

### Fixes
 - Fix styling and click actions issues on log entries 
 - Project filter no longer has typing issues and a waiting icon appears when it is looking for matching cards 
 - UI glitch when drag and dropping cards in kanban mode when using dynamic group by 
 - Don't display scrollbars when it shouldn't in kanban mode on Firefox 
 - Full text search now supports numbers 
 - Prevent with creating multiple logs when clicking fast on the save button 
 - Fix convert a project to a card in another project 
 - Correctly refresh state bar in card view when switching card state inside it 
 - Fix copy of models without attributes
 - Issue with Copy/move projects between organizations
 - Improvements of perfomance on filtered board and ability to hide non matching groups 
 - Relationship attributes shouldn't return 404 error
 - Migration to cleanup damaged models from bug impacting copy of models without attributes


## 5.10.0 (2018-02-13)

### Features
 - New system to trigger actions when card are added to a group

### Fixes
 - Disable custom ordering on Kanban columns when it is not supported
 - Activity objects shouldn't be clickable if there aren't cards
 - Correctly display change states for all cards in group
 - Access to the right options in group actions menu based on group properties
 - Bug in move/duplicate feature when selecting "Save as new project"
 - Always add a link to Kantree in notification emails
 - Org contexts and groups copy


## 5.9.0 (2018-01-31)

### Features
 - Added Header and Separator attribute types
 - Darker color for add attribute button on card modals
 - Support for inter-org relationships
 - Enhanced: merge filter and creation input in groups dropdowns
 - Feature: recurring tasks
 - Enhanced: Better group selector when trying to move cards through projects
 - Added: Reorder form fields by drag and drop in form editor
 - Added: Create multiple cards at once in table view
 - Added support for custom logo image in navbar Added support for custom UI color

### Fixes
 - In table view, correctly handles adding columns and managing contexts
 - Renaming a column in table view doesn't hide this column
 - Able to move card inside another card
 - Correctly display scrollbar on sidebar in projects
 - Correctly load groups from org context
 - Allow deleting of models even when archived cards are attached


## 5.8.7 (2018-01-16)

### Features
 - Enhanced: better design for "group by" button in navbar
 - Merge fields with the same name when exporting to CSV/XLSX Added "model" column in CSV/XLSX export

### Fixes
 - Fix issue with form editor after deleting some contexts/group attributes
 - Correct relative date for activities and add hours on hover
 - Fix some issues with models when copying projects


## 5.8.6 (2018-01-10)

### Fixes
 - Excel/CSV export issue with relationships attributes
 - Moving a card into another one


## 5.8.5 (2018-01-05)

### Features
 - Added config parameter to disable modification of username and email from account page
 - Added SIGNUP_URL configuration parameter

### Fixes
 - Bug with wide columns drag and drop
 - Correctly display group by label in view modes where swimlanes are not available
 - Typo in french translation
 - Issue when using ctrl+enter to create a card


## 5.8.4 (2017-12-14)

### Fixes
 - Fix illegal characters issue in XLSX exported file
 - Prevent creating multiple instance of the same form
 - Error when renaming column while there is no card in the project
 - Correct list of models in "Default model for sub-cards" option in the model editor
 - Only project admins could see project guides
 - Hiding "add card" buttons in Kanban
 - Print kanban view display cards correctly
 - Some activities had an invisible message


## 5.8.3 (2017-12-07)

### Features
 - Added support for setting avatar via LDAP
 - Added service endpoint to create custom activities
 - Added support for generic email inbound


## 5.8.2 (2017-12-04)

### Fixes
 - Fix wrong extension for excel export


## 5.8.1 (2017-12-01)

### Features

 - Better support of Active Directory in LDAP integration

### Fixes
 - Fix issue with cards not showing up in ungrouped section
 - Fix typo in French emails
 - Do not send reminders if project are archived
 - Fix word wrapping issue in attribute input widget on IE
 - Fix reset password page styling issue


## 5.8.0 (2017-11-24)

### Features
 - Added number of matching cards in group header
 - Added XLSX exporter
 - Reminders for due dates are now sent as a single email
 - Move attributes from one model to another

### Fixes
 - Fixed frontend issue preventing account deletion
 - Prevent project copy/move from breaking localCache


## 5.7.8 (2017-11-14)

### Fixes
 - Fix & cleanup duplicated user orgs
 - The "Your projects" section was not visible until at least one project was created
 - Allow deleting invites set as owner


## 5.7.7 (2017-11-13)

### Fixes
 - Issue with localstorage after copying a project
 - Issue with scrolling on table view on Internet explorer 11


## 5.7.6 (2017-11-12)

### Fixes
 - Issues with licensing system


## 5.7.5 (2017-11-10)

### Fixes
 - Delay in showing projects on dashboard


## 5.7.4 (2017-11-10)

### Features
 - Added: In group by menu, swimlanes buttons work like toggles now
 - Added "past groups" to export
 - Added: Enable rich-text editor on project comments stream
 - Added: Enable draft mode on project guide editor

### Fixes
 - Display sub-cards in card view when archives are enabled in the project
 - Prevent editing titles of card links in table view
 - Use proper label instead of null in list widgets in options
 - Support decimal numbers in all charts
 - Sorting issue when sorting groups by an attribute of Groups type
 - Ungrouped columns and swimlanes not showing when a filter on groups was applied in Kanban view
 - Stats not showing in cardlist header in kanban view
 - Fix login issues with third party service
 - Attributes were hidden when opening a card which projects had never been opened
 - Dashboard may show no projects in orgs in some combinations of parameters
 - Remove subscriptions when removing a user from project or org
 - Issue on loading of project when selected groupby doesn't exist anymore
 - Firefox issue with images in project guides
 - Enhanced: Avoid triggering a drag and drop instead of a click on cards/groups/attributes/views


## 5.7.3 (2017-10-24)

### Fixes
 - Fix issue with updating local storage store


## 5.7.2 (2017-10-23)

### Features
 - Added grouping support for Yes/No value attributes


## 5.7.1 (2017-10-23)

### Fixes
 - Fix issue with updating a view with group_by set to null


## 5.7.0 (2017-10-23)

### Features
 - Swimlane view
 - Better formatting and styling for charts
 - Added chart: Evolution of number of cards in a single group
 - Added chart: Evolution of time between two groups over time
 - Added chart: Time between two groups
 - Added {resolution time} property in KQL and was_in_group?() conditional function
 - Improved Query graph with support for group by and multiple visualizations

### Fixes
 - Fix missing color distinctions between openned and finished cards in Groups chart
 - Fix issue with wrong filters when clicking on query widgets from reports
 - Fixed issues when setting dates in Date attribute editor, timeline and calendar
 - Better handling of date attributes with time, in attribute editor, calendar and timeline
 - Fix issues with duplicate items when loading or creating a project
 - IE problem with image in project guides
 - Mark as... menu couldn't open if states were linked to some groups
 - Error when sometimes opening the guide editor
 - Correctly cancel drag and drop when press 'esc' key
 - Some bugs around project configuration persistence


## 5.6.7 (2017-10-12)

### Features
 - Use IndexedDB for offline storage because of larger storage space

### Fixes
 - Groups menu is correctly updated when group type options are modified
 - Properly display large date ranges in calendar view
 - Fix: offline created cards were deleted


## 5.6.6 (2017-10-11)

### Features
 - Copy projects with org models enabled


### Fixes
 - Security Fix: Check accessible projects when searching in org
 - Fix org calendar to use all projects accessible in org
 - Issue with group subscription causing boards to not load
 - Sub-cards were hidden if archived cards were visible
 - Clear org from local cache properly after leaving an organization
 - Fix issue with org. attributes which could be displayed twice on the frontend
 - Better handling of attribute visibility menu in table view
 - Fixed issues when setting dates in Date attribute editor, timeline and calendar
 - Better handling of date attributes with time, in attribute editor, calendar and timeline
 - Board filters were not updated when changes were occuring
 - Fix issues with duplicate items when loading or creating a project
 - IE problem with image in project guides
 - Mark as... menu couldn't open if states were linked to some groups
 - Shared projects keep the same position in the menu when creating a card link
 - Group menu properly closes on table view if "one group per card" is activated


## 5.6.0 (2017-09-26)

### Features
 - Kantree is accessible while offline
 - Added ability to create cards and post comments while offline
 - Add support for groups, members and size types in forms
 - Changed: Disallowing card creation in groups is now an appearance group option as it only hides the card creation button
 - Added search page
 - Added calendar tab in organization page
 - Added calendar on dashboard
 - Add support for filtering attributes by type in KQL
 - Added "nb comments" and "last comment card" properties on cards in KQL
 - Added visual indicator that tabs can be moved in card view
 - Ignore case in group references when creating cards
 - Added number of projects in admin overview


### Fixes
 - Fix reference in tracking groups
 - button to copy form url was not working
 - Fix positioning issue when adding new attributes to log types


## 5.5.1 (2017-09-07)

### Features
 - Added support for any kind of groups in LDAP integration
 - Added auto_join_org_on_signup configuration option

### Fixes
 - Fix dashboard for new users which have joined an org but have no projects
 - Fix issue where some cards may not appear in groups due to the process used to fill them on the frontend
 - Allow Kantree administrators to edit organization owners


## 5.5.0 (2017-09-04)

### Features
 - New LDAP integration with support for auto joining orgs on signup
 - Enhanced: Project email address for card creation has been moved in its own window
 - Added: can use groups from attributes in reports
 - Added: Simple filter for Members attribute menu
 - Added: Simple filter for groups in menu
 - Added batch editing capabilities through filters and groups
 - Added ability to edit card attributes from the card menu
 - Better handle for inputs in date picker
 - Added ability to have views that apply to specific boards but can be accessible from anywhere
 - Breadcrumbs links in card modal now open the card in context
 - Added sorting of groups attributes
 - Added time support in date attribute type

### Fixes
 - Fix issue with licensing module still allowing signups passed allowed number of users triggering lock down of kantree
 - Correctly load right click menu for projects in dashboard
 - See "ungrouped" column if you group by nothing on an empty project
 - In table view, always display cards when grouped by "Nothing"
 - Always show groups in table view even if their properties say they shouldn't
 - Boards load correctly even if you have a broken link with sub-board
 - Properly handle case when view in local data is missing in view store
 - Better handle multiple card creation at once


## 5.4.0 (2017-08-02)

### Features
 - Better indicator when attribute is not available for a card in table view
 - Added ability to re-order columns in table view
 - Added possibility to delete attributes from table view
 - Added: Invite members when creating new organization
 - iCalendar feed can be found from the timeline view
 - Rename the "Card" attribute type to "Board as data source"
 - Added ability to click on values of link attributes on card tiles to open the link
 - Better handling of contextes and attributes when exporting
 - Redesigned and optimized table view
 - Added relationships attribute support in KQL
 - Added encrypted_text attribute type
 - Added manual action to trigger build from dev

### Fixes
 - Floating numbers couldn't be set in number attributes
 - Do not show duplicate and move actions in project menu to not project admins
 - Do not include cards from archived projects in global search
 - Bugs on pasting bold text in rich text-editor in macOS


## 5.3.1 (2017-07-18)

### Features
 - added: new template selector + template icon and oneliner + handling EN/FR
 - enhanced: new org creator + some changes in project creator (to be continued)


## 5.3.0 (2017-07-09)

### Features
 - new add attribute dropdown based on prettymeny
 - added logging of all user logins
 - new card tile based on handlebars.js for optimization reasons (50% speed increase)
 - added time attribute type
 - refactored: date-navigator now use our dropdowns
 - added: timeline export to image + daterangepicker in timeline
 - restore cover on tiles, possibility to add project cover via top level card
 - enhanced: better css for guides and guides editors
 - group type have display_on_card='label' by default
 - display avg weekly velocity even if no point attr selected in member velocity graph + round numbers
 - increase timeout in input widget for attrs when opening color picker
 - added color support in text attributes
 - refresh style of members section in project settings
 - Mini guide for projects
 - improve text search in KQL
 - add support for background image
 - allow admin to copy any projects
 - reset views when switching "tool". add confirm message for report view.
 - added icon indicator in views when there are changes
 - css improvement to auth pages + login/signup link in auth container + invisible navbar on auth pages + configurable logo
 - updated style for login & signup pages
 - improved UX for editing views
 - open lightbox when clicking on images in activity stream
 - added velocity charts
 - supports returning timedelta from formula queries
 - added: report view and calendar view support for print
 - added info about model usage in organization page for models
 - added: print stylesheet for timeline view
 - added: share/unshare button in project settings
 - added support for labels in link attr
 - added option to disallow public projects in enterprise
 - added anchor in urls in slack integration
 - add link in request comment notif email
 - download file from browser when export is finished
 - Deprecate model extends
 - add "minimize all" actions in kanban and table view
 - Prosemirror image picker

### Fixes
 - correctly open pinned cards coming from user org projects in dashboard
 - partly fix incorrect behaviour on card creation iOS
 - working daterangepicker and date-navigator in iOS
 - journal view is scrollable in iOS and osX
 - browse template buttons wasn't working on dashboard
 - fix render of tile in task mode
 - fix loading of cards in the report widget
 - fix order by which was not restored properly when displaying a view
 - Copy projects forms
 - project owner shoud appear once in group by members columns in user org projects
 - better support for timelines with large daterange
 - download image on IE-safari + canvas creation on IE-FF + timeline on IE
 - correctly handle chart options in saved view edition
 - IE edge display filtered kanban columns correctly
 - fix issue where view was set has unsaved on load if it had filters
 - fix selection of bg image in project settings
 - correctly update height of columns if one of the specified properties changes in IE (flexbox hack)
 - fix link in members section in project settings
 - fix issue with removal of card_cover
 - in user project, owner is displayed in members settings and mentions dropdown
 - fix kanban col height in IE when desc is always visible
 - finished datetime after a copy
 - fix bug in options form
 - menu color palette trigger change when pasting hex code
 - better handling of attr title editor
 - ie issue with attribut options forms
 - fix wrong updates of relative base in attr position algo when moving backward
 - caching issue on IE 11 for uploading images
 - color palette initial value is correctly loaded
 - fix error issue in kql where attr group type where not matched because their name is empty and provided by the attribute
 - fix notifications inconsistencies regarding group subs
 - send due date emails regardless of the name of the attribute
 - groups from attributes should be sortable in kanban view
 - fix relative attribute positions on frontend
 - kql: fix aggregates for dates
 - auto resize filter dropdown when many items or small screen
 - support groups starting with numbers in kql
 - make inbound emails insensitive to case


## 5.1.3 (2017-05-30)

### Features
 - Support for card model colors in timeline view
 - Allow kantree admins and org managers to update/delete grouptypes

### Fixes
 - don't show models created in project in settings of other projects if they're not shared
 - do not show subscribe/unsubscribe actions in top level card actions menu
 - no activities aggregation in notifications
 - display bug of username with special character
 - Dashboard default filters with translation
 - extract usernames with dots(.) for card creation and comments
 - assign users with dot(.) in their usernames when creating a card
 - notify mentioned users with dot(.) in their usernames
 - use full_display_name in emails
 - KQL: A non-existent attribute marked as empty is bypassed
