<?php
/*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class TriggerTool extends WebserviceOutputBuilderCore {

    public static function addDateWithFormat($date) {
        $date = DateTime::createFromFormat('Y-m-d H:i:s', $date);
        return $date->format(DateTime::ISO8601);
    }

    public static function getDobWithFormat($date) {
        $dob = DateTime::createFromFormat('Y-m-d', $date);
        $dob->setTime(0, 0, 0);
        return $dob->format(DateTime::ISO8601);
    }

    public static function validateDate($date, $format = 'Y-m-d', $return = false, &$dateObj = null) {
        try {
            if ('Y-m' == $format) {
                $date = $date . '-01';
                $format = 'Y-m-d';
            } elseif ('Y' == $format) {
                $date = $date . '-01-01';
                $format = 'Y-m-d';
            }
            $d = DateTime::createFromFormat($format, $date);

            if ($return) {
                $dateObj = $d;
            }
            return $d && $d->format($format) == $date;
        } catch (\Exception $e) {
            self::showMethodInternalServerError();
            return;
        }
    }

    public static function filterIdContactsByDate($from, $to) {
        $sql_nd = 'SELECT DISTINCT `id_customer`
            FROM `' . _DB_PREFIX_ . 'customer` ORDER BY id_customer ASC';
        $sql_hd = 'SELECT DISTINCT `id_customer`
            FROM `' . _DB_PREFIX_ . 'customer`
            WHERE `date_upd` between "' . $from . '" AND "' . $to . '" ORDER BY id_customer ASC';
        if (isset($from) && isset($to)) {
            $id = Db::getInstance()->executeS($sql_hd);
        } else {
            $id = Db::getInstance()->executeS($sql_nd);
        }
        return $id;
    }

    public static function filterIdOrdersByDate($from, $to) {
        $sql_nd = 'SELECT DISTINCT `id_order`
            FROM `' . _DB_PREFIX_ . 'orders` ORDER BY id_order ASC';
        $sql_hd = 'SELECT DISTINCT `id_order`
            FROM `' . _DB_PREFIX_ . 'orders`
            WHERE `date_upd` between "' . $from . '" AND "' . $to . '" ORDER BY id_order ASC';
        if (isset($from) && isset($to)) {
            $id = Db::getInstance()->executeS($sql_hd);
        } else {
            $id = Db::getInstance()->executeS($sql_nd);
        }
        return $id;
    }

    public static function filterIdProductsByDate($from, $to) {
        $sql_nd = 'SELECT DISTINCT `id_product`
            FROM `' . _DB_PREFIX_ . 'product` ORDER BY id_product ASC';
        $sql_hd = 'SELECT DISTINCT `id_product`
            FROM `' . _DB_PREFIX_ . 'product`
            WHERE `date_upd` between "' . $from . '" AND "' . $to . '" ORDER BY id_product ASC';
        if (isset($from) && isset($to)) {
            $id = Db::getInstance()->executeS($sql_hd);
        } else {
            $id = Db::getInstance()->executeS($sql_nd);
        }
        return $id;
    }

    public static function filterIdCartsByDate($from, $to) {
        $sql_nd = 'SELECT DISTINCT `id_cart`
            FROM `' . _DB_PREFIX_ . 'cart` ORDER BY id_cart ASC';
        $sql_hd = 'SELECT DISTINCT `id_cart`
            FROM `' . _DB_PREFIX_ . 'cart`
            WHERE `date_upd` between "' . $from . '" AND "' . $to . '" ORDER BY id_cart ASC';
        if (isset($from) && isset($to)) {
            $id = Db::getInstance()->executeS($sql_hd);
        } else {
            $id = Db::getInstance()->executeS($sql_nd);
        }
        return $id;
    }
    
    public static function filterIdNewslettersByDate($from, $to) {
        $sql_nd = 'SELECT DISTINCT `id_customer`
            FROM `' . _DB_PREFIX_ . 'customer` ORDER BY id_customer ASC';
        $sql_hd = 'SELECT DISTINCT `id_customer`
            FROM `' . _DB_PREFIX_ . 'customer`
            WHERE `date_upd` between "' . $from . '" AND "' . $to . '" AND newsletter = 1  ORDER BY id_customer ASC';
        if (isset($from) && isset($to)) {
            $id = Db::getInstance()->executeS($sql_hd);
        } else {
            $id = Db::getInstance()->executeS($sql_nd);
        }
        return $id;
    }

    public static function getGroupName($id) {
        $sql = 'SELECT DISTINCT  gl.`name`
            FROM `' . _DB_PREFIX_ . 'group` g
            LEFT JOIN `' . _DB_PREFIX_ . 'group_lang` gl ON (g.`id_group` = gl.`id_group` AND gl.`id_lang` = ' . (int) Context::getContext()->language->id . ')
            WHERE g.id_group = ' . $id;
        $groupname = Db::getInstance()->executeS($sql);
        return $groupname;
    }

    public static function statusCode200Ok($data = null) {
        http_response_code(200);
        header('Cache-Control: no-cache, must-revalidate');
        header('Expires:' . date('r'));
        header('status: 200');
        header('statusmsg: Not Found');
        echo($data);
    }

    public static function statusCode404NotFound() {
        http_response_code(404);
        header('Cache-Control: no-cache, must-revalidate');
        header('Expires:' . date('r'));
        header('status: 404');
        header('statusmsg: Not Found');
    }

    public static function statusCode406NotAcceptable() {
        http_response_code(406);
        header('Cache-Control: no-cache, must-revalidate');
        header('Expires:' . date('r'));
    }

    public static function showMethodNotImplemented() {
        http_response_code(501);
        header('Cache-Control: no-cache, must-revalidate');
        header('Expires:' . date('r'));
        header('status: 501');
        header('statusmsg: Not Implemented');
        header('datas: ');
    }

    public static function showMethodInternalServerError() {
        http_response_code(500);
        header('Cache-Control: no-cache, must-revalidate');
        header('Expires:' . date('r'));
        header('status: 500');
    }

    public static function statusCode400BadRequest() {
        http_response_code(400);
        header('Cache-Control: no-cache, must-revalidate');
        header('Expires:' . date('r'));
    }

    public static function showMethodNotAllowed() {
        http_response_code(405);
        header('Cache-Control: no-cache, must-revalidate');
        header('Expires:' . date('r'));
        header('status: 405');
        header('statusmsg: Method Not Allowed');
        header('datas: ');
    }
    public static function getServer($key = null, $default = null)
    {
        if (null === $key) {
            return $_SERVER;
        }

        return (isset($_SERVER[$key])) ? $_SERVER[$key] : $default;
    }
    
    public static function getMethod()
    {
        return self::getServer('REQUEST_METHOD');
    }
    
    public static function isGet()
    {
        if ('GET' == self::getMethod()) {
            return true;
        }

        return false;
    }
    
    public static function getSECRETHMAC() {
        return Configuration::get('PS_GEER_IO_HMAC_SECRET');
    }
    
    public static function hmachash($data, $salt = '', $iterations = 10) {
        $hash = $data;
        foreach (range(1, $iterations) as $i) {
            $hash = hash('sha256', $hash . md5($i) . $salt);
        }
        return $hash;
    }

}
