

'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = (n > 1);
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(current notification)": "(\u015eu anki bildirim)",
    "(current version)": "(ge\u00e7erli versiyon)",
    "1 month ago": "1 ay \u00f6nce",
    "1 week ago": "1 hafta \u00f6nce",
    "3 days ago": "3 g\u00fcn \u00f6nce",
    "A file is being uploaded. Are you sure you want to leave this page?": "Bir dosya y\u00fckleniyor. Bu sayfadan ayr\u0131lmak istedi\u011finize emin misiniz?",
    "A file with the same name already exists in this folder.": "Bu klas\u00f6rde ayn\u0131 isimde bir dosya zaten var.",
    "About Us": "Hakk\u0131m\u0131zda",
    "Abuse Content": "K\u00f6t\u00fcye kullan\u0131m i\u00e7eri\u011fi",
    "Abuse Type": "K\u00f6t\u00fcye kullan\u0131m t\u00fcr\u00fc",
    "Action": "Aksiyon",
    "Activated": "Aktifle\u015ftirildi",
    "Activated Users": "Aktif Kullan\u0131c\u0131lar",
    "Active": "Aktif",
    "Activities": "Etkinlikler",
    "Add": "Ekle",
    "Add Admins": "Y\u00f6netici Ekle",
    "Add Library": "K\u00fct\u00fcphane ekle",
    "Add Member": "\u00dcye Ekle",
    "Add Organization": "Organizasyon Ekle",
    "Add Terms and Conditions": "\u015eartlar ve Ko\u015fullar Ekle",
    "Add User": "Kullan\u0131c\u0131 Ekle",
    "Add admin": "Y\u00f6netici ekle",
    "Add auto expiration": "Otomatik sona erme ekle",
    "Add new notification": "Yeni bildirim ekle",
    "Add new reviewer": "Yeni g\u00f6r\u00fcnt\u00fcleyici ekle",
    "Add password protection": "\u015eifre koruma ekle",
    "Add permission": "\u0130zin ekle",
    "Add user": "Kullan\u0131c\u0131 ekle",
    "Added": "Eklendi",
    "Admin": "Y\u00f6netici",
    "Admins": "Y\u00f6neticiler",
    "All": "Hepsi",
    "All Groups": "T\u00fcm Gruplar",
    "All Notifications": "T\u00fcm Bildirimler",
    "All Public Links": "T\u00fcm Genel Linkler",
    "All file types": "T\u00fcm dosya tipleri",
    "An integer that is greater than 0 or equal to -2.": "0'dan b\u00fcy\u00fck ya da -2'ye e\u015fit bir tam say\u0131.",
    "An integer that is greater than or equal to 0.": "0'a e\u015fit ya da 0'dan b\u00fcy\u00fck bir tam say\u0131.",
    "Anonymous User": "Anonim Kullan\u0131c\u0131",
    "App Name": "Uygulama Ad\u0131",
    "Are you sure to delete": "Silmek istedi\u011finize emin misiniz?",
    "Are you sure you want to clear trash?": "\u00c7\u00f6p tenekesini bo\u015faltmak istedi\u011finize emin misiniz?",
    "Are you sure you want to delete %s ?": "%s'i silmek istedi\u011finize emin misiniz?",
    "Are you sure you want to delete the share link?": "Payla\u015f\u0131m Link'ini silmek istedi\u011finize emin misiniz?",
    "Are you sure you want to delete {placeholder} ?": "{placeholder} silmek istedi\u011finize emin misiniz?",
    "Are you sure you want to disconnect?": "Ba\u011flant\u0131y\u0131 kesmek istedi\u011finizden emin misiniz?",
    "Are you sure you want to restore this library?": "K\u00fct\u00fcphaneyi geri y\u00fcklemek istedi\u011finize emin misiniz?",
    "Are you sure you want to unlink this device?": "Bu cihaz\u0131n ba\u011flant\u0131s\u0131n\u0131 kald\u0131rmak istedi\u011finizden emin misiniz?",
    "Are you sure you want to unpublish this library?": "Bu k\u00fct\u00fcphaneyi yay\u0131ndan kald\u0131rmak istedi\u011finize emin misiniz?",
    "Audio": "Audio",
    "Auto deletion": "Otomatik Silme",
    "Automatically delete files that are not modified within certain days:": "Belirli g\u00fcnler i\u00e7inde de\u011fi\u015ftirilmeyen dosyalar\u0131 otomatik olarak sil:",
    "Avatar": "Avatar",
    "Avatar:": "Avatar:",
    "Back": "Geri",
    "Can not copy directory %(src)s to its subdirectory %(des)s": "Dizin %(src)s alt dizinine %(des)s kopyalanam\u0131yor.",
    "Can not move directory %(src)s to its subdirectory %(des)s": "%(src)s dizini alt dizinine %(des)s ta\u015f\u0131nam\u0131yor.",
    "Cancel": "\u0130ptal",
    "Cancel All": "Hepsini \u0130ptal Et",
    "Change": "De\u011fi\u015ftir",
    "Change Password": "\u015eifreyi De\u011fi\u015ftir",
    "Change Password of Library {placeholder}": "{placeholder} K\u00fct\u00fcphane \u015fifresini de\u011fi\u015ftir",
    "Choose date": "Tarih se\u00e7",
    "Clean": "Temizle",
    "Clean succeeded.": "Temizleme Ba\u015far\u0131l\u0131",
    "Clear": "Temizle",
    "Clear Trash": "\u00c7\u00f6p Tenekesini Bo\u015falt",
    "Clear files in trash and history\uff1a": "\u00c7\u00f6p tenekesindeki ve ge\u00e7mi\u015fteki dosyalar\u0131 sil:",
    "Close": "Kapat",
    "Community Edition": "Topluluk Versiyonu",
    "Confirm": "Onayla",
    "Confirm Password": "\u015eifreyi Onayla",
    "Contact Email": "\u0130leti\u015fim E-postas\u0131",
    "Contact Information": "\u0130leti\u015fim Bilgileri",
    "Contact information is required.": "\u0130leti\u015fim bilgileri gereklidir.",
    "Copy": "Kopyala",
    "Copyright Infringement": "Telif Hakk\u0131 ihlali",
    "Count": "Say",
    "Create": "Olu\u015ftur",
    "Create a new tag": "Yeni bir etiket olu\u015ftur",
    "Created At": "Olu\u015fturuldu",
    "Created Files": "Olu\u015fturulmu\u015f Dosyalar",
    "Created file": "Olu\u015fturulan dosya",
    "Created folder": "Olu\u015fturulan klas\u00f6r",
    "Created library": "Olu\u015fturulmu\u015f k\u00fct\u00fcphane",
    "Creator": "Olu\u015fturan",
    "Current Library": "Ge\u00e7erli K\u00fct\u00fcphane",
    "Current Path: ": "Ge\u00e7erli Yol:",
    "Current path: ": "Ge\u00e7erli yol:",
    "Custom file types": "\u00d6zel doya tipleri",
    "Database": "Veritaban\u0131",
    "Date": "Tarih",
    "Date Invalid.": "Tarih ge\u00e7ersiz.",
    "Default": "Varsay\u0131lan",
    "Delete": "Sil",
    "Delete Account": "Hesab\u0131 Sil",
    "Delete File": "Dosyay\u0131 Sil",
    "Delete Folder": "Klas\u00f6r\u00fc Sil",
    "Delete Group": "Grubu Sil",
    "Delete Library": "K\u00fct\u00fcphaneyi Sil",
    "Delete Member": "\u00dcyeyi Sil",
    "Delete Notification": "Bildirimi Sil",
    "Delete Time": "Zaman\u0131 sil",
    "Delete User": "Kullan\u0131c\u0131y\u0131 sil",
    "Delete draft": "Tasla\u011f\u0131 sil",
    "Delete files from this device the next time it comes online.": "Cihaz\u0131n bir sonraki \u00e7evrimi\u00e7i olu\u015funda, dosyalar\u0131 bu cihazdan sil.",
    "Deleted": "Silindi",
    "Deleted Time": "Silinme Zaman\u0131",
    "Deleted directories": "Silinmi\u015f dizinler",
    "Deleted file": "Silinen dosya",
    "Deleted files": "Silinmi\u015f Dosyalar",
    "Deleted folder": "Silinen klas\u00f6r",
    "Deleted library": "Silinen k\u00fct\u00fcphane",
    "Description": "A\u00e7\u0131klama",
    "Description is required": "A\u00e7\u0131klama gerekli",
    "Details": "Ayr\u0131nt\u0131lar",
    "Device": "Cihaz",
    "Device Name": "Cihaz Ad\u0131",
    "Devices": "Cihazlar",
    "Direct Download Link:": "Do\u011frudan indirme ba\u011flant\u0131s\u0131:",
    "Directory": "Dizin",
    "Disable Two-Factor Authentication": "\u0130ki Fakt\u00f6rl\u00fc Kimlik Do\u011frulamay\u0131 Devre D\u0131\u015f\u0131 B\u0131rak",
    "Disconnect": "Ba\u011flant\u0131y\u0131 Kes",
    "Do not automatically delete files": "Dosyalar\u0131 otomatik olarak silme",
    "Document convertion failed.": "Dok\u00fcman d\u00f6n\u00fc\u015ft\u00fcrme ba\u015far\u0131s\u0131z.",
    "Documents": "D\u00f6k\u00fcmanlar",
    "Don't keep history": "Ge\u00e7mi\u015fi saklama",
    "Don't replace": "De\u011fi\u015ftirme",
    "Download": "\u0130ndir",
    "Download and upload": "\u0130ndir ve y\u00fckle",
    "Draft": "Taslak",
    "Drafts": "Taslaklar",
    "Edit": "D\u00fczenle",
    "Edit labels": "Etiketleri D\u00fczenle",
    "Edit on cloud and download": "Bulut \u00fczerinde d\u00fczenle ve indir",
    "Edit on cloud only": "Sadece bulut \u00fczerinde d\u00fczenle",
    "Edit permission": "\u0130zinleri D\u00fczenle",
    "Edit succeeded": "D\u00fczenleme ba\u015far\u0131l\u0131",
    "Email": "Eposta",
    "Email is invalid.": "Email ge\u00e7ersiz.",
    "Emails": "Emailler",
    "Emails, separated by ','": "Emailler ',' ile birbirinden ayr\u0131l\u0131r",
    "Enable Two-Factor Authentication": "\u0130ki Fakt\u00f6r\u00fcl\u00fc Kimlik Do\u011frulamay\u0131 Etkinle\u015ftir",
    "Encrypt": "\u015eifrele",
    "End date": "Biti\u015f tarihi",
    "Error": "Hata",
    "Exit Institution Admin": "Kurum Y\u00f6neticisinden \u00e7\u0131k",
    "Exit Organization Admin": "Organizasyon Y\u00f6neticisinden \u00c7\u0131k",
    "Exit System Admin": "Sistem Y\u00f6neticisinden \u00c7\u0131k",
    "Expiration": "Zaman a\u015f\u0131m\u0131",
    "Expiration Date:": "Biti\u015f Tarihi:",
    "Expired": "S\u00fcresi doldu",
    "Failed": "Ba\u015far\u0131s\u0131z",
    "Failed to add {email_placeholder}: {error_msg_placeholder}": "{email_placeholder}: {error_msg_placeholder} eklenemedi",
    "Failed to delete draft %(draft)s.": "Taslak %(draft)s silinemedi.",
    "Failed to delete {name}.": "{name} silinemedi.",
    "Failed. Please check the network.": "Ba\u015far\u0131s\u0131z oldu. L\u00fctfen a\u011f\u0131 kontrol edin.",
    "Favorites": "Favoriler",
    "File": "Dosya",
    "File Upload": "Dosya Y\u00fckle",
    "File Uploading...": "Dosyay\u0131 Y\u00fckl\u00fcyor...",
    "File already exists.": "Dosya zaten mevcut.",
    "File does not exist.": "Dosya bulunmuyor.",
    "File download is disabled: the share link traffic of owner is used up.": "Dosya indirme devre d\u0131\u015f\u0131 b\u0131rak\u0131ld\u0131: sahibin ba\u011flant\u0131 payla\u015f\u0131m trafi\u011fi t\u00fckendi.",
    "File is locked by others.": "Dosya ba\u015fkalar\u0131 taraf\u0131ndan kilitlendi.",
    "File size is too large.": "Dosya boyutu \u00e7ok b\u00fcy\u00fck.",
    "Files": "Dosyalar",
    "Folder": "Klas\u00f6r",
    "Folder Permission": "Klas\u00f6r izni",
    "Folders": "Klas\u00f6rler",
    "Generate": "Olu\u015ftur",
    "Generate share link": "Payla\u015f\u0131m ba\u011flant\u0131s\u0131 olu\u015ftur",
    "Group": "Grup",
    "Group Permission": "Gruop \u0130zni",
    "Groups": "Gruplar",
    "Guest": "Misafir",
    "Help": "Yard\u0131m",
    "Hide": "Gizle",
    "History": "Ge\u00e7mi\u015f",
    "History Setting": "Ge\u00e7mi\u015f Ayar\u0131",
    "History Versions": "Ge\u00e7mi\u015f Versiyonlar\u0131",
    "IP": "IP",
    "Images": "G\u00f6rseller",
    "Import users": "Kullan\u0131c\u0131lar\u0131 i\u00e7eri aktar",
    "In all libraries": "T\u00fcm k\u00fct\u00fcphanelerde",
    "Inactive": "\u0130naktif",
    "Indexing...": "Dizin olu\u015fturuluyor...",
    "Info": "Bilgi",
    "Input file extensions here, separate with ','": "Dosya uzant\u0131lar\u0131n\u0131 buraya girin, \"\", ile ay\u0131r\u0131n",
    "Institution Admin": "Kurum Y\u00f6neticisi",
    "Internal Link": "\u0130\u00e7 ba\u011flant\u0131",
    "Internal Server Error": "\u0130\u00e7 Sunucu Hatas\u0131",
    "Invalid destination path": "Ge\u00e7ersiz hedef yolu",
    "Invalid file size range.": "Ge\u00e7ersiz dosya boyutu aral\u0131\u011f\u0131.",
    "Invalid filename.": "Ge\u00e7ersiz Dosya ad\u0131.",
    "Inviter": "Davet eden",
    "It is required.": "Gerekli.",
    "It may take some time, please wait.": "Biraz zaman alabilir, l\u00fctfen bekleyiniz.",
    "Keep full history": "T\u00fcm ge\u00e7mi\u015fi sakla",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP(al\u0131nan)",
    "Language": "Dil",
    "Language Setting": "Dil Ayarlar\u0131",
    "Last Access": "Son Eri\u015fim",
    "Last Login": "En son giri\u015f",
    "Last Update": "En son G\u00fcncelleme",
    "Leave": "Ayr\u0131l",
    "Leave Group": "Gruptan Ayr\u0131l",
    "Leave Share": "Payla\u015f\u0131mdan Ayr\u0131l",
    "Libraries": "K\u00fct\u00fcphaneler",
    "Library": "K\u00fct\u00fcphane",
    "Library can not be shared to owner.": "K\u00fct\u00fcphane, sahibiyle payla\u015f\u0131lamaz.",
    "Link": "Ba\u011flant\u0131",
    "Link:": "Ba\u011flant\u0131:",
    "Linked Devices": "Ba\u011fl\u0131 Cihazlar",
    "Links": "Ba\u011flant\u0131lar",
    "Local draft": "Yerel Taslak",
    "Location": "Konum",
    "Lock": "Kilitle",
    "Log out": "\u00c7\u0131k\u0131\u015f yap",
    "Logs": "Loglar",
    "Manage group members": "Grup \u00fcyelerini y\u00f6net",
    "Mark all read": "T\u00fcm\u00fcn\u00fc okundu olarak i\u015faretle",
    "Member": "\u00dcye",
    "Members": "\u00dcyeler",
    "Message": "Mesaj",
    "Message (optional):": "Mesaj (iste\u011fe ba\u011fl\u0131):",
    "Modification Details": "De\u011fi\u015ftirme Ayr\u0131nt\u0131lar\u0131",
    "Modified": "De\u011fi\u015ftirildi",
    "Modified files": "De\u011fi\u015ftirilmi\u015f dosyalar",
    "Modifier": "De\u011fi\u015ftirici",
    "Modify": "De\u011fi\u015ftir",
    "Month:": "Ay:",
    "More": "Daha fazla",
    "More Operations": "Daha fazla i\u015flem",
    "Move": "Ta\u015f\u0131",
    "Move selected item(s) to:": "Se\u00e7ilen \u00f6\u011fe(leri) \u015furaya ta\u015f\u0131:",
    "Moved file": "Ta\u015f\u0131nan dosya",
    "Moved folder": "Ta\u015f\u0131nan klas\u00f6r",
    "My Groups": "Gruplar\u0131m",
    "My Libraries": "K\u00fct\u00fcphanelerim",
    "Name": "\u0130sim",
    "Name is required": "\u0130sim gerekli",
    "Name is required.": "\u0130sim gerekli.",
    "Name should not include '/'.": "\u0130sim '/.' i\u00e7ermemelidir.",
    "Name(optional)": "\u0130sim (iste\u011fe ba\u011fl\u0131)",
    "Network error": "A\u011f hatas\u0131",
    "New Department Library": "Yeni B\u00f6l\u00fcm K\u00fct\u00fcphanesi",
    "New File": "Yeni Dosya",
    "New Folder": "Yeni Klas\u00f6r",
    "New Group": "Yeni Grup",
    "New Library": "Yeni K\u00fct\u00fcphane",
    "New Password": "Yeni \u015eifre",
    "New Password Again": "Yeni \u015e\u0130fre Tekrar",
    "New Tag": "Yeni Etiket",
    "New Wiki": "Yeni Wiki",
    "New directories": "Yeni dizinler",
    "New file name": "Yeni dosya ad\u0131",
    "New files": "Yeni Dosyalar",
    "New folder name": "Yeni klas\u00f6r ad\u0131",
    "New password is too short": "Yeni \u015fifre \u00e7ok k\u0131sa",
    "New passwords don't match": "Yeni \u015fifreler e\u015fle\u015fmiyor",
    "Next": "Sonraki",
    "No": "Hay\u0131r",
    "No members": "\u00dcye yok",
    "No preview": "\u00d6nizleme yok",
    "No result": "Sonu\u00e7 yok",
    "No results matching.": "E\u015fle\u015fen sonu\u00e7 yok.",
    "None": "Yok                                     ",
    "Notification Detail": "Bildirim Detay\u0131",
    "Notifications": "Bildirimler",
    "Number of groups": "Grup say\u0131s\u0131",
    "Off": "Kapal\u0131",
    "Old Password": "Eski \u015eifre",
    "On": "A\u00e7\u0131k",
    "Only keep a period of history:": "Sadece bu d\u00f6nemdeki ge\u00e7mi\u015fi sakla:",
    "Open parent folder": "Ana klas\u00f6r a\u00e7",
    "Open via Client": "Client \u00fczerinden a\u00e7",
    "Operation": "\u0130\u015flem",
    "Operation succeeded.": "\u0130\u015flem ba\u015far\u0131l\u0131.",
    "Operations": "\u0130\u015flemler",
    "Organization": "Organizasyon",
    "Organization Admin": "Organizasyon Y\u00f6neticisi",
    "Organizations": "Organizasyonlar",
    "Other": "Di\u011fer",
    "Other Libraries": "Di\u011fer K\u00fct\u00fcphaneler",
    "Out of quota.": "Kota d\u0131\u015f\u0131nda.",
    "Owner": "Sahip",
    "Owner can use admin panel in an organization, must be a new account.": "Bir organizasyonda y\u00f6netici panelini sahip kullanabilir ve bu yeni bir hesap olmal\u0131d\u0131r.",
    "Password": "\u015eifre",
    "Password again": "\u015eifre tekrar",
    "Password is too short": "\u015eifre \u00e7ok k\u0131sa",
    "Password:": "\u015eifre:",
    "Passwords do not match.": "Parolalar uyu\u015fmuyor.",
    "Passwords don't match": "\u015eifreler e\u015fle\u015fmiyor.",
    "Permission": "\u0130zin",
    "Permission denied": "\u0130zin reddedildi",
    "Permission name": "\u0130zin Ad\u0131",
    "Permission:": "\u0130zin:",
    "Platform": "Platform",
    "Please check the network.": "L\u00fctfen a\u011f\u0131 kontrol edin.",
    "Please enter 1 or more character": "L\u00fctfen, 1 veya daha fazla karakter giriniz",
    "Please enter a new password": "L\u00fctfen yeni bir \u015fifre girin",
    "Please enter a non-negative integer": "L\u00fctfen, negatif olmayan bir tam say\u0131 giriniz",
    "Please enter a password.": "L\u00fctfen, bir \u015fifre giriniz.",
    "Please enter a positive integer": "L\u00fctfen, pozitif bir tam say\u0131 giriniz",
    "Please enter days": "L\u00fctfen g\u00fcnleri girin",
    "Please enter password": "L\u00fctfen \u015fifre giriniz",
    "Please enter the new password again": "L\u00fctfen yeni \u015fifreyi tekrar giriniz",
    "Please enter the old password": "L\u00fctfen eski \u015fifreyi giriniz",
    "Please enter the password again": "L\u00fctfen \u015fifreyi tekrar giriniz.",
    "Please input at least an email.": "L\u00fctfen en az bir eposta giri\u015fi yap\u0131n",
    "Please select a library to share.": "L\u00fctfen, payla\u015fmak i\u00e7in bir k\u00fct\u00fcphane se\u00e7iniz.",
    "Please select an expiration time": "L\u00fctfen, bir sona erme s\u00fcresi se\u00e7iniz",
    "Please upload no more than {maxFiles} files at a time.": "L\u00fctfen, tek seferde {maxFiles} say\u0131s\u0131ndan fazla dosya y\u00fcklemeyiniz.",
    "Preparing to upload...": "Y\u00fcklemeye haz\u0131rlan\u0131yor...",
    "Preview and download": "\u00d6nizleme ve indirme",
    "Preview online": "\u00c7evrimi\u00e7i \u00d6nizleme",
    "Preview only": "Sadece \u00f6nizleme",
    "Previous": "\u00d6nceki",
    "Professional Edition": "Profesyonel Versiyon",
    "Profile": "Profil",
    "Profile Setting": "Profil Ayarlar\u0131",
    "Publish": "Yay\u0131nla",
    "Published Libraries": "Yay\u0131nlanm\u0131\u015f K\u00fct\u00fcphaneler",
    "Quota is invalid.": "Kota ge\u00e7ersiz.",
    "Read-Only": "Salt okunur",
    "Read-Write": "Okuma-Yazma",
    "Really want to delete this group?": "Bu grubu ger\u00e7ekten silmek istiyor musunuz?",
    "Really want to delete your account?": "Hesab\u0131n\u0131z\u0131 silmeyi ger\u00e7ekten istiyor musunuz?",
    "Really want to leave this group?": "Bu gruptan ayr\u0131lmak istedi\u011finize emin misiniz?",
    "Refresh": "Yenile",
    "Remaining": "Geriye kalan",
    "Remove": "Kald\u0131r",
    "Removed all items from trash.": "B\u00fct\u00fcn \u00f6\u011feler \u00e7\u00f6p kutusundan kald\u0131r\u0131ld\u0131.",
    "Rename": "Yeniden Adland\u0131r",
    "Rename File": "Dosyay\u0131 yeniden adland\u0131r",
    "Rename Folder": "Klas\u00f6r\u00fc yeniden adland\u0131r",
    "Rename Group": "Grubu yeniden adland\u0131r",
    "Renamed file": "Yeniden adland\u0131r\u0131lan dosya",
    "Renamed folder": "Yeniden adland\u0131r\u0131lan klas\u00f6r",
    "Renamed library": "Yeniden adland\u0131r\u0131lan k\u00fct\u00fcphane",
    "Renamed or Moved files": "Yeniden Adland\u0131r\u0131lm\u0131\u015f ya da Ta\u015f\u0131nm\u0131\u015f Dosyalar",
    "Replace": "De\u011fi\u015ftir",
    "Replacing it will overwrite its content.": "De\u011fi\u015ftirirseniz, i\u00e7eri dosyan\u0131n \u00fczerine yazacak.",
    "Report Abuse": "K\u00f6t\u00fcye kullan\u0131m\u0131 bildir",
    "Request a review": "\u0130nceleme talep et",
    "Reset Password": "\u015eifre S\u0131f\u0131rla",
    "Reset library password": "K\u00fct\u00fcphane \u015fifresini s\u0131f\u0131rla",
    "ResetPwd": "\u015eifreyi S\u0131f\u0131rla",
    "Restore": "Eski durumuna getir",
    "Restore Library": "K\u00fct\u00fcphaneyi Geri Y\u00fckle",
    "Restored file": "Geri y\u00fcklenen dosya",
    "Restored folder": "Geri y\u00fcklenen klas\u00f6r",
    "Restored library": "Geri y\u00fcklenen k\u00fct\u00fcphane",
    "Result": "Sonu\u00e7",
    "Retry": "Tekrar dene",
    "Retry All": "Hepsini tekrar dene",
    "Revoke Access": "Eri\u015fimi iptal et",
    "Revoke Admin": "Y\u00f6neticiyi \u0130ptal et",
    "Role": "Rol",
    "Save": "Kaydet",
    "Save as ...": "... olarak kaydet",
    "Saving...": "Kaydediliyor...",
    "Seafile": "Seafile",
    "Search": "Ara",
    "Search files in this library": "Dosyalar\u0131 bu k\u00fct\u00fcphanede ara",
    "Search group members": "Grup \u00fcyelerini ara",
    "Select File": "Dosya Se\u00e7",
    "Select Image": "G\u00f6r\u00fcnt\u00fc Se\u00e7",
    "Select Tags": "Etiketleri Se\u00e7",
    "Select a color": "Bir renk se\u00e7",
    "Select a group": "Bir grup se\u00e7iniz",
    "Select groups": "Grup se\u00e7in",
    "Select libraries to share": "Payla\u015fmak i\u00e7in k\u00fct\u00fcphane se\u00e7in",
    "Send": "G\u00f6nder",
    "Send to:": "\u015euna g\u00f6nder:",
    "Sending new password...": "Yeni \u015fifre g\u00f6nderiliyor...",
    "Sending...": "G\u00f6nderiyor...",
    "Server": "Sunucu",
    "Server Version: ": "Sunucu Versiyonu:",
    "Set Admin": "Y\u00f6netici Olu\u015ftur",
    "Set Name": "Ad belirle",
    "Set Password": "Parola Olu\u015ftur",
    "Set Quota": "Kota Olu\u015ftur",
    "Set max number of members": "Maksimum \u00fcye say\u0131s\u0131n\u0131 belirle",
    "Set permission": "\u0130zin belirle",
    "Set to current": "\u015eimdikine ayarla",
    "Set user name": "Kullan\u0131c\u0131 ad\u0131 belirle",
    "Set user quota": "Kullan\u0131c\u0131 kotas\u0131n\u0131 belirle",
    "Set {placeholder}'s permission": "{placeholder} i\u00e7in izin belirle",
    "Setting library history is disabled by Admin.": "K\u00fct\u00fcphane ge\u00e7mi\u015f ayar\u0131, Admin taraf\u0131ndan devre d\u0131\u015f\u0131 b\u0131rak\u0131ld\u0131.",
    "Settings": "Ayarlar",
    "Share": "Payla\u015f",
    "Share Admin": "Payla\u015fma Y\u00f6neticisi",
    "Share From": "Buradan Payla\u015f",
    "Share Link": "Ba\u011flant\u0131y\u0131 Payla\u015f",
    "Share Links": "Ba\u011flant\u0131lar\u0131 payla\u015f",
    "Share To": "\u015eununla payla\u015f",
    "Share existing libraries": "Mevcut k\u00fct\u00fcphaneleri payla\u015f",
    "Share link is copied to the clipboard.": "Payla\u015f\u0131m ba\u011flant\u0131s\u0131 panoya kopyaland\u0131.",
    "Share to group": "Grupla Payla\u015f",
    "Share to other server": "Ba\u015fka sunucuyla payla\u015f",
    "Share to user": "Kullan\u0131c\u0131 ile Payla\u015f",
    "Shared By": "Payla\u015fan",
    "Shared Libraries": "Payla\u015f\u0131lm\u0131\u015f K\u00fct\u00fcphaneler",
    "Shared Links": "Payla\u015f\u0131lan ba\u011flant\u0131lar",
    "Shared by:": "Taraf\u0131ndan payla\u015f\u0131ld\u0131:",
    "Shared by: ": "Payla\u015fan:",
    "Shared with all": "Herkesle payla\u015f\u0131lanlar",
    "Shared with groups": "Gruplarla payla\u015f\u0131lanlar",
    "Shared with me": "Benimle payla\u015f\u0131lanlar",
    "Show": "G\u00f6ster",
    "Side Nav Menu": "Yan Gezinme Men\u00fcs\u00fc",
    "Size": "Boyut",
    "Space Used": "Kullan\u0131lm\u0131\u015f Alan",
    "Star": "Y\u0131ld\u0131z",
    "Start date": "Ba\u015flang\u0131\u00e7 tarihi",
    "Status": "Durum",
    "Storage Backend": "Backend Depolama",
    "Submit": "G\u00f6nder",
    "Success": "Ba\u015far\u0131l\u0131",
    "Successfully changed library password.": "K\u00fct\u00fcphane \u015fifresi ba\u015far\u0131yla de\u011fi\u015ftirildi.",
    "Successfully copied %(name)s and %(amount)s other items.": "%(name)s ve %(amount)s ba\u015fka \u00f6\u011fe ba\u015far\u0131yla kopyaland\u0131.",
    "Successfully copied %(name)s and 1 other item.": "%(name)s ve 1 di\u011fer \u00f6\u011fe ba\u015far\u0131yla kopyaland\u0131.",
    "Successfully copied %(name)s.": "%(name)s ba\u015far\u0131yla kopyaland\u0131.",
    "Successfully deleted 1 item.": "1 \u00f6\u011fe ba\u015far\u0131yla silindi.",
    "Successfully deleted draft %(draft)s.": "Taslak %(draft)s ba\u015far\u0131yla silindi.",
    "Successfully edited labels.": "Etiketler ba\u015far\u0131yla d\u00fczenlendi.",
    "Successfully invited %(email).": "Ba\u015far\u0131yla davet edildi %(email).",
    "Successfully modified permission.": "\u0130zin ba\u015far\u0131yla de\u011fi\u015ftirildi.",
    "Successfully moved %(name)s and %(amount)s other items.": "%(name)s ve %(amount)s ba\u015fka \u00f6\u011fe ba\u015far\u0131yla ta\u015f\u0131nd\u0131.",
    "Successfully moved %(name)s and 1 other item.": "%(name)s ve 1 di\u011fer \u00f6\u011fe ba\u015far\u0131yla ta\u015f\u0131nd\u0131.",
    "Successfully moved %(name)s.": "%(name)s ba\u015far\u0131yla ta\u015f\u0131nd\u0131.",
    "Successfully reset password to %(passwd)s for user %(user)s.": "Kullan\u0131c\u0131 %(user)s i\u00e7in \u015fifre %(passwd)s'e s\u0131f\u0131rland\u0131.",
    "Successfully restored 1 item.": "1 \u00f6\u011fe ba\u015far\u0131yla geri y\u00fcklendi.",
    "Successfully restored the library.": "K\u00fct\u00fcphane ba\u015far\u0131yla geri y\u00fcklendi.",
    "Successfully revoke the admin permission of %s": "%s i\u00e7in y\u00f6netici izni iptal edildi.",
    "Successfully saved": "Ba\u015far\u0131yla Kaydedildi",
    "Successfully sent to {placeholder}": "{placeholder}'a g\u00f6nderildi",
    "Successfully set %s as admin.": "%s y\u00f6netici olarak olu\u015fturuldu.",
    "Successfully set it.": "Ba\u015far\u0131yla Ayarland\u0131.",
    "Successfully set library history.": "K\u00fct\u00fcphane ge\u00e7mi\u015fi ba\u015far\u0131yla ayarland\u0131.",
    "Sync Download": "Senkronize \u0130ndirme",
    "Sync Upload": "Senkronize Y\u00fckleme",
    "System": "Sistem",
    "System Admin": "Sistem Y\u00f6neticisi",
    "System Info": "Sistem Bilgisi",
    "Tag \"{name}\" already exists.": "\"{name}\" etiket zaten mevcut.",
    "Tagged Files": "Etiketli Dosyalar",
    "Tags": "Etiketler",
    "Template": "\u015eablon",
    "Terms": "\u015eartlar",
    "Text": "Metin",
    "Text files": "Metin dosyalar\u0131",
    "Text is required.": "Metin gerekli",
    "The name \"{name}\" is already taken. Please choose a different name.": "\"{name}\" ismi zaten al\u0131nm\u0131\u015f. L\u00fctfen, farkl\u0131 bir isim se\u00e7iniz.",
    "The owner of this library has run out of space.": "Bu k\u00fct\u00fcphane sahibinin alan\u0131 kalmad\u0131.",
    "The password is too short.": "\u015eifre \u00e7ok k\u0131sa.",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": "\u015eifre \u00e7ok zay\u0131f. \u015eifreniz en az {passwordStrengthLevel} birer adet say\u0131, b\u00fcy\u00fck harf, k\u00fc\u00e7\u00fck harf ve di\u011fer simgelerden i\u00e7ermelidir.",
    "The password will be kept in the server for only 1 hour.": "\u015eifre sadece 1 saat sunucuda tutulacakt\u0131r.",
    "This folder has no content at this time.": "Bu klas\u00f6rde \u015fu an i\u00e7erik yok.",
    "This library is password protected": "Bu k\u00fct\u00fcphane \u015fifre korumal\u0131.",
    "This operation will not be reverted. Please think twice!": "Bu i\u015flem geri al\u0131namaz. L\u00fctfen iki kez d\u00fc\u015f\u00fcn\u00fcn\u00fcn!",
    "Time": "Zaman",
    "Tip: -2 means no limit.": "\u0130pucu: -2 limit yok anlam\u0131na gelir.",
    "Tip: 0 means default limit": "T\u00fcyo: 0 varsay\u0131lan limit anlam\u0131na gelir.",
    "Tools": "Ara\u00e7lar",
    "Total Users": "Toplam Kullan\u0131c\u0131",
    "Traffic": "Trafik",
    "Transfer": "Transfer",
    "Transfer Library": "K\u00fct\u00fcphaneyi transfer et",
    "Trash": "\u00c7\u00f6p Kutusu",
    "Two-Factor Authentication": "\u00c7ift Fakt\u00f6rl\u00fc Kimlik Do\u011frulama",
    "Type": "Tip",
    "Unknown": "Bilinmeyen",
    "Unlink": "Ba\u011flant\u0131y\u0131 kald\u0131r",
    "Unlink device": "Cihaz ba\u011flant\u0131s\u0131n\u0131 kald\u0131r",
    "Unlock": "Kilidi A\u00e7",
    "Unpublish": "Yay\u0131ndan kald\u0131r",
    "Unpublish Library": "K\u00fct\u00fcphaneyi yay\u0131ndan kald\u0131r",
    "Unshare": "Payla\u015fma",
    "Unshare Library": "K\u00fct\u00fcphane payla\u015f\u0131m\u0131n\u0131 kald\u0131r",
    "Unstar": "Y\u0131ld\u0131z\u0131 kald\u0131r",
    "Update": "G\u00fcncelle",
    "Update Terms and Conditions": "\u015eartlar\u0131 ve Ko\u015fullar\u0131 G\u00fcncelle",
    "Updated file": "G\u00fcncellenen dosya",
    "Upgrade to Pro Edition": "Pro Versiyona Y\u00fckseltin",
    "Upload": "Y\u00fckle",
    "Upload Files": "Dosyalar\u0131 y\u00fckle",
    "Upload Folder": "Klas\u00f6r y\u00fckle",
    "Upload Link": "Ba\u011flant\u0131y\u0131 Y\u00fckle",
    "Upload Links": "Ba\u011flant\u0131lar\u0131 Y\u00fckle",
    "Upload file": "Dosya y\u00fckle",
    "Uploaded": "Y\u00fcklendi",
    "Use draft": "Tasla\u011f\u0131 kullan",
    "Used:": "Kullan\u0131ld\u0131:",
    "User": "Kullan\u0131c\u0131",
    "User Email": "Kullan\u0131c\u0131 E-postas\u0131",
    "User Permission": "Kullan\u0131c\u0131 \u0130zni",
    "User {user_link} has added you to {group_link}": "{user_link} Kullan\u0131c\u0131s\u0131 Sizi {group_link} ekledi",
    "Users": "Kullan\u0131c\u0131lar",
    "Verify": "Do\u011frula",
    "Version Number": "Versiyon numaras\u0131",
    "Version Number is required.": "Verisyon numaras\u0131 gerekli.",
    "Version Number must be a number.": "Versiyon numaras\u0131, bir numara olmal\u0131d\u0131r.",
    "Video": "Video",
    "View": "G\u00f6r\u00fcnt\u00fcle",
    "View Draft": "Tasla\u011f\u0131 G\u00f6r\u00fcnt\u00fcle",
    "View Snapshot": "Snapshot G\u00f6ster",
    "View profile and more": "Profili ve daha fazlas\u0131n\u0131 g\u00f6r\u00fcnt\u00fcle",
    "Virus": "Virus",
    "Visits": "Ziyaretler",
    "Web Download": "Web \u0130ndirme",
    "Web Upload": "Web y\u00fckleme",
    "Wrong password": "Hatal\u0131 \u015fifre",
    "Yes": "Evet",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "Bir kullan\u0131c\u0131y\u0131 misafir olarak da ekleyebilirsiniz. Misafir kullan\u0131c\u0131n\u0131n k\u00fct\u00fcphane ve grup olu\u015fturma izni yoktur.",
    "You can create files quickly": "Dosyalar\u0131 h\u0131zl\u0131 bir \u015fekilde olu\u015fturabilirsiniz",
    "You have an unsaved draft. Do you like to use it?": "Kaydedilmemi\u015f bir tasla\u011f\u0131n\u0131z var. Kullanmak ister misiniz?",
    "ZIP": "ZIP",
    "all": "hepsi",
    "all members": "t\u00fcm \u00fcyeler",
    "days": "g\u00fcn",
    "deleted": "Silindi",
    "email is required": "Email gereklidir",
    "icon": "simge",
    "locked": "kilitli",
    "locked by {name}": "{name} taraf\u0131ndan kilitlendi",
    "name": "isim",
    "progress": "y\u00fcr\u00fct\u00fcl\u00fcyor",
    "shared by:": "payla\u015fan:",
    "show more": "Daha fazla g\u00f6ster",
    "size": "boyut",
    "starred": "y\u0131ld\u0131zl\u0131",
    "state": "durum",
    "to": "Kime",
    "unstarred": "Y\u0131ld\u0131z\u0131 kald\u0131r\u0131lm\u0131\u015f",
    "you can also press \u2190 ": "\u015euna da basabilirsiniz \u2190",
    "{from_user} has sent you a request for {draft_link}.": "{from_user}, {draft_link} i\u00e7in sana bir istek g\u00f6nderdi.",
    "{placeholder} Folder Permission": "{placeholder} Klas\u00f6r \u0130zni",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from}, {group_link} grubuna {repo_link} adl\u0131 bir klas\u00f6r payla\u015ft\u0131.",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} sizinle {repo_link} adl\u0131 bir klas\u00f6r payla\u015ft\u0131",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from}, {group_link} grubuna {repo_link} adl\u0131 bir k\u00fct\u00fcphane payla\u015ft\u0131.",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} sizinle {repo_link} adl\u0131 bir k\u00fct\u00fcphane payla\u015ft\u0131.",
    "{user} has transfered a library named {repo_link} to you.": "{user}, {repo_link} adl\u0131 bir k\u00fct\u00fcphaneye sizi ekledi."
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "d F Y H:i",
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S",
      "%d/%m/%Y %H:%M:%S.%f",
      "%d/%m/%Y %H:%M",
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%Y-%m-%d"
    ],
    "DATE_FORMAT": "d F Y",
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y",
      "%d/%m/%y",
      "%y-%m-%d",
      "%Y-%m-%d"
    ],
    "DECIMAL_SEPARATOR": ",",
    "FIRST_DAY_OF_WEEK": 1,
    "MONTH_DAY_FORMAT": "d F",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "d M Y H:i",
    "SHORT_DATE_FORMAT": "d M Y",
    "THOUSAND_SEPARATOR": ".",
    "TIME_FORMAT": "H:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

