# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-03-21 08:43


import datetime
from django.db import migrations, models
import django.db.models.deletion
import seahub.base.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AnonymousShare',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('repo_owner', seahub.base.fields.LowerCaseCharField(max_length=255)),
                ('repo_id', models.CharField(max_length=36)),
                ('anonymous_email', seahub.base.fields.LowerCaseCharField(max_length=255)),
                ('token', models.CharField(max_length=25, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='ExtraGroupsSharePermission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('repo_id', models.CharField(db_index=True, max_length=36)),
                ('group_id', models.IntegerField(db_index=True)),
                ('permission', models.CharField(max_length=30)),
            ],
        ),
        migrations.CreateModel(
            name='ExtraSharePermission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('repo_id', models.CharField(db_index=True, max_length=36)),
                ('share_to', models.CharField(db_index=True, max_length=255)),
                ('permission', models.CharField(max_length=30)),
            ],
        ),
        migrations.CreateModel(
            name='FileShare',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', seahub.base.fields.LowerCaseCharField(db_index=True, max_length=255)),
                ('repo_id', models.CharField(db_index=True, max_length=36)),
                ('path', models.TextField()),
                ('token', models.CharField(max_length=100, unique=True)),
                ('ctime', models.DateTimeField(default=datetime.datetime.now)),
                ('view_cnt', models.IntegerField(default=0)),
                ('s_type', models.CharField(db_index=True, default=b'f', max_length=2)),
                ('password', models.CharField(max_length=128, null=True)),
                ('expire_date', models.DateTimeField(null=True)),
                ('permission', models.CharField(choices=[(b'view_download', b'View and download'), (b'view_only', b'Disable download')], db_index=True, default=b'view_download', max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='OrgFileShare',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('org_id', models.IntegerField(db_index=True)),
                ('file_share', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='share.FileShare')),
            ],
        ),
        migrations.CreateModel(
            name='PrivateFileDirShare',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_user', seahub.base.fields.LowerCaseCharField(db_index=True, max_length=255)),
                ('to_user', seahub.base.fields.LowerCaseCharField(db_index=True, max_length=255)),
                ('repo_id', models.CharField(db_index=True, max_length=36)),
                ('path', models.TextField()),
                ('token', models.CharField(max_length=10, unique=True)),
                ('permission', models.CharField(max_length=5)),
                ('s_type', models.CharField(default=b'f', max_length=5)),
            ],
        ),
        migrations.CreateModel(
            name='UploadLinkShare',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', seahub.base.fields.LowerCaseCharField(db_index=True, max_length=255)),
                ('repo_id', models.CharField(db_index=True, max_length=36)),
                ('path', models.TextField()),
                ('token', models.CharField(max_length=100, unique=True)),
                ('ctime', models.DateTimeField(default=datetime.datetime.now)),
                ('view_cnt', models.IntegerField(default=0)),
                ('password', models.CharField(max_length=128, null=True)),
                ('expire_date', models.DateTimeField(null=True)),
            ],
        ),
    ]
