

'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = (n == 0 || n == 1) ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(If left blank, owner will be admin)": " (Sans autre sp\u00e9cification, l'utilisateur actuel devient le propri\u00e9taire.)",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "(au moins {passwordMinLength} caract\u00e8res et {passwordStrengthLevel} exemplaires des caract\u00e8res suivant: nombres, majuscules, minuscules et caract\u00e8res sp\u00e9ciaux)",
    "(at least {placeholder} characters)": "(au moins {placeholder} caract\u00e8res)",
    "(current notification)": " (notification actuelle)",
    "(current version)": "(version actuelle)",
    "(deleted)": "(supprim\u00e9)",
    "1 Year": "1 An",
    "1 month ago": "Il y a 1 mois",
    "1 week ago": "Il y a 1 semaine",
    "3 days ago": "Il y a 3 jours",
    "30 Days": "30 Jours",
    "7 Days": "7 Jours",
    "A file is being uploaded. Are you sure you want to leave this page?": "Un fichier a \u00e9t\u00e9 mis \u00e0 jour. \u00cates-vous certain de vouloir quitter cette page ?",
    "A file with the same name already exists in this folder.": "Un fichier avec un nom identique existe d\u00e9j\u00e0 dans ce dossier.",
    "API token is copied to the clipboard.": "Le jeton API est copi\u00e9 dans le presse-papiers.",
    "About": "\u00c0 propos",
    "About Us": "\u00c0 propos de nous",
    "Abuse Content": "Contenu de l'abus",
    "Abuse Reports": "Rapports d'abus",
    "Abuse Type": "Type d'abus",
    "Accept": "Accepter",
    "Accepted": "Accept\u00e9es",
    "Accepter": "Accepter",
    "Access Log": "Fichier journaux",
    "Action": "Action",
    "Actions": "Actions",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "Activer l'utilisateur imm\u00e9diatement apr\u00e8s l'inscription. Si c'est d\u00e9coch\u00e9, l'utilisateur devra \u00eatre activ\u00e9 par un administrateur ou via e-mail.",
    "Activated": "Activ\u00e9",
    "Activated Users": "Utilisateurs actifs",
    "Active": "Actif",
    "Active Users": "Utilisateurs actifs",
    "Activities": "Activit\u00e9s",
    "Add": "Ajouter",
    "Add Admin": "Ajouter un administrateur",
    "Add Admins": "Ajouter des administrateurs",
    "Add Institution": "Ajouter institution",
    "Add Library": "Ajouter une biblioth\u00e8que",
    "Add Member": "Ajouter un membre",
    "Add Organization": "Ajouter une Organisation",
    "Add Terms and Conditions": "Ajouter des conditions d'utilisation",
    "Add User": "Ajouter un utilisateur",
    "Add admin": "Ajouter un administrateur",
    "Add auto expiration": "Ajouter une date d'expiration",
    "Add custom permission": "Ajouter des droits personnaliser",
    "Add group member": "Ajouter un membre au groupe",
    "Add institution": "Ajouter une institution",
    "Add new notification": "Ajouter une notification",
    "Add new reviewer": "Ajouter un nouveau r\u00e9dacteur",
    "Add password protection": "Ajouter un mot de passe",
    "Add permission": "Ajouter un droit",
    "Add user": "Ajouter un utilisateur",
    "Added": "Ajout\u00e9",
    "Added user {user}": "Utilisateur {user} ajout\u00e9",
    "Admin": "Administration",
    "Admin Login Logs": "Logs de connexion d'aministrateur",
    "Admin Logs": "Logs admin",
    "Admin Operation Logs": "Logs d'op\u00e9rations administrateur",
    "Admin access": "Acc\u00e8s administrateur",
    "Admins": "Administrateurs",
    "All": "Toutes",
    "All Groups": "Mes groupes",
    "All Libraries": "Toutes les biblioth\u00e8ques",
    "All Notifications": "Toutes les notifications",
    "All Public Links": "Tous les liens publics",
    "All file types": "Tous les types de fichier",
    "All files uploaded": "Tous les fichiers ont \u00e9t\u00e9s envoy\u00e9s",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "Autoriser les inscriptions des nouveaux utilisateurs. D\u00e9cochez ceci afin d'\u00e9viter que n'importe qui puisse cr\u00e9er un nouveau compte.",
    "Allow user to change library history settings": "Autoriser l'utilisateur \u00e0 changer les param\u00e8tres d'historique d'une biblioth\u00e8que",
    "Allow user to clean library trash": "Autoriser l'utilisateur \u00e0 nettoyer la corbeille de la biblioth\u00e8que",
    "Allow user to create encrypted libraries": "Autoriser l'utilisateur \u00e0 cr\u00e9er une biblioth\u00e8que crypt\u00e9e",
    "An integer that is greater than 0 or equal to -2.": "Un nombre entier sup\u00e9rieur \u00e0 0 ou \u00e9gal \u00e0 -2.",
    "An integer that is greater than or equal to 0.": "Un entier sup\u00e9rieur ou \u00e9gal \u00e0 0.",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "Un lien interne est un lien vers un fichier ou un dossier accessible en lecture par un utilisateur.",
    "Anonymous User": "Utilisateur anonyme",
    "Another user is editing this file!": "Un autre utilisateur est en train de modifier le fichier.",
    "App Federation Metadata URL": "App Federation Metadata URL",
    "App Name": "Nom de l'application",
    "Are you sure to delete": "\u00cates-vous certain de vouloir supprimer ?",
    "Are you sure to revoke access of user {placeholder} ?": "\u00cates-vous certain de vouloir r\u00e9voquer l'acc\u00e8s \u00e0 l\u2019utilisateur {placeholder} ?",
    "Are you sure you want to clean invalid share links?": "\u00cates-vous certain de vouloir supprimer les liens de t\u00e9l\u00e9chargement invalides ?",
    "Are you sure you want to clean invalid upload links?": "\u00cates-vous certain de vouloir supprimer les liens d'envoiv invalides ?",
    "Are you sure you want to clear trash?": "\u00cates-vous certain de vouloir vider la corbeille ?",
    "Are you sure you want to delete %s ?": "\u00cates-vous certain de vouloir supprimer %s ?",
    "Are you sure you want to delete WebDAV password?": "\u00cates-vous certain de vouloir supprimer le mot de passe WebDAV ?",
    "Are you sure you want to delete the notification ?": "\u00cates-vous certain de vouloir supprimer la notification?",
    "Are you sure you want to delete the selected share link(s) ?": "\u00cates-vous s\u00fbr de vouloir supprimer le(s) lien(s) de partage s\u00e9lectionn\u00e9(s) ?",
    "Are you sure you want to delete the selected user(s) ?": "\u00cates-vous certain de vouloir supprimer le(s) utilisateur(s) s\u00e9lectionn\u00e9(s) ?",
    "Are you sure you want to delete the share link?": "\u00cates-vous certain de vouloir supprimer ce lien de partage ?",
    "Are you sure you want to delete {placeholder} ?": "\u00cates-vous certain de vouloir supprimer {placeholder} ?",
    "Are you sure you want to delete {placeholder} completely?": "\u00cates-vous certain de vouloir supprimer compl\u00e8tement\u00a0la biblioth\u00e8que {placeholder}?",
    "Are you sure you want to disconnect?": "\u00cates-vous certain de vouloir vous d\u00e9connecter ?",
    "Are you sure you want to remove {placeholder} ?": "\u00cates-vous certain de vouloir retirer {placeholder} de ce groupe?",
    "Are you sure you want to reset the password of {placeholder} ?": "\u00cates-vous certain de vouloir r\u00e9initialiser le mot de passe de {placeholder}?",
    "Are you sure you want to restore this library?": "\u00cates-vous certain de vouloir restaurer la biblioth\u00e8que ?",
    "Are you sure you want to restore {placeholder}?": "\u00cates-vous certain de vouloir restaurer la biblioth\u00e8que {placeholder}?",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "\u00cates-vous certain de vouloir r\u00e9voquer les droits de l\u2019administration de {placeholder}?",
    "Are you sure you want to set {placeholder} as Admin?": "\u00cates-vous certain de vouloir de faire {name} L'administrateur?",
    "Are you sure you want to unlink this device?": "\u00cates-vous certain de vouloir supprimer le lien vers l'appareil ?",
    "Are you sure you want to unpublish this library?": "\u00cates-vous certain de vouloir annuler la publication de cette biblioth\u00e8que ?",
    "Are you sure you want to unshare {placeholder} ?": "\u00cates-vous certain de vouloir annuler le partage {placeholder} ?",
    "At server": "Serveur",
    "Audio": "Audio",
    "Audit Admin": "Administrateur d'audit",
    "Auto Deletion Setting": "Param\u00e8tres de suppression automatique",
    "Auto deletion": "Autosuppression",
    "Automatically delete files that are not modified within certain days:": "Supprimer automatiquement les fichiers qui n'ont pas \u00e9t\u00e9 modifi\u00e9s dans un certain d\u00e9lai :",
    "Avatar": "Avatar",
    "Avatar:": "Avatar :",
    "Back": "Retour",
    "Besides Write permission, user can also share the library.": "Outre l'autorisation d'\u00e9criture, l'utilisateur peut \u00e9galement partager une biblioth\u00e8que.",
    "Branding": "Image de marque",
    "Broken (please contact your administrator to fix this library)": "Endommag\u00e9e (Veuillez contacter un administrateur afin de r\u00e9parer cette biblioth\u00e8que)",
    "Broken ({repo_id_placeholder})": "({repo_id_placeholder}) endommag\u00e9",
    "By expiration ascending": "Par expiration ascendante",
    "By expiration descending": "Par expiration descendante",
    "By name ascending": "Par nom croissant",
    "By name descending": "Par nom d\u00e9croissant",
    "By size ascending": "Par taille croissante",
    "By size descending": "Par taille d\u00e9croissante",
    "By time ascending": "Par date ascendante",
    "By time descending": "Par date descendante",
    "Can not copy directory %(src)s to its subdirectory %(des)s": "Impossible de copier le dossier %(src)s vers son sous-dossier %(des)s",
    "Can not move directory %(src)s to its subdirectory %(des)s": "Impossible de d\u00e9placer le dossier %(src)s vers son sous-dossier %(des)s",
    "Cancel": "Annuler",
    "Cancel All": "Annuler tout",
    "Change": "Changer",
    "Change Password": "Changement de mot de passe",
    "Change Password of Library {placeholder}": "Changement du mot de passe de la biblioth\u00e8que {placeholder}",
    "Changes": "Modifications",
    "Choose date": "Choisir une date",
    "Clean": "Nettoyer",
    "Clean invalid share links": "Supprimer les liens de t\u00e9l\u00e9chargement invalides",
    "Clean invalid upload links": "Supprimer les liens d'envoi invalides",
    "Clean succeeded.": "Le nettoyage a r\u00e9ussi.",
    "Cleaned trash": "Vider la corbeille",
    "Clear": "Effacer",
    "Clear Trash": "Vider la corbeille",
    "Clear files in trash and history\uff1a": "Nettoyer les fichiers dans la corbeille et l'historique :",
    "Clients": "Clients",
    "Close": "Fermer",
    "Column": "Colonne",
    "Community Edition": "\u00c9dition communautaire",
    "Confirm": "Confirmer",
    "Confirm Password": "Confirmer le mot de passe",
    "Connect": "Coonecter",
    "Contact Email": "E-mail de contact",
    "Contact Email:": "E-mail de contact :",
    "Contact Information": "Information de contact",
    "Contact information is required.": "Les informations de contact sont requises.",
    "Content Scan Records": "Enregistrements de contenu",
    "Convert with ONLYOFFICE": "Convertir avec ONLYOFFICE",
    "Copy": "Copier",
    "Copy selected item(s) to:": "Copier les dossiers/fichiers s\u00e9lectionn\u00e9s vers :",
    "Copy {num} items": "Copier {num} \u00e9l\u00e9ments",
    "Copy {placeholder} to": "Copier {placeholder} \u00e0",
    "Copyright Infringement": "Violation du droit d'auteur",
    "Count": " Nombre de vues",
    "Create": "Cr\u00e9er",
    "Create Group": "Cr\u00e9er un groupe",
    "Create Library": "Cr\u00e9er une biblioth\u00e8que",
    "Create Report": "Cr\u00e9er un rapport",
    "Create a draft from this file, instead of editing it directly.": "Cr\u00e9er un brouillon de ce fichier, au lieu de l'\u00e9diter directement.",
    "Create a new tag": "Cr\u00e9er un nouveau Tag",
    "Created": "Cr\u00e9\u00e9",
    "Created At": "Cr\u00e9\u00e9 le",
    "Created Files": "Fichiers cr\u00e9\u00e9s",
    "Created draft": "Brouillon cr\u00e9\u00e9",
    "Created file": "Fichier cr\u00e9\u00e9",
    "Created folder": "Dossier cr\u00e9\u00e9",
    "Created group {group_name}": "Groupe {group_name} cr\u00e9\u00e9",
    "Created library": "Biblioth\u00e8que cr\u00e9\u00e9e",
    "Created library {library_name} with {owner} as its owner": "Biblioth\u00e8que {library_name} cr\u00e9\u00e9e par {owner} en tant que propri\u00e9taire",
    "Created {n} files": "Les {n} sont cr\u00e9\u00e9s",
    "Creator": "Cr\u00e9ateur",
    "Current Connected Devices": "Appareils actuellement connect\u00e9s",
    "Current Library": "Biblioth\u00e8que courante",
    "Current Path: ": "Chemin d'acc\u00e8s actuel : ",
    "Current Version": "Version ",
    "Current path: ": "Chemin d'acc\u00e8s actuel : ",
    "Custom CSS": "CSS modifi\u00e9e",
    "Custom Login URL": "URL de connexion personalis\u00e9",
    "Custom SAML Login URL": "URL de connexion SAML personnalis\u00e9e",
    "Custom file types": "Types de fichiers personnalis\u00e9s",
    "Custom sharing permissions": "Personnaliser des droits de partage",
    "Customer Portal": "Portail Client",
    "Daily Admin": "Administrateur du jour",
    "Database": "Utilisateurs",
    "Date": "Date",
    "Date Invalid.": "Date invalide.",
    "Default": "D\u00e9faut",
    "Default Admin": "Administrateur par d\u00e9faut",
    "Delete": "Supprimer",
    "Delete Account": "Supprimer le compte",
    "Delete Department": "Supprimer le d\u00e9partement",
    "Delete Expired Invitations": "Supprimer les invitations expir\u00e9es",
    "Delete File": "Supprimer le fichier",
    "Delete Folder": "Supprimer le dossier",
    "Delete Group": "Supprimer un groupe",
    "Delete Institution": "Supprimer une institution",
    "Delete Library": "Supprimer une biblioth\u00e8que",
    "Delete Member": "Supprimer le membre",
    "Delete Notification": "Supprimer une notification",
    "Delete Organization": "Supprimer l'organisation",
    "Delete Password": "Supprimer le mot de passe",
    "Delete T&C": "Supprimer T&C",
    "Delete Time": "Date de suppression",
    "Delete User": "Supprimer un utilisateur",
    "Delete Users": "Supprimer des utilisateurs",
    "Delete WebDAV Password": "Supprimer le mot de passe WebDAV",
    "Delete draft": "Supprimer le brouillon",
    "Delete files from this device the next time it comes online.": "Supprimer les fichiers de cet appareil la prochaine fois qu'il est en ligne.",
    "Delete share link": "Supprimer le lien de partage",
    "Delete share links": "Supprimer les liens de partage",
    "Deleted": "Supprim\u00e9",
    "Deleted Libraries": "Biblioth\u00e8ques supprim\u00e9es",
    "Deleted Time": "Date de suppression",
    "Deleted directories": "Dossiers supprim\u00e9s",
    "Deleted draft": "Brouillon supprim\u00e9",
    "Deleted file": "Fichier supprim\u00e9",
    "Deleted files": "Fichiers supprim\u00e9s",
    "Deleted folder": "Dossier supprim\u00e9",
    "Deleted group {group_name}": "Groupe {group_name} supprim\u00e9",
    "Deleted library": "Supprimer une biblioth\u00e8que",
    "Deleted library {library_name}": "Biblioth\u00e8que {library_name} supprim\u00e9e",
    "Deleted user {user}": "Utilisateur {user} supprim\u00e9",
    "Departments": "D\u00e9partements",
    "Description": "Description",
    "Description is required": "La description est requise",
    "Desktop": "Bureau",
    "Details": "D\u00e9tails",
    "Device": "Appareil",
    "Device Name": "Nom de l'appareil",
    "Devices": "Appareils",
    "Direct Download Link:": "Lien de t\u00e9l\u00e9chargement direct :",
    "Direct download link is copied to the clipboard.": "Lien de t\u00e9l\u00e9chargement direct a \u00e9t\u00e9 copi\u00e9 dans le presse-papiers.",
    "Directory": "Dossier",
    "Disable Two-Factor Authentication": "D\u00e9sactiver l'authentification \u00e0 deux facteurs",
    "Disconnect": "D\u00e9connecter",
    "Do not automatically delete files": "Ne pas supprimer les fichiers automatiquement",
    "Document": "Document",
    "Document convertion failed.": "\u00c9chec de conversion du document.",
    "Documents": "Documents",
    "Don't ignore": "Ne pas ignorer",
    "Don't keep history": "Ne pas conserver d'historique",
    "Don't replace": "Ne pas remplacer",
    "Don't send emails": "Ne pas envoyer d'e-mails",
    "Download": "T\u00e9l\u00e9charger",
    "Download an example file": "T\u00e9l\u00e9charger un fichier d'exemple",
    "Download and upload": "T\u00e9l\u00e9chargement et envoi",
    "Draft": "Brouillon",
    "Draft is a way to let you collaborate with others on files. You can create a draft from a file, edit the draft and then ask for a review. The original file will be updated only after the draft has been reviewed.": "Le brouillon vous permet de collaborer avec les autres sur un m\u00eame fichier. Vous pouvez cr\u00e9er un brouillon \u00e0 partir d'un fichier, \u00e9diter le brouillon et ensuite demander un avis. Le fichier original ne sera mis \u00e0 jour que lorsque le brouillon sera comment\u00e9.",
    "Drafts": "Brouillons",
    "Drag and drop files or folders here.": "Glisser-d\u00e9poser des fichiers et dossiers",
    "Edit": "Modifier",
    "Edit File": "\u00c9diter le fichier",
    "Edit extra properties": "Modifier les propri\u00e9t\u00e9s suppl\u00e9mentaires",
    "Edit labels": "\u00c9diter les \u00e9tiquettes",
    "Edit on cloud and download": "\u00c9diter dans le cloud et t\u00e9l\u00e9charger",
    "Edit on cloud only": "\u00c9dition dans le cloud uniquement",
    "Edit permission": "\u00c9diter un droit",
    "Edit succeeded": "L'\u00e9dition a r\u00e9ussi.",
    "Edit succeeded.": "\u00c9dit\u00e9.",
    "Email": "E-mail",
    "Email Notification": "Notification par e-mail",
    "Email is invalid.": "L'adresse e-mail n'est pas valide",
    "Emails": "e-mails",
    "Emails, separated by ','": "E-mails, s\u00e9par\u00e9 par \",\"",
    "Enable Two-Factor Authentication": "Activer l'authentification \u00e0 deux facteurs",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "Acc\u00e9dez \u00e0 l'administration syst\u00e8me pour ajouter des conditions d'utilisation, que tous les utilisateurs devront accepter.",
    "Enable two factor authentication": "Activer l'authentification \u00e0 deux facteurs",
    "Enable users to share libraries to any groups in the system.": "Autoriser les utilisateurs \u00e0 partager des biblioth\u00e8ques avec n'importe quel groupe du syst\u00e8me.",
    "Encrypt": "Chiffrer",
    "Encrypted library": "Biblioth\u00e8que crypt\u00e9e",
    "End date": "Date de fin",
    "Enter characters to start searching": "Taper pour lancer la recherche",
    "Error": "Erreur",
    "Errors": "Erreurs",
    "Exit Institution Admin": "Quitter l'administration de l'Organisation",
    "Exit Organization Admin": "Quitter l'administration de l'Organisation",
    "Exit System Admin": "Quitter l'administration",
    "Expiration": "Expiration",
    "Expiration Date:": "Date d'expiration :",
    "Expiration days": "Jours d'expiration",
    "Expiration time": "D\u00e9lai d'expiration",
    "Expired": "Expir\u00e9",
    "Expired at": "Expire \u00e0 ",
    "Export": "Exporter",
    "Export Excel": "Exporter vers Excel",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "Les extensions des fichiers textes peuvent \u00eatre pr\u00e9visualis\u00e9s en ligne, chaque suffixe est s\u00e9par\u00e9 par une virgule.",
    "Failed": "\u00c9chec",
    "Failed to add {email_placeholder}: {error_msg_placeholder}": "\u00c9chec de l'ajout {email_placeholder} : {error_msg_placeholder}",
    "Failed to copy %(name)s": "\u00c9chec de la copie de %(name)s",
    "Failed to copy %(name)s and %(amount)s other item(s).": "Impossible de copier %(name)s et %(amount)s autre(s) \u00e9l\u00e9ment(s).",
    "Failed to copy %(name)s.": "\u00c9chec de la copie de %(name)s",
    "Failed to copy files to another library.": "Impossible de copier les fichiers vers une autre biblioth\u00e8que.",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "Le fichier %(virus_file) dans la biblioth\u00e8que %(library) n'a pu \u00eatre supprim\u00e9 : %(error_msg)",
    "Failed to delete draft %(draft)s.": "\u00c9chec de la suppression du brouillon %(draft)s.",
    "Failed to delete {name}": "Impossible de supprimer {name} ",
    "Failed to delete {name} and {n} other items.": "\u00c9chec de la suppression de {nom} ainsi que {n} autres \u00e9l\u00e9ments",
    "Failed to delete {name}.": "Impossible de supprimer {name}.",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "Le fichier %(virus_file) dans la biblioth\u00e8que %(library) n'a pas pu \u00eatre supprim\u00e9 : %(error_msg)",
    "Failed to move %(name)s and %(amount)s other item(s).": "Impossible de d\u00e9placer %(name)s et %(amount)s autre(s) \u00e9l\u00e9ment(s).",
    "Failed to move %(name)s.": "\u00c9chec du d\u00e9placement de %(name)s",
    "Failed to move files to another library.": "Impossible de d\u00e9placer les fichiers vers une autre biblioth\u00e8que.",
    "Failed to move {name}.": "\u00c9chec du d\u00e9placement de {name}.",
    "Failed to publish draft %(draft)s.": "\u00c9chec de la publication du brouillon %(draft)s.",
    "Failed to restore {name}": "\u00c9chec de la restauration de {nom}",
    "Failed to restore {name} and {n} other items": "\u00c9chec de la restauration de {nom} ainsi que {n} autres \u00e9l\u00e9ments",
    "Failed to save": "\u00c9chec de la sauvegarde du fichier",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "\u00c9chec de l'envoi \u00e0 {email_placeholder}: {errorMsg_placeholder}",
    "Failed to unshare {name}": "Impossible de supprimer le partage de {name}",
    "Failed to upload {file_name}.": "\u00c9chec de l\u2019envoi du fichier {file_name}. ",
    "Failed. Please check the network.": "\u00c9chec. Veuillez v\u00e9rifier le r\u00e9seau.",
    "Favorites": "Favoris",
    "File": "Fichier",
    "File Access": "Acc\u00e8s fichier",
    "File Operations": "Op\u00e9rations de fichiers",
    "File Scan": "Analyse de fichier",
    "File Types": "Types de ficher",
    "File Update": "Mise \u00e0 jour fichier",
    "File Upload": "Importer un fichier",
    "File Uploading...": "Envoi du fichier en cours ...",
    "File already exists.": "Le fichier existe d\u00e9j\u00e0.",
    "File does not exist.": "Le fichier n'existe pas.",
    "File download is disabled: the share link traffic of owner is used up.": "Le t\u00e9l\u00e9chargement du fichier est d\u00e9sactiv\u00e9 : le trafic du propri\u00e9taire du lien de partage est d\u00e9pass\u00e9.",
    "File extension white list": "Liste blanche des extensions de fichiers",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "Liste blanche d'extensions de fichiers pour le t\u00e9l\u00e9chargement de fichiers via l'interface web et l'API. Par exemple, \"md;txt;docx\". Vide signifie qu'il n'y a pas de limite.",
    "File extensions can only be {placeholder}.": "Les extensions de fichiers ne peuvent \u00eatre {placeholder}.",
    "File is locked by others.": "Le fichier est verrouill\u00e9 par d'autres utilisateurs.",
    "File size is too large.": "Le fichier est trop volumineux.",
    "File size should be smaller than {max_size_placeholder}.": "La taille du fichier doit \u00eatre inf\u00e9rieure \u00e0 {max_size_placeholder}.",
    "File upload started": "L\u2019envoi du fichier \u00e0 d\u00e9marr\u00e9",
    "Files": "Fichiers",
    "Find an option": "Recherche d'une option",
    "Folder": "Dossier",
    "Folder Permission": "Droits sur le dossier",
    "Folder does not exist.": "Le r\u00e9pertoire n\u2019existe pas.",
    "Folder upload is limited to Chrome, Firefox 50+, and Microsoft Edge.": "L'importation de dossiers ne fonctionne qu'avec Chrome, Firefox 50+ et Microsoft Edge.",
    "Folders": "Dossiers",
    "Force user to change password when account is newly added or reset by admin": "Forcer l'utilisateur \u00e0 modifier le mot de passe lorsque le compte a \u00e9t\u00e9 ajout\u00e9 ou r\u00e9initialis\u00e9 par l'administrateur.",
    "Force user to use a strong password when sign up or change password.": "Forcer l'utilisateur \u00e0 utiliser un mot de passe fort lorsqu'il se connecte ou change son mot de passe.",
    "Force user use password when generating share/upload link.": "Forcer l\u2019utilisateur \u00e0 utiliser le lien de g\u00e9n\u00e9ration du mot de passe pour le partage/envoi.",
    "Freeze user account when failed login attempts exceed limit.": "Geler le compte de l'utilisateur lorsque le nombre maximum de connexion \u00e9chou\u00e9es a d\u00e9pass\u00e9 la limite.",
    "Generate": "Cr\u00e9er",
    "Generate Link": "Cr\u00e9er un lien",
    "Generate links in batch": "G\u00e9n\u00e9rer des liens par lots",
    "Generate share link": "Cr\u00e9er un lien de t\u00e9l\u00e9chargement",
    "Global Address Book": "Carnet d'adresses global",
    "Go to Library": "Aller \u00e0 la biblioth\u00e8que",
    "Greater than or equal to {minDays_placeholder} days": "Sup\u00e9rieur ou \u00e9gal \u00e0 {minDays_placeholder} jours",
    "Grid": "Vignettes",
    "Group": "Groupe",
    "Group Permission": "Droits du groupe",
    "Group Shares": "Partages des groupes",
    "Group not found": "Groupe non trouv\u00e9",
    "Groups": "Groupes",
    "Guest": "Invit\u00e9",
    "Handled": "Suspendu",
    "Help": "Aide",
    "Hide": "Cacher",
    "History": "Historique",
    "History Setting": "Param\u00e8tres de l'historique",
    "History Versions": "Historique des versions",
    "IP": "IP",
    "IdP Certificate": "Certificat du fournisseur d'identit\u00e9s",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "Si les notifications ne sont pas lues pendant l'heure qui suit, vous recevrez une notification par e-mail.",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "Si activ\u00e9, les clients locaux ne pourront pas synchroniser un dossier en dehors du dossier Seafile par d\u00e9faut.",
    "If you don't have any device with you, you can access your account using backup codes.": "Si vous n'avez aucun appareil avec vous, vous pouvez acc\u00e9dez \u00e0 votre compte avec les codes de sauvegardes.",
    "Ignore": "Ignorer",
    "Ignored": "Ignor\u00e9",
    "Image": "Image",
    "Images": "Images",
    "Import Members": "Importer des utilisateurs",
    "Import Users": "Importer des utilisateurs",
    "Import members from a .xlsx file": "Importer des membres depuis un fichier .xlsx",
    "Import users": "Importer des utilisateurs",
    "Import users from a .xlsx file": "Importer des utilisateurs depuis un fichier .xlsx",
    "In all libraries": "Dans toutes les biblioth\u00e8ques",
    "Inactive": "Inactif",
    "Indexing...": "Indexation...",
    "Info": "Infos",
    "Input file extensions here, separate with ','": "Introduisez des extensions de fichiers ici, s\u00e9par\u00e9es par ','",
    "Institution": "Institution",
    "Institution Admin": "Administration de l'organisation",
    "Institutions": "Institutions",
    "Internal Link": "Lien interne",
    "Internal Server Error": "Erreur interne du serveur",
    "Internal link has been copied to clipboard": "Le lien interne a \u00e9t\u00e9 copi\u00e9 dans le presse-papiers.",
    "Invalid destination path": "Chemin de destination invalide",
    "Invalid file size range.": "L'intervalle de la taille de fichier n'est pas valide.",
    "Invalid filename.": "Nom de fichier invalide",
    "Invalid month, should be yyyymm.": "Mois incorrecte, cela doit apparaitre comme ceci aaaamm.",
    "Invisible": "Invisible",
    "Invitations": "Invitations",
    "Invite Guest": "Inviter des personnes",
    "Invite Time": "Heure de l'invitation",
    "Invited at": "Invit\u00e9 \u00e0",
    "Inviter": "Inviter",
    "It is required.": "C'est obligatoire",
    "It may take some time, please wait.": "Cela peut prendre un certain temps, veuillez vous patienter.",
    "Keep full history": "Conserver un historique complet",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP (import\u00e9)",
    "Label": "\u00c9tiquette",
    "Label Current State": "\u00c9tiquette \u00e9tat actuel",
    "Labels": "\u00c9tiquettes",
    "Language": "Langue",
    "Language Setting": "Langue",
    "Last Access": "Dernier acc\u00e8s",
    "Last Login": "Derni\u00e8re connexion",
    "Last Update": "Mise \u00e0 jour",
    "Last modification": "Derni\u00e8re modification",
    "Last modified by": "Modifi\u00e9 derni\u00e8rement par",
    "Leave": "Quitter",
    "Leave Group": "Quitter le groupe",
    "Leave Share": "D\u00e9sactiver le partage",
    "Leave this page? The system may not save your changes.": "Quitter la page? Il est possible que le syst\u00e8me n'enregistre pas vos modifications.",
    "Less than or equal to {maxDays_placeholder} days": "Inf\u00e9rieur ou \u00e9gal \u00e0 {maxDays_placeholder} jours",
    "Libraries": "Biblioth\u00e8ques",
    "Library": "Biblioth\u00e8que",
    "Library Type": "Type de biblioth\u00e8que",
    "Library can not be shared to owner.": "La biblioth\u00e8que ne peut pas \u00eatre partag\u00e9e par son propri\u00e9taire",
    "Library share permission not found.": "L'autorisation de partage de la biblioth\u00e8que n'a pas \u00e9t\u00e9 trouv\u00e9e.",
    "Limits": "Limites",
    "Link": "Lien",
    "Link has been copied to clipboard": "Le lien a \u00e9t\u00e9 copi\u00e9 dans le presse-papier",
    "Link:": "Lien : ",
    "Linked Devices": "Appareils li\u00e9s",
    "Links": "Liens",
    "List": "Liste",
    "List your account in global address book, so that others can find you by typing your name.": "Inscrivez votre compte dans le carnet d'adresses global, ainsi les autres pourront vous trouver en saisissant votre nom.",
    "Local draft": "Brouillon local",
    "Local draft saved": "Brouillon local sauvegard\u00e9",
    "Location": "Emplacement",
    "Lock": "Verrouiller",
    "Log out": "Se d\u00e9connecter",
    "Login": "Se connecter",
    "Login Background Image": "Image de fond de connexion",
    "Logs": "Logs",
    "Manage Members": "Gestion des membres",
    "Manage SAML Config": "Modifier la configuration SAML",
    "Manage group members": "Gestion des membres du groupe",
    "Mark all read": "Tout marquer comme lu",
    "Mark as draft": "Marquer comme brouillon",
    "Member": "Membre",
    "Members": "Membres",
    "Message": "Message",
    "Message (optional):": "Message (optionnel) : ",
    "Mobile": "Mobile",
    "Modification Details": "D\u00e9tails de la modification",
    "Modified": "Modifi\u00e9",
    "Modified files": "Fichiers modifi\u00e9s",
    "Modifier": "Modificateur",
    "Modify": "Modifier",
    "Modify includes modify file, move/rename file and folder": "Modifier inclut la modification de fichier, le d\u00e9placement ou renommage de fichier et dossier",
    "Month:": "Mois :",
    "Monthly User Traffic": "Trafic mensuel de l'utilisateur",
    "More": "Plus",
    "More Operations": "Plus d'actions",
    "Move": "D\u00e9placer",
    "Move selected item(s) to:": "D\u00e9placer les dossiers/fichiers s\u00e9lectionn\u00e9s vers :",
    "Move {num} items": "D\u00e9placer {num} \u00e9l\u00e9ments",
    "Move {placeholder} to": "D\u00e9placer {placeholder} vers ",
    "Moved file": "Fichier d\u00e9plac\u00e9",
    "Moved folder": "Dossier d\u00e9plac\u00e9",
    "My Groups": "Mes groupes",
    "My Libraries": "Mes biblioth\u00e8ques",
    "Name": "Nom",
    "Name is required": "Le nom est obligatoire",
    "Name is required.": "Le nom est requis.",
    "Name or ID": "Nom ou ID",
    "Name should not include '/'.": "Le nom ne peut inclure '/'.",
    "Name(optional)": "Nom (optionnel)",
    "Network error": "Erreur r\u00e9seau",
    "New": "Cr\u00e9er",
    "New Department": "Nouveau d\u00e9partement",
    "New Department Library": "Nouvelle librairie d\u00e9partementale",
    "New Draft": "Nouveau brouillon",
    "New Excel File": "Nouveau fichier Excel",
    "New File": "Nouveau fichier",
    "New Folder": "Nouveau dossier",
    "New Group": "Nouveau groupe",
    "New Library": "Nouvelle biblioth\u00e8que",
    "New Markdown File": "Nouveau fichier Markdown",
    "New Password": "Nouveau mot de passe",
    "New Password Again": "Mot de passe \u00e0 nouveau",
    "New PowerPoint File": "Nouveau fichier PowerPoint",
    "New SeaDoc File": "Nouveau dossier SeaDoc",
    "New Sub-department": "Nouveau sous-d\u00e9partement",
    "New Tag": "Nouveau Tag",
    "New Wiki": "Nouveau Wiki",
    "New Word File": "Nouveau fichier Word",
    "New directories": "Nouveaux dossiers",
    "New file name": "Nouveau nom de fichier",
    "New files": "Nouveaux fichiers",
    "New folder name": "Nouveau nom de dossier",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": "Le nouveau mot de passe a \u00e9t\u00e9 envoy\u00e9 sur l'adresse e-mail {mail}. Veuillez v\u00e9rifier votre boite e-mail. Si vous ne recevez pas le nouveau mot de passe, veuillez v\u00e9rifier que votre e-mail est bien configur\u00e9.",
    "New password is too short": "Le nouveau mot de passe est trop court",
    "New passwords don't match": "Les nouveaux mots de passe ne correspondent pas",
    "Next": "Suivant",
    "Next modification": "Modification suivante",
    "No": "Non",
    "No Admin login logs": "Aucun journal de connexion administrateur",
    "No Admin operation logs": "Aucun journal des op\u00e9rations d'administration",
    "No changes": "Pas de changement",
    "No connected devices": "Appareils d\u00e9connect\u00e9s",
    "No deleted libraries": "Aucune biblioth\u00e8que supprim\u00e9e",
    "No departments": "Pas de d\u00e9partement",
    "No draft yet": "Il n'y a pas encore de brouillon",
    "No favorites": "Aucun favori",
    "No file access logs": "Aucun journal d'acc\u00e8s aux fichiers",
    "No file update logs": "Aucun journal de mise \u00e0 jour des fichiers",
    "No folders shared": "Aucun dossier partag\u00e9",
    "No groups": "Aucun groupe",
    "No guest invitations": "Aucune invitation d'invit\u00e9",
    "No invitations": "Aucune invitation",
    "No libraries": "Pas de biblioth\u00e8que",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "Aucune biblioth\u00e8que n'a \u00e9t\u00e9 partag\u00e9e directement avec vous. Une biblioth\u00e8que partag\u00e9e peut \u00eatre partag\u00e9e avec une autorisation compl\u00e8te ou restreinte. Si vous avez besoin d'acc\u00e9der \u00e0 une biblioth\u00e8que appartenant \u00e0 un autre utilisateur, demandez \u00e0 ce dernier de partager la biblioth\u00e8que avec vous.",
    "No libraries have been shared with this group yet. A library shared with a group can be accessed by all group members. You can share a library with a group in \"My Libraries\". You can also create a new library to be shared with this group by clicking the \"New Library\" button in the menu bar.": "Aucune biblioth\u00e8que n'a encore \u00e9t\u00e9 partag\u00e9e avec ce groupe. Une biblioth\u00e8que partag\u00e9e avec un groupe peut \u00eatre accessible \u00e0 tous les membres du groupe. Vous pouvez partager une biblioth\u00e8que avec un groupe dans \"Mes biblioth\u00e8ques\". Vous pouvez \u00e9galement cr\u00e9er une nouvelle biblioth\u00e8que \u00e0 partager avec ce groupe en cliquant sur le bouton \"Nouvelle biblioth\u00e8que\" dans la barre de menu.",
    "No libraries have been shared with you": "Vous n'avez pas acc\u00e8s aux biblioth\u00e8ques des autres utilisateurs.",
    "No libraries have been shared with you from other servers.": "Aucune biblioth\u00e8que n'a \u00e9t\u00e9 partag\u00e9e avec vous d'un autre serveur.",
    "No libraries shared": "Aucune biblioth\u00e8que partag\u00e9e",
    "No libraries shared with this group": "Aucune biblioth\u00e8que n'est partag\u00e9e avec ce groupe",
    "No linked devices": "Aucun appareil li\u00e9",
    "No login logs": "Aucun journal de connexion",
    "No members": "Pas de membre",
    "No notifications": "Aucune notification",
    "No permission logs": "Aucun journal de permission",
    "No preview": "Aucun aper\u00e7u",
    "No public libraries": "Il n'y a pas de biblioth\u00e8ques publiques.",
    "No public libraries have been created yet. A public library is accessible by all users. You can create a public library by clicking the \"Add Library\" button in the menu bar.": "Aucune biblioth\u00e8que publique n'a encore \u00e9t\u00e9 cr\u00e9\u00e9e. Une biblioth\u00e8que publique est accessible \u00e0 tous les utilisateurs. Vous pouvez cr\u00e9er une biblioth\u00e8que publique en cliquant sur le bouton \"Ajouter une biblioth\u00e8que\" dans la barre de menu.",
    "No published libraries": "Aucune biblioth\u00e8que publi\u00e9e",
    "No result": "Aucun r\u00e9sultat",
    "No results matching.": "Aucun r\u00e9sultat correspondant.",
    "No share links": "Aucun lien de t\u00e9l\u00e9chargement",
    "No shared libraries": "Aucune biblioth\u00e8que partag\u00e9e",
    "No sub-departments": "Pas de sous-d\u00e9partement",
    "No sync errors": "Aucune erreur de synchronisation",
    "No terms and conditions": "Aucune condition d'utilisation",
    "No upload links": "Aucun lien d'envoi",
    "No version history": "Pas d'historique de version",
    "None": "Aucun(e)",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "Remarque : Les param\u00e8tres sont sauvegard\u00e9s dans une table de base de donn\u00e9es (seahub-db/constance_config). Elles ont une priorit\u00e9 sup\u00e9rieure aux param\u00e8tres des fichiers de configuration.",
    "Notification": "Notification",
    "Notification Detail": "D\u00e9tail de la notification",
    "Notifications": "Notifications",
    "Notifications of collaboration": "Notification de collaboration",
    "Notifications of file changes": "Notification de modification de fichiers",
    "Number of days that keep user sign in.": "Laisser l'utilisateur connect\u00e9 pendant un nombre de jours.",
    "Number of groups": "Nombre de groupes",
    "Number of links": "Nombre de liens",
    "Off": "D\u00e9sactiv\u00e9",
    "Old Password": "Ancien mot de passe",
    "On": "Activ\u00e9",
    "Online Preview": "Pr\u00e9visualisation en ligne",
    "Online Read-Only": "Lecture seule en ligne",
    "Online Read-Only folder": "Dossier en ligne en Lecture seule",
    "Online Read-Only library": "Biblioth\u00e8que en ligne en Lecture seule",
    "Online Read-Write": "Lecture-\u00c9criture en ligne",
    "Online Read-Write folder": "Dossier en ligne en Lecture-\u00c9criture",
    "Online Read-Write library": "Biblioth\u00e8que en ligne en Lecture-\u00c9criture",
    "Online view is not applicable to this file format": "L'aper\u00e7u en ligne n'est pas disponible pour de type de fichier",
    "Only Show": "Afficher uniquement",
    "Only keep a period of history:": "Ne conserver qu'une p\u00e9riode de l'historique :",
    "Open parent directory": "Ouvrir dossier parent",
    "Open parent folder": "Ouvrir dossier parent",
    "Open via Client": "Ouvrir avec le client",
    "Operation": "Op\u00e9ration",
    "Operation succeeded.": "Action r\u00e9ussie.",
    "Operations": "Actions",
    "Organization": "Organisation",
    "Organization Admin": "Administration de l'organisation",
    "Organizations": "Organisations",
    "Other": "Autre",
    "Other Libraries": "Autres biblioth\u00e8ques",
    "Out of quota.": "Quota d\u00e9pass\u00e9.",
    "Owned Libraries": "Biblioth\u00e8ques personnelles",
    "Owner": "Propri\u00e9taire",
    "Owner can use admin panel in an organization, must be a new account.": "Le propri\u00e9taire peut utiliser le panneau d'administration dans une organisation et doit \u00eatre un nouveau compte.",
    "Packaging...": "Paquetage ...",
    "Password": "Mot de passe",
    "Password again": "Mot de passe (\u00e0 nouveau)",
    "Password is too short": "Le mot de passe est trop court",
    "Password:": "Mot de passe :",
    "Passwords do not match.": "Les mots de passe ne correspondent pas.",
    "Passwords don't match": "Les mots de passe ne correspondent pas",
    "Path": "Chemin",
    "Per 4 hours": "Toutes les 4 heures",
    "Per day": "Tous les jours",
    "Per hour": "Toutes les heures",
    "Per week": "Toutes les semaines",
    "Permission": "Droit",
    "Permission denied": "Autorisation refus\u00e9e",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "Autorisation refus\u00e9e. Veuillez essayer {placeholder-left} de vous connecter \u00e0 nouveau. {placeholder-right}.",
    "Permission name": "Nom du droit",
    "Permission:": "Droits :",
    "Platform": "Plateforme",
    "Please check the network.": "Veuillez v\u00e9rifier le r\u00e9seau.",
    "Please choose a .xlsx file.": "Veuillez choisir un fichier .xlsx",
    "Please choose an image file.": "Veuillez s\u00e9lectionner un fichier image.",
    "Please enter 1 or more character": "Saisir un 1 caract\u00e8re ou plus ",
    "Please enter a new password": "Veuillez entrer un nouveau mot de passe",
    "Please enter a non-negative integer": "Veuillez introduire un int\u00e9grateur non-n\u00e9gatif",
    "Please enter a password.": "Entrez un mot de passe.",
    "Please enter a positive integer": " Entrez un nombre entier positif.",
    "Please enter an integer bigger than 1 as number of links.": "Entrez un nombre entier sup\u00e9rieur \u00e0 0.",
    "Please enter an integer not bigger than {max_number} as number of links.": "Veuillez saisir un nombre entier inf\u00e9rieur ou \u00e9gal \u00e0 {nombre_max} comme nombre de liens.",
    "Please enter days": "Veuillez entrer un nombre de jours",
    "Please enter password": "Entrez un mot de passe",
    "Please enter the new password again": "Veuillez entrer le nouveau mot de passe encore une fois",
    "Please enter the old password": "Veuillez entrer l'ancien mot de passe",
    "Please enter the password again": "Entrez \u00e0 nouveau un mot de passe",
    "Please input at least an email.": "Saisissez au moins une adresse e-mail.",
    "Please select a library to share.": "Veuillez s\u00e9lectionner la biblioth\u00e8que \u00e0 partager.",
    "Please select an expiration time": "Veuillez s\u00e9lectionner une date d'expiration",
    "Please upload files less than {placeholder}": "Veuillez t\u00e9l\u00e9charger des fichiers dont la taille est inf\u00e9rieure \u00e0 {placeholder}",
    "Please upload files less than {placeholder}M": "Veuillez envoyer des fichiers de moins de {placeholder}M",
    "Please upload no more than {maxFiles} files at a time.": "Veuillez ne pas envoyer plus de {maxFiles} fichiers \u00e0 la fois.",
    "Preparing to upload...": "Pr\u00e9paration de l'envoi..",
    "Preview and download": "Pr\u00e9visualiser et t\u00e9l\u00e9charger",
    "Preview online": "Pr\u00e9visualisation en ligne",
    "Preview only": "Aper\u00e7u uniquement",
    "Previous": "Pr\u00e9c\u00e9dent",
    "Print": "Imprimer",
    "Professional Edition": "\u00c9dition professionnelle",
    "Profile": "Profil",
    "Profile Setting": "Profil",
    "Properties": "Propri\u00e9t\u00e9s",
    "Publish": "Publier",
    "Publish a Library": "Publier une biblioth\u00e8que",
    "Publish draft": "Publier brouillon",
    "Published Libraries": "Biblioth\u00e8ques publi\u00e9es",
    "Quota": "Quota",
    "Quota is invalid.": "Le quota n'est pas valide.",
    "Read-Only": "Lecture seulement",
    "Read-Only folder": "Dossier en Lecture-Seulement",
    "Read-Only library": "Biblioth\u00e8que en lecture seule",
    "Read-Write": "Lecture - \u00c9criture",
    "Read-Write folder": "Dossier en Lecture-\u00c9criture",
    "Read-Write library": "Biblioth\u00e8que en lecture / \u00e9criture",
    "Really want to delete this group?": "Voulez-vous vraiment supprimer ce groupe ?",
    "Really want to delete your account?": "Voulez-vous vraiment supprimer ce compte ?",
    "Really want to leave this group?": "Voulez-vous vraiment quitter ce groupe ?",
    "Refresh": "Rafraichir",
    "Remaining": "Restant",
    "Remove": "Supprimer",
    "Remove Member": "Retirer un membre",
    "Removed all items from trash.": "Supprimer tous les \u00e9l\u00e9ments de la corbeille.",
    "Removed items older than {n} days from trash.": "Supprimer les \u00e9l\u00e9ments datant de plus {n} jours.",
    "Rename": "Renommer",
    "Rename Department": "Renommer un d\u00e9partement",
    "Rename File": "Renommer le fichier",
    "Rename Folder": "Renommer le dossier",
    "Rename Group": "Renommer le groupe",
    "Rename group to": "Renommer le groupe en ",
    "Renamed file": "Fichier renomm\u00e9",
    "Renamed folder": "Dossier renomm\u00e9",
    "Renamed library": "Biblioth\u00e8que renomm\u00e9e",
    "Renamed or Moved files": "Fichiers renomm\u00e9s ou d\u00e9plac\u00e9s",
    "Renaming {name} failed": "Impossible de renommer {name}",
    "Replace": "Remplacer",
    "Replace file {filename}?": "Remplacer le fichier {filename} ?",
    "Replacing it will overwrite its content.": "Choisir \"Remplacer\" \u00e9crase le fichier existant.",
    "Report Abuse": "Signaler un abus",
    "Reporter": "Auteur du rapport",
    "Reports": "Rapports",
    "Request a review": "Demander un avis",
    "Required at least three letters.": "Trois lettres requises au minimum.",
    "Reset": "R\u00e9initialiser",
    "Reset Password": "R\u00e9initialiser du mot de passe",
    "Reset WebDAV Password": "R\u00e9initialiser le mot de passe WebDAV",
    "Reset library password": "R\u00e9initialiser le mot de passe de la biblioth\u00e8que",
    "ResetPwd": "R\u00e9initialisation mot de passe",
    "Resetting user's password, please wait for a moment.": "R\u00e9initialisation du mot de passe de l'utilisateur, veuillez patienter un instant.",
    "Restore": "Restaurer",
    "Restore Library": "Restaurer une biblioth\u00e8que",
    "Restored file": "Fichier restaur\u00e9",
    "Restored folder": "Dossier restaur\u00e9",
    "Restored library": "Biblioth\u00e8que restaur\u00e9e",
    "Restored {name}": "{name} a \u00e9t\u00e9 restaur\u00e9",
    "Restored {name} and {n} other items": "{nom} a \u00e9t\u00e9 restaur\u00e9 ainsi que {n} autres \u00e9l\u00e9ments",
    "Result": "R\u00e9sultat",
    "Retry": "R\u00e9essayer",
    "Retry All": "R\u00e9essayer tout",
    "Revoke": "R\u00e9voquer",
    "Revoke Access": "Acc\u00e8s r\u00e9voqu\u00e9",
    "Revoke Admin": "R\u00e9voquer un administrateur",
    "Role": "R\u00f4le",
    "SAML config": "Configuration SAML",
    "Save": "Sauvegarder",
    "Save Selected Items": "Enregistrer la s\u00e9lection",
    "Save as ...": "Enregistrer sous ...",
    "Save to:": "Enregistrer sous :",
    "Saving...": "Sauvegarde ...",
    "Scan the QR code to view the shared content directly": "Scanner le code QR pour pour afficher directement le contenu partag\u00e9",
    "Seafile": "Seafile",
    "Search": "Chercher",
    "Search Groups": "Cherche groupes",
    "Search Libraries": "Rechercher des biblioth\u00e8ques",
    "Search Organizations": "Rechercher des organisations",
    "Search Users": "Rechercher des utilisateurs",
    "Search files in this library": "Recherche de fichiers dans cette biblioth\u00e8que",
    "Search group members": "Rechercher des membres du groupe",
    "Search groups": "Recherche de groupes",
    "Search groups by name": "Cherche de groupes par nom",
    "Search libraries by name or ID": "Recherche de biblioth\u00e8ques par nom ou par identifiant",
    "Search libraries by owner": "Recherche de biblioth\u00e8ques par propri\u00e9taire",
    "Search organizations": "Rechercher des organisations",
    "Search users": "Cherche d'utilisateurs par nom",
    "Select File": "S\u00e9lectionner un fichier",
    "Select Image": "S\u00e9lectionner l'image",
    "Select Tags": "S\u00e9lectionner des Tags",
    "Select a color": "S\u00e9lectionner une couleur",
    "Select a department": "S\u00e9lectionner un d\u00e9partement",
    "Select a group": "S\u00e9lectionner un groupe",
    "Select a user": "S\u00e9lectionner un utilisateur",
    "Select groups": "S\u00e9lectionner des groupes",
    "Select libraries to share": "S\u00e9lectionnez la biblioth\u00e8que \u00e0 partager",
    "Send": "Envoyer",
    "Send activation Email after user registration.": "Envoyer l'e-mail d'activation apr\u00e8s l'inscription de l'utilisateur.",
    "Send to:": "Envoyer \u00e0 :",
    "Sending new password...": "Envoi du nouveau mot de passe..",
    "Sending...": "Envoi ...",
    "Server": "Serveur",
    "Server Version: ": "Version du serveur : ",
    "Set Admin": "D\u00e9finir un administrateur",
    "Set Contact Email": "D\u00e9finir l'e-mail de contact",
    "Set Download Rate Limit": "D\u00e9finir le rate limiting t\u00e9l\u00e9chargement",
    "Set Login ID": "D\u00e9finir un identifiant de connexion",
    "Set Name": "D\u00e9finir un nom",
    "Set Password": "D\u00e9finir un mot de passe",
    "Set Quota": "D\u00e9finir le quota",
    "Set Reference ID": "D\u00e9finir l'identifiant de r\u00e9f\u00e9rence",
    "Set Upload Rate Limit": "D\u00e9finir le rate limiting envoi",
    "Set WebDAV Password": "D\u00e9finir le mot de passe WebDAV",
    "Set max number of members": "D\u00e9finir le nombre maximum de membres",
    "Set permission": "D\u00e9finir la permission",
    "Set to current": "Activer",
    "Set user contact email": "D\u00e9finir l'e-mail de contact de l'utilisateur",
    "Set user name": "D\u00e9finir un nom d'utilisateur",
    "Set user quota": "D\u00e9finir le quota de l'utilisateur",
    "Set {placeholder}'s permission": "Attribuer des droits \u00e0 {placeholder}'s",
    "Setting library history is disabled by Admin.": "Le param\u00e8tre d'historique de la biblioth\u00e8que a \u00e9t\u00e9 d\u00e9sactiv\u00e9 par l'administrateur",
    "Settings": "Param\u00e8tres",
    "Share": "Partager",
    "Share Admin": "Mes partages et liens",
    "Share From": "Partag\u00e9 par",
    "Share Link": "Lien de t\u00e9l\u00e9chargement",
    "Share Link Traffic": "Partager le Trafic de lien",
    "Share Links": "Liens de t\u00e9l\u00e9chargement",
    "Share To": "Partag\u00e9e avec",
    "Share To:": "Partag\u00e9e avec :",
    "Share existing libraries": "Partagez une biblioth\u00e8que existante",
    "Share link download": "Lien de t\u00e9l\u00e9chargement partag\u00e9",
    "Share link is copied to the clipboard.": "Le lien de t\u00e9l\u00e9chargement a \u00e9t\u00e9 copi\u00e9 dans le presse-papiers.",
    "Share link upload": "Lien d'envoi partag\u00e9",
    "Share to group": "Partage avec un groupe",
    "Share to other server": "Partage avec un autre serveur",
    "Share to user": "Partage avec un utilisateur",
    "Shared By": "Partag\u00e9 par",
    "Shared Libraries": "Biblioth\u00e8ques partag\u00e9es",
    "Shared Links": "Liens partag\u00e9s",
    "Shared by:": "Partag\u00e9 par : ",
    "Shared by: ": "Partag\u00e9 par : ",
    "Shared from other servers": "Partag\u00e9 d'autres serveurs",
    "Shared with all": "Partag\u00e9 avec tout le monde",
    "Shared with groups": "Partag\u00e9 avec des groupes",
    "Shared with me": "Partag\u00e9 avec moi",
    "Show": "Afficher",
    "Show Codes": "Afficher les codes",
    "Show changes": "Afficher les modifications",
    "Side Nav Menu": "Menu de navigation sur le c\u00f4t\u00e9",
    "Site name used in email sending": "Le nom du site utilis\u00e9 dans l'envoi d'e-mails",
    "Site title shown in a browser tab": "D\u00e9finir un titre visible dans l'onglet du navigateur",
    "Size": "Taille",
    "Social Login": "Connexion r\u00e9seau social",
    "Space Used": "Espace utilis\u00e9",
    "Space Used / Quota": "Espace utilis\u00e9 / Quota",
    "Star": "Favoris",
    "Start date": "Date de d\u00e9but",
    "Statistic": "Statistiques",
    "Status": "Statut",
    "Status: enabled": "Status : activ\u00e9",
    "Storage": "Stockage",
    "Storage Backend": "Syst\u00e8me de stockage",
    "Storage Used": "Espace utilis\u00e9",
    "Sub-departments": "Sous-d\u00e9partement",
    "Submit": "Soumettre",
    "Success": "Succ\u00e8s",
    "Successfully added label(s) for library {placeholder}": "Le(s) \u00e9tiquettes(s) de la biblioth\u00e8que {placeholder} ont \u00e9t\u00e9 ajout\u00e9s.",
    "Successfully added {email_placeholder}": "{email_placeholder} a \u00e9t\u00e9 ajout\u00e9.",
    "Successfully changed library password.": "Le mot de passe de la biblioth\u00e8que a \u00e9t\u00e9 modifi\u00e9.",
    "Successfully cleaned all errors.": "Toutes les erreurs ont \u00e9t\u00e9 effac\u00e9es avec succ\u00e8s.",
    "Successfully cleaned invalid share links.": "Tous les liens de t\u00e9l\u00e9chargement invalides ont \u00e9t\u00e9 supprim\u00e9s.",
    "Successfully cleaned invalid upload links.": "Tous les liens d'envoi invalides ont \u00e9t\u00e9 supprim\u00e9s.",
    "Successfully cleared trash.": "La corbeille a \u00e9t\u00e9 vid\u00e9e avec succ\u00e8s.",
    "Successfully copied %(name)s and %(amount)s other items.": "%(name)s et %(amount)s autres \u00e9l\u00e9ments ont \u00e9t\u00e9 copi\u00e9s.",
    "Successfully copied %(name)s and 1 other item.": "%(name)s et un autre \u00e9l\u00e9ment ont \u00e9t\u00e9 copi\u00e9s.",
    "Successfully copied %(name)s.": "%(name)s a \u00e9t\u00e9 copi\u00e9.",
    "Successfully copied files to another library.": "Fichiers copi\u00e9s vers une autre biblioth\u00e8que avec succ\u00e8s.",
    "Successfully deleted 1 item": "1 objet supprim\u00e9 avec succ\u00e8s",
    "Successfully deleted 1 item.": "Un objet a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully deleted 1 share link": "1 lien de partage a \u00e9t\u00e9 supprim\u00e9 avec succ\u00e8s.",
    "Successfully deleted 1 user.": "1 utilisateur a \u00e9t\u00e9 supprim\u00e9 avec succ\u00e8s.",
    "Successfully deleted draft %(draft)s.": "Le brouillon %(draft)s a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully deleted {name}": "{name} a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully deleted {name} and {n} other items.": "Suppression r\u00e9ussie de {nom} ainsi que {n} autres \u00e9l\u00e9ments.",
    "Successfully deleted {name}.": "{name} a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully deleted {number_placeholder} share links": "{number_placeholder} liens de partage ont \u00e9t\u00e9 supprim\u00e9s avec succ\u00e8s.",
    "Successfully deleted {user_number_placeholder} users.": " {user_number_placeholder} utilisateurs ont \u00e9t\u00e9 supprim\u00e9 avec succ\u00e8s.",
    "Successfully edited labels.": "Les \u00e9tiquettes ont \u00e9t\u00e9 \u00e9dit\u00e9es.",
    "Successfully invited %(email) and %(num) other people.": "%(email) et %(num) ont \u00e9t\u00e9 invit\u00e9.",
    "Successfully invited %(email).": "%(email) a \u00e9t\u00e9 invit\u00e9.",
    "Successfully modified permission.": "Permission modifi\u00e9e.",
    "Successfully moved %(name)s and %(amount)s other items.": "%(name)s et %(amount)s autres \u00e9l\u00e9ments ont \u00e9t\u00e9 d\u00e9plac\u00e9s.",
    "Successfully moved %(name)s and 1 other item.": " %(name)s et un autre \u00e9l\u00e9ment ont \u00e9t\u00e9 d\u00e9plac\u00e9s.",
    "Successfully moved %(name)s.": " %(name)s ont \u00e9t\u00e9 d\u00e9plac\u00e9.",
    "Successfully moved files to another library.": "Fichiers d\u00e9plac\u00e9s vers une autre biblioth\u00e8que avec succ\u00e8s.",
    "Successfully moved {name}.": " {name} a \u00e9t\u00e9 d\u00e9plac\u00e9.",
    "Successfully published draft %(draft)s.": "Le brouillon %(draft)s a \u00e9t\u00e9 publi\u00e9.",
    "Successfully removed {placeholder}.": "Le membre {placeholder} a \u00e9t\u00e9 retir\u00e9.",
    "Successfully reset password to %(passwd)s for user %(user)s.": "Mot de passe de l'utilisateur %(user)s a \u00e9t\u00e9 remplac\u00e9 par %(passwd)s.",
    "Successfully restored 1 item.": "Un objet a \u00e9t\u00e9 restaur\u00e9.",
    "Successfully restored the library.": "La biblioth\u00e8que a \u00e9t\u00e9 restaur\u00e9e.",
    "Successfully restored.": "Restaur\u00e9.",
    "Successfully revoke the admin permission of %s": "Permissions administrateur de %s supprim\u00e9es.",
    "Successfully revoked access of user {placeholder}.": "L'acc\u00e8s de l'utilisateur {placeholder} a \u00e9t\u00e9 r\u00e9voqu\u00e9.",
    "Successfully revoked the admin permission of {placeholder}.": "Les droits de l\u2019administration de {placeholder} ont \u00e9t\u00e9 r\u00e9voqu\u00e9s.",
    "Successfully saved": "Sauvegard\u00e9",
    "Successfully sent to {placeholder}": "Envoy\u00e9 \u00e0 {placeholder}",
    "Successfully set %s as admin.": "%s d\u00e9fini en tant qu'administrateur.",
    "Successfully set it.": "La modification a \u00e9t\u00e9 enregistr\u00e9e.",
    "Successfully set library history.": "La mise \u00e0 jour de l'historique de la biblioth\u00e8que a \u00e9t\u00e9 ex\u00e9cut\u00e9e.",
    "Successfully starred {library_name_placeholder}.": "{library_name_placeholder} a \u00e9t\u00e9 ajout\u00e9e aux favoris.",
    "Successfully transferred the group.": "Le groupe a \u00e9t\u00e9 transf\u00e9r\u00e9.",
    "Successfully transferred the library.": "La biblioth\u00e8que a \u00e9t\u00e9 transf\u00e9r\u00e9e.",
    "Successfully unlinked %(name)s.": "%(name)s a \u00e9t\u00e9 d\u00e9li\u00e9 avec succ\u00e8s.",
    "Successfully unlinked the device.": "L'appareil a \u00e9t\u00e9 d\u00e9li\u00e9 avec succ\u00e8s.",
    "Successfully unshared library {placeholder}": "Le partage de {placeholder} a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully unshared {name}": "Le partage de {name} a \u00e9t\u00e9 supprim\u00e9.",
    "Successfully unstarred {library_name_placeholder}.": "{library_name_placeholder} a \u00e9t\u00e9 supprim\u00e9e des favoris.",
    "Suggestion": "Suggestion",
    "Switch to plain text editor": "Basculer en \u00e9diteur de texte plein",
    "Switch to rich text editor": "Basculer en \u00e9diteur de texte enrichi",
    "Sync": "Synchroniser",
    "Sync Download": "T\u00e9l\u00e9chargement synchronis\u00e9",
    "Sync Traffic": "Synchroniser le Trafic",
    "Sync Upload": "Envoi synchronis\u00e9",
    "System": "Syst\u00e8me",
    "System Admin": "Administration syst\u00e8me",
    "System Info": "Informations syst\u00e8me",
    "Tag \"{name}\" already exists.": "Le tag \"{name}\" existe d\u00e9j\u00e0.",
    "Tagged Files": "Fichiers tagu\u00e9s",
    "Tags": "Tags",
    "Team name": "Nom de l'\u00e9quipe",
    "Template": "Th\u00e8me",
    "Terms": "Conditions",
    "Terms and Conditions": "Conditions d'utilisation",
    "Text": "Texte",
    "Text files": "Fichiers texte",
    "Text is required.": "Texte requis",
    "The URL of the server, like https://seafile.example.com or http://192.168.1.2:8000": "L'adresse du serveur, comme https://seafile.example.com ou http://192.168.1.2:8000",
    "The custom part of the URL should be 6 to 20 characters, and can only contain alphanumeric characters and hyphens.": "La partie de l'URL personalis\u00e9 doit comprendre de 6 \u00e0 20 caract\u00e8res et ne peut contenir que des caract\u00e8res alphanum\u00e9riques et des traits d'union.",
    "The file is too large. Allowed maximum size is 1MB.": "Le fichier est trop volumineux. La taille maximum autoris\u00e9e est de 1 Mo.",
    "The internal URL for downloading/uploading files. Users will not be able to download/upload files if this is not set correctly. If you config Seafile behind Nginx/Apache, it should be SERVICE_URL/seafhttp, like https://seafile.example.com/seafhttp .": "Une adresse interne de t\u00e9l\u00e9chargement/envoi de fichiers. Les utilisateurs ne sont pas autoris\u00e9s \u00e0 t\u00e9l\u00e9charger/envoyer des fichiers si ce n'est pas correctement configur\u00e9. Si vous configurez Seafile derri\u00e8re Nginx/Apache, l'adresse devrait \u00eatre SERVICE_URL/seafhttp, comme https://seafile.example.com/seafhttp .",
    "The least number of characters a share/upload link password should include.": "Le nombre minimum de caract\u00e8res que devrait comporter le mot de passe d'un lien de partage/t\u00e9l\u00e9chargement.",
    "The least number of characters an account password should include.": "Le nombre minimum de caract\u00e8res qu'un mot de passe de compte devrait inclure.",
    "The least number of characters an encrypted library password should include.": "Le nombre minimum de caract\u00e8res qu'un mot de passe de biblioth\u00e8que crypt\u00e9e devrait inclure.",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "Le niveau (1-4) de la force du mot de passe d'un lien de partage/t\u00e9l\u00e9chargement. Par exemple, '3' signifie que le mot de passe doit comporter au moins 3 des \u00e9l\u00e9ments suivants : chiffres, lettres majuscules, lettres minuscules et autres symboles.",
    "The level(1-4) of an account password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "Le niveau (1-4) de la force du mot de passe d'un compte. Par exemple, \u00ab3\u00bb signifie que le mot de passe doit comporter au moins 3 des \u00e9l\u00e9ments suivants : chiffre, lettre majuscule, lettre minuscule et autres symboles",
    "The link is copied to the clipboard.": "Le lien a \u00e9t\u00e9 copi\u00e9 dans le presse-papiers.",
    "The list of added, deleted and modified files will be sent to your mailbox.": "La liste des fichiers ajout\u00e9s, supprim\u00e9s et modifi\u00e9s seront envoy\u00e9s dans votre boite e-mail.",
    "The maximum number of failed login attempts before showing CAPTCHA.": "Le nombre maximum de tentatives de connexion \u00e9chou\u00e9es avant que le CAPTCHA n'apparaisse.",
    "The name \"{name}\" is already taken. Please choose a different name.": "Le nom \"{name}\" est d\u00e9j\u00e0 pris.",
    "The owner of this library has run out of space.": "Le propri\u00e9taire de cette biblioth\u00e8que n'a plus assez d'espace libre..",
    "The password is too short.": "Le mot de passe est trop court.",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": "Le mot de passe est trop faible. Il doit contenir au minimum {passwordStrengthLevel} exemplaires des caract\u00e8res suivant: nombres, majuscules, minuscules et caract\u00e8res sp\u00e9ciaux.",
    "The password will be kept in the server for only 1 hour.": "Le mot de passe est conserv\u00e9 sur le serveur pendant 1 heure.",
    "This file has been updated.": "Ce fichier \u00e0 bien \u00e9t\u00e9 mis \u00e0 jour.",
    "This file is in draft stage.": "Ce fichier est \u00e0 l'\u00e9tat de brouillon",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": "Ce dossier a \u00e9t\u00e9 partag\u00e9 avec le(s) utilisateur(s) {user_amount} et le(s) groupe(s) {group_amount}.",
    "This folder has no content at this time.": "Le r\u00e9pertoire ne poss\u00e8de aucun contenu actuellement.",
    "This is a special group representing a department.": "Groupe sp\u00e9cial repr\u00e9sentant le d\u00e9partement",
    "This library has been set to read-only by admin and cannot be updated.": "La biblioth\u00e8que est param\u00e9tr\u00e9e par l\u2019administrateur en lecture seule et en peut pas \u00eatre modifi\u00e9e.",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": "Cette librairie a \u00e9t\u00e9 partag\u00e9 avec {user_amount} utilisateur(s) et {group_amount} groupe(s).",
    "This library is password protected": "Cette biblioth\u00e8que est prot\u00e9g\u00e9e par un mot de passe",
    "This operation will not be reverted. Please think twice!": "Cette action est irr\u00e9versible. Veuillez y r\u00e9fl\u00e9chir \u00e0 deux fois !",
    "Thumbnail": "Miniatures",
    "Time": "Heure",
    "Tip: -2 means no limit.": "Astuce : -2 signifie illimit\u00e9.",
    "Tip: 0 means default limit": "Astuce : 0 signifie aucune limite par d\u00e9faut",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Astuce : un instantan\u00e9 sera g\u00e9n\u00e9r\u00e9 apr\u00e8s chaque modification, qui enregistrera l'\u00e9tat de la biblioth\u00e8que apr\u00e8s la modification.",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "Conseil : les biblioth\u00e8ques supprim\u00e9es {placeholder} il y a quelques jours seront automatiquement nettoy\u00e9es.",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "Astuce : Les biblioth\u00e8ques supprim\u00e9es sont automatiquement \u00e9limin\u00e9es du syst\u00e8me {trashReposExpireDays} jours apr\u00e8s la suppression.",
    "Tip: you can search by keyword in name or ID.": "Astuce : vous pouvez effectuer une recherche par mot cl\u00e9 dans le nom ou l'ID.",
    "Tip: you can search by keyword in name.": "Astuce : vous pouvez faire une recherche par mot-cl\u00e9 dans le nom.",
    "Token": "Token",
    "Token:": "Jeton :",
    "Tools": "Outils",
    "Total Devices": "Total d'appareils",
    "Total Storage": "Stockage total",
    "Total Traffic": "Trafic total",
    "Total Users": "Utilisateurs totaux",
    "Traffic": "Trafic",
    "Transfer": "Transf\u00e9rer ",
    "Transfer Group": "Transf\u00e9rer un groupe",
    "Transfer Group {placeholder} to": "Transf\u00e9rer le groupe",
    "Transfer Library": "Transf\u00e9rer une biblioth\u00e8que",
    "Transfer Library {library_name}": "Transf\u00e9rer la biblioth\u00e8que {library_name} ",
    "Transfer group to": "Transf\u00e9rer le groupe \u00e0",
    "Transfer to department": "Transf\u00e9rer au d\u00e9partement ",
    "Transfer to user": "Transf\u00e9rer \u00e0 l'utilisateur ",
    "Transferred group {group_name} from {user_from} to {user_to}": "Le groupe {group_name} a \u00e9t\u00e9 transf\u00e9r\u00e9 de {user_from} \u00e0 {user_to}.",
    "Transferred library {library_name} from {user_from} to {user_to}": "La biblioth\u00e8que {library_name} a \u00e9t\u00e9 transf\u00e9r\u00e9e de {user_from} \u00e0 {user_to}.",
    "Trash": "Corbeille",
    "Two-Factor Authentication": "Authentification \u00e0 deux facteurs",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "La cl\u00e9 d'authentification \u00e0 deux facteurs n'est pas activ\u00e9e sur votre compte. Activez la cl\u00e9 d'authentification \u00e0 deux facteurs afin d'am\u00e9liorer la s\u00e9curit\u00e9 de votre compte.",
    "Type": "Type",
    "Undo": "Annuler",
    "Unhandled": "Non g\u00e9r\u00e9",
    "Unknown": "Inconnu",
    "Unlink": "Supprimer",
    "Unlink device": "Supprimer le lien vers l'appareil",
    "Unlock": "D\u00e9verrouiller",
    "Unmark as draft": "D\u00e9cocher en tant que brouillon",
    "Unpublish": "Annuler la publication",
    "Unpublish Library": "Biblioth\u00e8que non publi\u00e9e",
    "Unshare": "Annuler le partage",
    "Unshare Library": "Biblioth\u00e8que non partag\u00e9e",
    "Unstar": "Supprimer",
    "Unwatch File Changes": "Ne pas observer les changements de fichiers",
    "Update": "Mettre \u00e0 jour",
    "Update Terms and Conditions": "Mettre \u00e0 jour les conditions d'utilisation",
    "Update succeeded.": "Mis \u00e0 jour avec succ\u00e8s.",
    "Updated draft": "Brouillon mis \u00e0 jour",
    "Updated file": "Fichier mis \u00e0 jour",
    "Upgrade to Pro Edition": "Passer \u00e0  l'\u00e9dition professionnelle",
    "Upload": "Importer",
    "Upload Files": "Importer des fichiers",
    "Upload Folder": "Importer un dossier",
    "Upload IdP Files": "Importer des fichiers fournisseur d'identit\u00e9s",
    "Upload Link": "Lien d'envoi",
    "Upload Link:": "Lien d'envoi :",
    "Upload Links": "Liens d'envoi",
    "Upload Rate Limit": "Rate limiting envoi",
    "Upload file": "Importer le fichier",
    "Upload files to {folder_name_placeholder}": "Importer les fichiers \u00e0 {folder_name_placeholder}",
    "Upload license": "Importer la license",
    "Upload link is copied to the clipboard.": "Le lien d'envoi a \u00e9t\u00e9 copi\u00e9 dans le presse-papiers.",
    "Uploaded": "Envoy\u00e9",
    "Use custom CSS": "Utiliser une CSS modifi\u00e9e",
    "Use draft": "Utiliser le brouillon",
    "Used:": "Utilis\u00e9 :",
    "User": "Utilisateur",
    "User Email": "E-mail d'utilisateur",
    "User Permission": "Droits de l'utilisateur",
    "User Shares": "Partages des utilisateurs",
    "User Storage": "Stockage de l'utilisateur",
    "User can not see this folder.": "L'utilisateur ne peut pas voir ce dossier.",
    "User can only view files online via browser. Files can't be downloaded.": "L'utilisateur peut uniquement afficher les fichiers en ligne via un navigateur. Les fichiers ne peuvent pas \u00eatre t\u00e9l\u00e9charg\u00e9s.",
    "User can read, download and sync files.": "Vous pouvez lire, t\u00e9l\u00e9charger et synchroniser des fichiers.",
    "User can read, write, upload, download and sync files.": "L'utilisateur peut lire, \u00e9crire, envoyer, t\u00e9l\u00e9charger et synchroniser des fichiers.",
    "User can view and edit file online via browser. Files can't be downloaded.": "L'utilisateur peut voir et \u00e9diter un fichier en ligne via un navigateur. Les fichiers ne peuvent pas \u00eatre t\u00e9l\u00e9charg\u00e9s.",
    "User not found": "Utilisateur introuvable",
    "User {user_link} has added you to {group_link}": "L'utilisateur {user_link} vous a ajout\u00e9 \u00e0 {group_link}",
    "Username:": "Nom d'utilisateur :",
    "Users": "Utilisateurs",
    "Verify": "V\u00e9rifi\u00e9",
    "Version": "Version",
    "Version Number": "Num\u00e9ro de version",
    "Version Number is required.": "Le num\u00e9ro de version est requis.",
    "Version Number must be a number.": "Le num\u00e9ro de version doit \u00eatre un nombre.",
    "Video": "Vid\u00e9o",
    "View": "Afficher",
    "View Draft": "Voir le brouillon",
    "View Link": "Voir le lien",
    "View Related Snapshot": "Voir l'instantan\u00e9 associ\u00e9",
    "View Snapshot": "Voir l'instantan\u00e9",
    "View profile and more": "Voir le profil et plus",
    "Virus": "Virus",
    "Virus File": "Fichier infect\u00e9",
    "Virus Scan": "Recherche de virus",
    "Visited": "Visit\u00e9",
    "Visits": "Visites",
    "Watch File Changes": "Observer les changements de fichiers",
    "Web API Auth Token": "Web API Auth Token",
    "Web Download": "T\u00e9l\u00e9chargement Web",
    "Web Traffic": "Trafic Web",
    "Web Upload": "Envoi Web",
    "WebDAV Password": "Mot de passe WebDAV",
    "WebDAV password:": "Mot de passe WebDAV:",
    "WebDAV username:": "Nom d'utilisateur WebDAV:",
    "WebDav Password": "Mot de passe WebDav ",
    "Welcome to {site_name_placeholder}": "Bienvenue sur {site_name_placeholder}",
    "Whether the notifications of collaboration such as sharing library or joining group should be sent to your mailbox.": "Voulez-vous recevoir des notifications de collaboration (par ex. partage de biblioth\u00e8que, admission d'un groupe) par e-mail ?",
    "Wrong password": "Le mot de passe est erron\u00e9",
    "Yes": "Oui",
    "You are not in any groups. Groups allow multiple people to collaborate on libraries. Groups you join will be listed here.": "Vous ne faites partie d'aucun groupe. Les groupes permettent \u00e0 plusieurs personnes de collaborer dans les biblioth\u00e8ques. Les groupes auxquels vous participez seront r\u00e9pertori\u00e9s ici.",
    "You are not in any groups. Groups allow multiple people to collaborate on libraries. You can create a group by clicking the \"New Group\" button in the menu bar.": "Vous ne faites partie d'aucun groupe. Les groupes permettent \u00e0 plusieurs personnes de collaborer dans les biblioth\u00e8ques. Vous pouvez cr\u00e9er un groupe en cliquant sur le bouton \"Nouveau groupe\" dans la barre de menu.",
    "You are watching file changes of this library.": "Vous observez les changements de fichiers de cette biblioth\u00e8que.",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "Vous pouvez aussi ajouter un utilisateur comme invit\u00e9, qui ne sera pas autoris\u00e9 \u00e0 cr\u00e9er des biblioth\u00e8ques et des groupes.",
    "You can create files quickly": "Vous pouvez cr\u00e9er des fichiers rapidement",
    "You can create libraries by clicking the \"New Library\" button above.": "Vous pouvez cr\u00e9er des biblioth\u00e8ques en cliquant sur le bouton ci-dessus \"Nouvelle biblioth\u00e8que\".",
    "You can use this field at login.": "Vous pouvez utiliser ce champ \u00e0 la connexion.",
    "You don't have any favorite items yet": "Yous n'avez pas de favoris.",
    "You don't have any share links": "Vous n'avez aucun lien de t\u00e9l\u00e9chargement.",
    "You don't have any upload links": "Vous n'avez aucun lien d'envoi.",
    "You have an unsaved draft. Do you like to use it?": "Vous avez un brouillon qui n'est pas sauv\u00e9. Voulez-vous l'utiliser ?",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "Vous n'avez pas encore acc\u00e9d\u00e9 \u00e0 vos fichiers avec un client (bureau ou mobile). Configurez des clients sur vos appareils pour acc\u00e9der plus confortablement \u00e0 vos donn\u00e9es.",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "Vous n'avez pas encore ajout\u00e9 de biblioth\u00e8ques, dossiers ou fichiers \u00e0 vos favoris. Un favori permet un acc\u00e8s rapide \u00e0 vos objets les plus fr\u00e9quents. Vous pouvez ajouter une biblioth\u00e8que, dossier ou fichier \u00e0 vos favoris en cliquant sur l'\u00e9toile \u00e0 gauche de son libell\u00e9. ",
    "You have not created any libraries yet. A library is a container to organize your files and folders. A library can also be shared with others and synced to your connected devices. You can create a library by clicking the \"New Library\" button in the menu bar.": "Vous n'avez pas encore cr\u00e9\u00e9 de biblioth\u00e8que. Une biblioth\u00e8que est un contenant permettant d'organiser des dossiers et des fichiers. Une biblioth\u00e8que peut aussi \u00eatre partag\u00e9e avec d'autres utilisateurs et synchronis\u00e9e sur vos appareils. Vous pouvez cr\u00e9er une biblioth\u00e8que en cliquant sur le bouton \"Nouvelle biblioth\u00e8que\" dans la barre de menu.",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "Vous n'avez pas encore cr\u00e9\u00e9 de liens de partage. Un lien de partage peut \u00eatre utilis\u00e9 pour partager des fichiers et des dossiers avec n'importe qui. Vous pouvez cr\u00e9er un lien de partage pour un fichier ou un dossier en cliquant sur l'ic\u00f4ne de partage \u00e0 droite de son nom.",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "Vous n'avez pas encore cr\u00e9\u00e9 de lien d'envoi. Un lien d'envoi permet \u00e0 des utilisateurs anonymes de charger des fichiers dans un dossier ou une biblioth\u00e8que. Vous pouvez cr\u00e9er un lien d'envoi pour un dossier ou une biblioth\u00e8que en cliquant sur l'ic\u00f4ne de partage \u00e0 droite de son libell\u00e9. ",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "Vous n'avez supprim\u00e9 aucune biblioth\u00e8que au cours des derniers jours {placeholder}. Une biblioth\u00e8que supprim\u00e9e sera automatiquement nettoy\u00e9e apr\u00e8s cette p\u00e9riode.",
    "You have not invited any guests yet. A guest can access shared libraries through the web interface allowing more efficient ways to collaborate than through links. You can invite a guest by clicking the \"Invite Guest\" button in the menu bar.": "Vous n'avez pas encore invit\u00e9 d'invit\u00e9s. Un invit\u00e9 peut acc\u00e9der aux biblioth\u00e8ques partag\u00e9es par l'interm\u00e9diaire de l'interface web, ce qui permet de collaborer plus efficacement que par des liens. Vous pouvez inviter un invit\u00e9 en cliquant sur le bouton \"Inviter un invit\u00e9\" dans la barre de menu.",
    "You have not published any libraries yet. A published library can be accessed by anyone, not only users, via its URL. You can publish a library by clicking the \"Publish a Library\" button in the menu bar.": "Vous n'avez encore publi\u00e9 aucune biblioth\u00e8que. Une biblioth\u00e8que publi\u00e9e peut \u00eatre accessible \u00e0 tous, et pas seulement aux utilisateurs, via son URL. Vous pouvez publier une biblioth\u00e8que en cliquant sur le bouton \"Publier une biblioth\u00e8que\" dans la barre de menu.",
    "You have not shared any folders": "Vous n'avez partag\u00e9 aucun dossier.",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "Vous n'avez pas encore partag\u00e9 de dossiers avec d'autres utilisateurs. Vous pouvez partager un dossier avec d'autres utilisateurs en cliquant en cliquant sur l'ic\u00f4ne de partage \u00e0 droite de son libell\u00e9.",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "Vous n'avez encore partag\u00e9 aucune biblioth\u00e8que avec d'autres utilisateurs. Vous pouvez partager une biblioth\u00e8que avec d'autres utilisateurs en cliquant sur l'ic\u00f4ne de partage \u00e0 droite du nom d'une biblioth\u00e8que dans \"Mes biblioth\u00e8ques\".",
    "You have only one backup code remaining.": "Il ne vous reste qu'un seul code de sauvegarde.",
    "You have {num} backup codes remaining.": "Il vous reste {num} codes de sauvegarde.",
    "Your custom login URL": "Votre URL de connexion personalis\u00e9",
    "Your notifications will be sent to this email.": "Vos notifications seront envoy\u00e9es \u00e0 cette adresse e-mail.",
    "ZIP": "ZIP",
    "ZIP Selected Items": "Zipper les \u00e9l\u00e9ments s\u00e9lectionn\u00e9s",
    "activate after registration": "Activer apr\u00e8s l'inscription",
    "all": "tout",
    "all members": "Tous les membres",
    "allow new registrations": "Autoriser de nouvelles inscriptions",
    "days": "jours",
    "deleted": "Supprim\u00e9",
    "details": "D\u00e9tails",
    "email is required": "L'adresse e-mail est requise",
    "icon": "ic\u00f4ne",
    "keep sign in": "Laisser connect\u00e9",
    "library password minimum length": "Longueur minimale du mot de passe de la biblioth\u00e8que",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "Sous licence de {placeholder_license_to}, expire le {placeholder_license_expiration}",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "Sous licence de {placeholder_license_to}, le service de mise \u00e0 niveau a expir\u00e9 le {placeholder_license_expiration}",
    "locked": "verrouill\u00e9",
    "locked by {name}": "Verrouill\u00e9 par {name}",
    "name": "nom",
    "not set": "non d\u00e9fini",
    "only show {placeholder}": "N'affichez que {placeholder}",
    "password minimum length": "Longueur minimale du mot de passe",
    "password strength level": "Niveau de force du mot de passe",
    "progress": "Progression",
    "result": "R\u00e9sultat",
    "results": "R\u00e9sultats",
    "send activation email": "Envoyer l'e-mail d'activation",
    "share/upload link force password": "partager/envoyer en force le lien du mot de passe",
    "share/upload link password minimum length": "partager/envoyer le lien du mot de passe pour une longueur minimale",
    "share/upload link password strength level": "partager/envoyer le lien du mot de passe par niveau de force",
    "shared by:": "partag\u00e9 par :",
    "show more": "Voir plus",
    "size": "Taille",
    "starred": "favoris",
    "state": "\u00c9tat",
    "successfully added user %s.": "L'utilisateur %s a \u00e9t\u00e9 ajout\u00e9 avec succ\u00e8s.",
    "text file extensions": "Extensions des fichiers texte",
    "to": "vers",
    "unstarred": "Retir\u00e9 des favoris",
    "you can also press \u2190 ": "Vous pouvez aussi utiliser la touche \u2190 ",
    "you can also press \u2192": "Vous pouvez aussi utiliser la touche \u2192",
    "{file} and {n} other files": "{file} et {n} autres fichiers",
    "{from_user} has sent you a request for {draft_link}.": "{from_user} a envoy\u00e9 une demande pour {draft_link}.",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} jours",
    "{number_placeholder} / Page": "{number_placeholder} / Page",
    "{placeholder} API Token": "{placeholder} du jeton API",
    "{placeholder} Folder Permission": "Droits sur le dossier {placeholder}",
    "{placeholder} Modification History": "Historique des modifications de {placeholder} ",
    "{placeholder} Snapshot": "Instantan\u00e9 de {placeholder}",
    "{placeholder} Trash": "Corbeille de {placeholder}",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from} a partag\u00e9 un r\u00e9pertoire nomm\u00e9e {repo_link} avec le groupe {group_link}. ",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} a partag\u00e9 un r\u00e9pertoire nomm\u00e9e {repo_link} avec vous.",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from} a partag\u00e9 une biblioth\u00e8que nomm\u00e9e {repo_link} avec le groupe {group_link}. ",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} a partag\u00e9 une biblioth\u00e8que nomm\u00e9e {repo_link} avec vous.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. However, since you are a guest user now, you can not create libraries.": "{site_name_placeholder} organise les fichiers dans des biblioth\u00e8ques. Chaque biblioth\u00e8que peut \u00eatre synchronis\u00e9e et partag\u00e9e s\u00e9par\u00e9ment. Cependant, en tant qu'utilisateur invit\u00e9, vous ne pouvez pas cr\u00e9er de biblioth\u00e8ques.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. We have created a personal library for you. You can create more libraries later.": "{site_name_placeholder} organise les fichiers dans des biblioth\u00e8ques. Chaque biblioth\u00e8que peut \u00eatre synchronis\u00e9e et partag\u00e9e s\u00e9par\u00e9ment. Nous avons cr\u00e9\u00e9 une biblioth\u00e8que personnelle pour vous. Vous pourrez cr\u00e9er plus de biblioth\u00e8ques ult\u00e9rieurement.",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "Le(s) utilisateur(s) {userCount} et les biblioth\u00e8ques {repoCount} de cette organisation seront \u00e9galement supprim\u00e9s.",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "L'utilisateur {user} a cr\u00e9\u00e9 le fichier {fileName} et {fileCount} autre(s) fichier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} created file {fileName} in library {libraryName}.": "L'utilisateur {user} a cr\u00e9\u00e9 le fichier {fileName} dans la biblioth\u00e8que {libraryName}.",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "L'utilisateur {user} a cr\u00e9e le dossier {folderName} et {folderCount} autre(s) dossier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} created folder {folderName} in library {libraryName}.": "L'utilisateur {user} a cr\u00e9e le dossier {folderName} dans la biblioth\u00e8que {libraryName}.",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "L'utilisateur {user} a supprim\u00e9 le fichier {fileName} et {fileCount} autre(s) fichier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} deleted file {fileName} in library {libraryName}.": "L'utilisateur {user} a supprim\u00e9 le fichier {fileName} dans la biblioth\u00e8que {libraryName}.",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "L'utilisateur {user} a supprim\u00e9 le dossier {folderName} et {folderCount} autre(s) dossier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} deleted folder {folderName} in library {libraryName}.": "L'utilisateur {user} a supprim\u00e9 le dossier {folderName} dans la biblioth\u00e8que {libraryName}.",
    "{user} has transfered a library named {repo_link} to you.": "{share_from} vous a transf\u00e9r\u00e9 une biblioth\u00e8que nomm\u00e9e {repo_link}.",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "L'utilisateur {user} a d\u00e9plac\u00e9 le fichier {fileName} et {fileCount} autre(s) fichier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} moved file {fileName} in library {libraryName}.": "L'utilisateur {user} a d\u00e9plac\u00e9 le fichier {fileName} dans la biblioth\u00e8que {libraryName}.",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "L'utilisateur {user} a d\u00e9plac\u00e9 le dossier {folderName} et {folderCount} autre(s) dossier(s) dans la biblioth\u00e8que {libraryName}.",
    "{user} moved folder {folderName} in library {libraryName}.": "L'utilisateur {user} a d\u00e9plac\u00e9 le dossier {folderName} dans la biblioth\u00e8que {libraryName}.",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "L'utilisateur {user} a renomm\u00e9 le fichier {oldFileName} en {fileName} dans la biblioth\u00e8que {libraryName}.",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "L'utilisateur {user} a renomm\u00e9 le dossier {oldFolderName} en {folderName} dans la biblioth\u00e8que {libraryName}.",
    "{user} restored file {fileName} in library {libraryName}.": "L'utilisateur {user} a restaur\u00e9 le fichier {fileName} dans la biblioth\u00e8que {libraryName}.",
    "{user} restored folder {folderName} in library {libraryName}.": "L'utilisateur {user} a restaur\u00e9 le dossier {folderName} dans la biblioth\u00e8que {libraryName}.",
    "{user} updated file {fileName} in library {libraryName}.": "L'utilisateur {user} a mis a jour le fichier {fileName} dans la biblioth\u00e8que {libraryName}."
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "j F Y H:i",
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S",
      "%d/%m/%Y %H:%M:%S.%f",
      "%d/%m/%Y %H:%M",
      "%d.%m.%Y %H:%M:%S",
      "%d.%m.%Y %H:%M:%S.%f",
      "%d.%m.%Y %H:%M",
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%Y-%m-%d"
    ],
    "DATE_FORMAT": "j F Y",
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y",
      "%d/%m/%y",
      "%d.%m.%Y",
      "%d.%m.%y",
      "%Y-%m-%d"
    ],
    "DECIMAL_SEPARATOR": ",",
    "FIRST_DAY_OF_WEEK": 1,
    "MONTH_DAY_FORMAT": "j F",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "j N Y H:i",
    "SHORT_DATE_FORMAT": "j N Y",
    "THOUSAND_SEPARATOR": "\u00a0",
    "TIME_FORMAT": "H:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

