

'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(If left blank, owner will be admin)": "(Si queda en blanco, el propietario ser\u00e1 admin)",
    "(at least {placeholder} characters)": "(al menos {placeholder} caracteres)",
    "(current notification)": "(notificaci\u00f3n actual)",
    "(current version)": "(versi\u00f3n actual)",
    "1 Year": "1 a\u00f1o",
    "1 month ago": "m\u00e1s de 1 mes",
    "1 week ago": "m\u00e1s de 1 semana",
    "3 days ago": "m\u00e1s de 3 d\u00edas",
    "30 Days": "30 d\u00edas",
    "7 Days": "7 d\u00edas",
    "A file is being uploaded. Are you sure you want to leave this page?": "Un archivo est\u00e1 siendo subido, \u00bfest\u00e1s seguro que deseas abandonar esta p\u00e1gina?",
    "A file with the same name already exists in this folder.": "Ya existe un archivo con el mismo nombre en esta carpeta.",
    "API token is copied to the clipboard.": "API token copiado al portapapeles.",
    "About": "Acerca de",
    "About Us": "Acerca de nosotros",
    "Abuse Content": "Contenido Abusivo",
    "Abuse Reports": "Informe de Abuso",
    "Abuse Type": "Tipo de Abuso",
    "Accept": "Aceptar",
    "Accepted": "Aceptada",
    "Accepter": "Acepta",
    "Access Log": "Registro de Acceso",
    "Action": "Acci\u00f3n",
    "Actions": "Acciones",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "Activar el usuario inmediatamente despu\u00e9s del registro. Si est\u00e1 desmarcado, el usuario necesita ser activado por un administrador o mediante un email de activaci\u00f3n",
    "Activated": "Activado",
    "Activated Users": "Usuarios activados",
    "Active": "Activo",
    "Active Users": "Usuarios Activos",
    "Activities": "Actividades",
    "Add": "Agregar",
    "Add Admin": "Agregar Admin",
    "Add Admins": "Agregar Administradores",
    "Add Institution": "Agregar Instituci\u00f3n",
    "Add Library": "Agregar Biblioteca",
    "Add Member": "Agregar Miembro",
    "Add Organization": "Agregar Organizaci\u00f3n",
    "Add Terms and Conditions": "Agregar T\u00e9rminos y Condiciones",
    "Add User": "Agregar Usuario",
    "Add admin": "Agregar admin",
    "Add auto expiration": "Agregar vencimiento autom\u00e1tico",
    "Add group member": "Agregar miembro al grupo",
    "Add institution": "Agregar Instituci\u00f3n",
    "Add new notification": "Agregar nueva notificaci\u00f3n",
    "Add new reviewer": "Agregar un revisor",
    "Add password protection": "Agregar protecci\u00f3n por contrase\u00f1a",
    "Add user": "Agregar usuario",
    "Added": "Agregado",
    "Added user {user}": "Usuario {user} agregado",
    "Admin": "Administrar",
    "Admin Login Logs": "Registros de ingreso de Admin",
    "Admin Logs": "Registros de Admin",
    "Admin Operation Logs": "Registros de operaciones de Admin",
    "Admin access": "Acceso de administrador",
    "Admins": "Administradores",
    "All": "Todas",
    "All Groups": "Todos los grupos",
    "All Libraries": "Todas las Bibliotecas",
    "All Notifications": "Todas las notificaciones",
    "All Public Links": "Enlaces P\u00fablicos",
    "All file types": "Todos los tipos",
    "All files uploaded": "Todos los archivos subidos",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "Permitir que nuevos usuarios se registren. Desmarcar \u00e9sto para que nadie pueda crear una nueva cuenta.",
    "Allow user to change library history settings": "Permitir al usuario modificar la configuraci\u00f3n del historial de la biblioteca",
    "Allow user to clean library trash": "Permitir al usuario vaciar la papelera de la biblioteca",
    "Allow user to create encrypted libraries": "Permitir al usuario crear bibliotecas encriptadas",
    "An integer that is greater than 0 or equal to -2.": "Un n\u00famero entero mayor que 0 o igual a -2.",
    "An integer that is greater than or equal to 0.": "Un n\u00famero entero mayor o igual que 0.",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "Un enlace interno es un enlace a un archivo o carpeta que puede ser accedido por usuarios con permiso de lectura al archivo o carpeta. ",
    "Anonymous User": "Usuario An\u00f3nimo",
    "App Name": "Nombre de App",
    "Are you sure to delete": "\u00bfEst\u00e1 seguro de eliminar?",
    "Are you sure to revoke access of user {placeholder} ?": "\u00bfSeguro que quieres revocar el acceso del usuario {placeholder} ?",
    "Are you sure you want to clear trash?": "\u00bfSeguro que deseas vaciar la papelera?",
    "Are you sure you want to delete %s ?": "\u00bfSeguro que quieres borrar %s ?",
    "Are you sure you want to delete the notification ?": "\u00bfEst\u00e1 seguro que desea borrar la notificaci\u00f3n?",
    "Are you sure you want to delete the selected user(s) ?": "\u00bfSeguro que deseas eliminar los usuarios selecionados?",
    "Are you sure you want to delete the share link?": "\u00bfEst\u00e1 seguro que desea eliminar el enlace de compartir?",
    "Are you sure you want to delete {placeholder} ?": "\u00bfSeguro que quieres borrar {placeholder} ?",
    "Are you sure you want to delete {placeholder} completely?": "\u00bfEst\u00e1 seguro que desea eliminar {placeholder} completamente?",
    "Are you sure you want to disconnect?": "\u00bfSeguro que deseas desconectar?",
    "Are you sure you want to remove {placeholder} ?": "\u00bfSeguro que quieres eliminar {placeholder} ?",
    "Are you sure you want to reset the password of {placeholder} ?": "\u00bfEst\u00e1 seguro que desea restablecer la contrase\u00f1a de {placeholder} ?",
    "Are you sure you want to restore this library?": "\u00bfEst\u00e1s seguro que deseas restaurar est\u00e1 biblioteca?",
    "Are you sure you want to restore {placeholder}?": "\u00bfEst\u00e1 seguro que desea restaurar {placeholder} completamente?",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "\u00bfEst\u00e1 seguro que desea revocar los permisos de administrador de {placeholder} ?",
    "Are you sure you want to set {placeholder} as Admin?": "\u00bfEst\u00e1 seguro que desea establecer a {placeholder} como Admin?",
    "Are you sure you want to unlink this device?": "\u00bfEst\u00e1s seguro que deseas desvincular este dispositivo?",
    "Are you sure you want to unpublish this library?": "\u00bfEst\u00e1s seguro que deseas dejar de publicar esta biblioteca?",
    "Are you sure you want to unshare {placeholder} ?": "\u00bfEst\u00e1 seguro que desea dejar de compartir {placeholder} ?",
    "At server": "En el servidor",
    "Audio": "Audio",
    "Audit Admin": "Administrador auditor",
    "Auto deletion": "Eliminaci\u00f3n autom\u00e1tica",
    "Automatically delete files that are not modified within certain days:": "Eliminar autom\u00e1ticamente los archivos que no se modifican en determinado lapso de d\u00edas:",
    "Avatar": "Avatar",
    "Avatar:": "Avatar:",
    "Back": "Atr\u00e1s",
    "Besides Write permission, user can also share the library.": "Adem\u00e1s del permiso de escritura, el usuario tambi\u00e9n puede compartir la biblioteca.",
    "Branding": "Personalizar",
    "Broken (please contact your administrator to fix this library)": "Da\u00f1ada (por favor contacte al administrador para reparar esta biblioteca)",
    "Broken ({repo_id_placeholder})": "({repo_id_placeholder}) Da\u00f1ado",
    "By name ascending": "Por nombre ascendente",
    "By name descending": "Por nombre descendente",
    "By size ascending": "Por tama\u00f1o ascendente",
    "By size descending": "Por tama\u00f1o descendente",
    "By time ascending": "Por fecha ascendente",
    "By time descending": "Por fecha descendente",
    "Can not copy directory %(src)s to its subdirectory %(des)s": "No se pudo copiar la carpeta %(src)s a la subcarpeta %(des)s",
    "Can not move directory %(src)s to its subdirectory %(des)s": "No se pudo mover la carpeta %(src)s a la subcarpeta %(des)s",
    "Cancel": "Cancelar",
    "Cancel All": "Cancelar Todo",
    "Change": "Cambiar",
    "Change Password": "Cambiar contrase\u00f1a",
    "Change Password of Library {placeholder}": "Cambiar Contrase\u00f1a de la Biblioteca {placeholder}",
    "Changes": "Cambios",
    "Choose date": "Escoja fecha",
    "Clean": "Limpiar",
    "Clean succeeded.": "Limpieza exitosa.",
    "Cleaned trash": "Papelera vac\u00eda",
    "Clear": "Limpiar",
    "Clear Trash": "Vaciar Papelera",
    "Clear files in trash and history\uff1a": "Limpiar archivos en la papelera y en el historial :",
    "Clients": "Clientes",
    "Close": "Cerrar",
    "Column": "Columna",
    "Community Edition": "Versi\u00f3n Community",
    "Confirm": "Confirmar",
    "Confirm Password": "Confirmar contrase\u00f1a",
    "Connect": "Conectar",
    "Contact Email": "Email de Contacto",
    "Contact Email:": "Email de contacto:",
    "Contact Information": "Informaci\u00f3n de contacto",
    "Contact information is required.": "Se requiere informaci\u00f3n de contacto.",
    "Content Scan Records": "Registros de An\u00e1lisis de Contenido",
    "Copy": "Copiar",
    "Copy selected item(s) to:": "Copiar item(s) seleccionados a:",
    "Copy {num} items": "Copiar {num} items",
    "Copy {placeholder} to": "Copiar {placeholder} a",
    "Copyright Infringement": "Violaci\u00f3n de derechos de autor",
    "Count": "Cuenta",
    "Create": "Crear",
    "Create Group": "Crear Grupo",
    "Create Library": "Crear Biblioteca",
    "Create Report": "Crear Informe",
    "Create a draft from this file, instead of editing it directly.": "Crear un borrador a partir de este archivo en lugar de editarlo directamente.",
    "Create a new tag": "Cear una nueva etiqueta",
    "Created": "Creado",
    "Created At": "Creado En",
    "Created Files": "Archivos Creados",
    "Created draft": "Borrador creado",
    "Created file": "Archivo creado",
    "Created folder": "Carpeta creada",
    "Created group {group_name}": "Grupo {group_name} creado",
    "Created library": "Biblioteca creada",
    "Created library {library_name} with {owner} as its owner": "Biblioteca {library_name} creada con {owner} como su propietario",
    "Created {n} files": "Creado {n} archivos",
    "Creator": "Creador",
    "Current Connected Devices": "Dispositivos Conectados Actualmente",
    "Current Library": "Biblioteca actual",
    "Current Path: ": "Ruta actual:",
    "Current Version": "Versi\u00f3n Actual",
    "Current path: ": "Ruta actual:",
    "Custom CSS": "CSS personalizado",
    "Custom file types": "Tipos de archivo personalizados",
    "Daily Admin": "Administrador diario",
    "Database": "Base de datos",
    "Date": "Fecha",
    "Date Invalid.": "Fecha inv\u00e1lida.",
    "Default": "Predeterminado",
    "Default Admin": "Administrador predeterminado",
    "Delete": "Borrar",
    "Delete Account": "Eliminar Cuenta",
    "Delete Department": "Eliminar Departamento",
    "Delete Expired Invitations": "Borrar invitaciones vencidas",
    "Delete File": "Eliminar Archivo",
    "Delete Folder": "Eliminar Carpeta",
    "Delete Group": "Borrar Grupo",
    "Delete Institution": "Eliminar Instituci\u00f3n",
    "Delete Library": "Eliminar Biblioteca",
    "Delete Member": "Eliminar Miembro",
    "Delete Notification": "Borrar notificaci\u00f3n",
    "Delete Organization": "Borrar organizaci\u00f3n",
    "Delete T&C": "Eliminar T&C",
    "Delete Time": "Borrar fecha",
    "Delete User": "Eliminar usuario",
    "Delete Users": "Eliminar Usuarios",
    "Delete draft": "Eliminar borrador",
    "Delete files from this device the next time it comes online.": "Eliminar archivos de este dispositivo la pr\u00f3xima vez que est\u00e9 en l\u00ednea.",
    "Deleted": "Borrado",
    "Deleted Libraries": "Bibliotecas eliminadas",
    "Deleted Time": "Fecha de eliminaci\u00f3n",
    "Deleted directories": "Carpetas eliminadas",
    "Deleted draft": "Borrador eliminado",
    "Deleted file": "Archivo eliminado",
    "Deleted files": "Archivos eliminados",
    "Deleted folder": "Carpeta eliminada",
    "Deleted group {group_name}": "Grupo {group_name} eliminado",
    "Deleted library": "Biblioteca eliminada",
    "Deleted library {library_name}": "Biblioteca {library_name} eliminada",
    "Deleted user {user}": "Usuario {user} eliminado",
    "Departments": "Departmentos",
    "Description": "Descripci\u00f3n",
    "Description is required": "Descripci\u00f3n requerida",
    "Desktop": "Escritorio",
    "Details": "Detalles",
    "Device": "Dispositivo",
    "Device Name": "Nombre de dispositivo",
    "Devices": "Dispositivos",
    "Direct Download Link:": "Enlace de descarga directa:",
    "Direct download link is copied to the clipboard.": "Enlace de descarga directa copiado al portapapeles.",
    "Directory": "Carpeta",
    "Disable Two-Factor Authentication": "Deshabilitar Autenticaci\u00f3n de dos Factores",
    "Disconnect": "Desconectar",
    "Do not automatically delete files": "No eliminar autom\u00e1ticamente los archivos",
    "Document": "Documento",
    "Document convertion failed.": "Fall\u00f3 la conversi\u00f3n del documento ",
    "Documents": "Documentos",
    "Don't ignore": "No ignorar",
    "Don't keep history": "No mantener historial",
    "Don't replace": "No reemplazar",
    "Don't send emails": "No enviar emails",
    "Download": "Descargar",
    "Download an example file": "Descargar un archivo de ejemplo",
    "Download and upload": "Descargar y subir",
    "Draft": "Borrador",
    "Draft is a way to let you collaborate with others on files. You can create a draft from a file, edit the draft and then ask for a review. The original file will be updated only after the draft has been reviewed.": "Un borrador es una manera de colaborar con otros en archivos. Puedes crear un borrador a partir de un archivo, editarlo y luego solicitar su revisi\u00f3n. El archivo original  ser\u00e1 actualizado s\u00f3lo despu\u00e9s que el borrador haya sido revisado.",
    "Drafts": "Borradores",
    "Drag and drop files or folders here.": "Arrastrar y soltar archivos aqu\u00ed.",
    "Edit": "Editar",
    "Edit File": "Editar Archivo",
    "Edit labels": "Editar etiquetas",
    "Edit on cloud and download": "Editar en la nube y descargar",
    "Edit on cloud only": "Editar s\u00f3lo en la nube",
    "Edit succeeded": "Editado con \u00e9xito",
    "Edit succeeded.": "Editado con \u00e9xito.",
    "Email": "Email",
    "Email Notification": "Email de notificaci\u00f3n",
    "Email is invalid.": "Email es inv\u00e1lido",
    "Emails": "Emails",
    "Emails, separated by ','": "Emails, separados por ','",
    "Enable Two-Factor Authentication": "Habilitar Autenticaci\u00f3n de dos Factores",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "Habilitar al administrador del sistema a agregar T\u00e9rminos y Condiciones, y todos los usuarios deber\u00e1n aceptar los t\u00e9rminos.",
    "Enable two factor authentication": "Habilitar autenticaci\u00f3n de dos factores",
    "Enable users to share libraries to any groups in the system.": "Habilitar que los usuarios puedan compartir bibliotecas con cualquier grupo en el sistema.",
    "Encrypt": "Encriptar",
    "Encrypted library": "Biblioteca encriptada",
    "End date": "Fecha Fin",
    "Enter characters to start searching": "Ingrese caracteres para comenzar la b\u00fasqueda",
    "Error": "Error",
    "Errors": "Errores",
    "Exit Institution Admin": "Salir de Administrador de la Instituci\u00f3n",
    "Exit Organization Admin": "Salir de Administrador de la Organizaci\u00f3n",
    "Exit System Admin": "Salir de Administrador",
    "Expiration": "Vencimiento",
    "Expiration Date:": "Fecha de Vencimiento:",
    "Expiration days": "D\u00edas de vencimiento",
    "Expiration time": "Tiempo de vencimiento",
    "Expired": "Expirado",
    "Expired at": "Vencido en",
    "Export Excel": "Exportar Excel",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "Extensiones de los archivos de texto con vista previa en l\u00ednea, sufijos separados por una coma.",
    "Failed": "Fall\u00f3",
    "Failed to add {email_placeholder}: {error_msg_placeholder}": "Fallo al agregar {email_placeholder}: {error_msg_placeholder}",
    "Failed to copy %(name)s": "Fallo al copiar %(name)s",
    "Failed to copy %(name)s and %(amount)s other item(s).": "Fallo al copiar %(name)s y %(amount)s otros item(s).",
    "Failed to copy %(name)s.": "Fallo al copiar %(name)s.",
    "Failed to copy files to another library.": "Fallo al copiar archivos a otra biblioteca.",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "Fallo al eliminar %(virus_file) de la biblioteca %(library): %(error_msg)",
    "Failed to delete draft %(draft)s.": "Fallo al eliminar %(draft)s.",
    "Failed to delete {name}": "Fallo al eliminar {name}",
    "Failed to delete {name}.": "Fallo al eliminar {name}.",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "Fallo al ignorar %(virus_file) de la biblioteca %(library): %(error_msg)",
    "Failed to move %(name)s and %(amount)s other item(s).": "Fallo al mover %(name)s y %(amount)s otros item(s).",
    "Failed to move %(name)s.": "Fallo al mover %(name)s.",
    "Failed to move files to another library.": "Fallo al mover archivos a otra biblioteca.",
    "Failed to move {name}.": "Fallo al mover {name}.",
    "Failed to publish draft %(draft)s.": "Fallo al publicar el borrador %(draft)s.",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "Failo al enviar a {email_placeholder}: {errorMsg_placeholder}",
    "Failed to unshare {name}": "Fallo al dejar de compartir {name}",
    "Failed to upload {file_name}.": "Fallo al subir {file_name}.",
    "Failed. Please check the network.": "Fallo. Por favor, verifica la red.",
    "Favorites": "Favoritos",
    "File": "Archivo",
    "File Access": "Acceso a archivo",
    "File Operations": "Operaciones de archivos",
    "File Scan": "Escanear Archivo",
    "File Types": "Tipos de Archivo",
    "File Update": "Actualizaci\u00f3n de archivo",
    "File Upload": "Subir archivo",
    "File Uploading...": "Subiendo archivo...",
    "File already exists.": "El archivo ya existe.",
    "File does not exist.": "El archivo no existe",
    "File download is disabled: the share link traffic of owner is used up.": "Descarga de archivos deshabilitada: tr\u00e1fico del propietario para compartir enlaces agotado.",
    "File extensions can only be {placeholder}.": "Las extensiones de archivo solamente pueden ser {placeholder}.",
    "File is locked by others.": "El archivo est\u00e1 bloqueado por otros.",
    "File size is too large.": "El tama\u00f1o de archivo es demasiado grande.",
    "File size should be smaller than {max_size_placeholder}.": "El tama\u00f1o debe ser menor que {max_size_placeholder}.",
    "File upload started": "Subida de archivo iniciada",
    "Files": "Archivos",
    "Folder": "Carpeta",
    "Folder Permission": "Permiso de Carpeta",
    "Folder does not exist.": "La carpeta no existe",
    "Folder upload is limited to Chrome, Firefox 50+, and Microsoft Edge.": "Subir carpetas esta limitado a Chrome, Firefox 50+, y Microsoft Edge.",
    "Folders": "Carpetas",
    "Force user to change password when account is newly added or reset by admin": "Forzar a que el usuario cambie la contrase\u00f1a cuando se crea la cuenta o reestablecida por un administrador",
    "Force user to use a strong password when sign up or change password.": "Forzar a que el usuario utilice una contrase\u00f1a segura al registrarse o al cambiar la contrase\u00f1a.",
    "Force user use password when generating share/upload link.": "Forzar al usuario a utilizar una contrase\u00f1a al generar un recurso compartido/enlace de subida",
    "Freeze user account when failed login attempts exceed limit.": "Inmovilizar la cuenta del usuario cuando el n\u00famero de intentos de acceso fallidos exceda el l\u00edmite.",
    "Generate": "Generar",
    "Global Address Book": "Libreta de direcciones global",
    "Go to Library": "Ir a la Biblioteca",
    "Greater than or equal to {minDays_placeholder} days": "Mayor o igual que {minDays_placeholder} d\u00edas",
    "Grid": "Grilla",
    "Group": "Grupo",
    "Group Permission": "Permiso de grupo",
    "Group not found": "Grupo no encontrado",
    "Groups": "Grupos",
    "Guest": "Invitado",
    "Handled": "Manejado",
    "Help": "Ayuda",
    "Hide": "Ocultar",
    "History": "Historial",
    "History Setting": "Configuraci\u00f3n de historial",
    "History Versions": "Historial de Versiones",
    "IP": "IP",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "Si las notificaciones no han sido le\u00eddas en el plazo de una hora, ser\u00e1n enviadas a su casilla de correo.",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "Si est\u00e1 activado el cliente de escritorio no podr\u00e1 sincronizar una carpeta fuera de la carpeta Seafile preestablecida.",
    "If you don't have any device with you, you can access your account using backup codes.": "Si no posse ning\u00fan dispositivo consigo, puede acceder a su cuenta utilizando c\u00f3digos de respaldo.",
    "Ignore": "Ignorar",
    "Ignored": "Ignorado",
    "Image": "Imagen",
    "Images": "Im\u00e1genes",
    "Import Members": "Importar Miembros",
    "Import Users": "Importar Usuarios",
    "Import members from a .xlsx file": "Importar miembros desde un archivo .xlsx",
    "Import users": "Importar usuarios",
    "Import users from a .xlsx file": "importar usuarios desde un archivo .xlsx",
    "In all libraries": "En todas las bibliotecas",
    "Inactive": "Inactivo",
    "Indexing...": "Indexando...",
    "Info": "Info",
    "Input file extensions here, separate with ','": "Ingresa extensiones de archivo, separadas con ','",
    "Institution": "Instituci\u00f3n",
    "Institution Admin": "Administrador de la Instituci\u00f3n",
    "Institutions": "Instituciones",
    "Internal Link": "Enlace interno",
    "Internal Server Error": "Error interno del servidor",
    "Internal link has been copied to clipboard": "El enlace interno ha sido copiado al portapapeles",
    "Invalid destination path": "Ruta de destino inv\u00e1lida",
    "Invalid file size range.": "Rango de tama\u00f1o de archivo inv\u00e1lido.",
    "Invalid filename.": "Nombre de archivo inv\u00e1lido.",
    "Invalid month, should be yyyymm.": "Mes inv\u00e1lido, debe ser yyyymm.",
    "Invitations": "Invitaciones",
    "Invite Guest": "Convocar Invitado",
    "Invite Time": "Fecha de Invitaci\u00f3n",
    "Invited at": "Invita en",
    "Inviter": "Invita",
    "It is required.": "Es requerido.",
    "It may take some time, please wait.": "Puede tomar un tiempo, por favor espere.",
    "Keep full history": "Mantener historial completo",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP (importado)",
    "Label": "Etiqueta",
    "Label Current State": "Etiquetar el estado actual",
    "Labels": "Etiquetas",
    "Language": "Idioma",
    "Language Setting": "Configuraci\u00f3n de idioma",
    "Last Access": "\u00daltimo acceso",
    "Last Login": "\u00daltimo Ingreso",
    "Last Update": "\u00daltima actualizaci\u00f3n",
    "Last modified by": "\u00daltima modificaci\u00f3n por",
    "Leave": "Abandonar",
    "Leave Group": "Abandonar el grupo",
    "Leave Share": "Dejar de compartir",
    "Less than or equal to {maxDays_placeholder} days": "Menor o igual que {maxDays_placeholder} d\u00edas",
    "Libraries": "Bibliotecas",
    "Library": "Biblioteca",
    "Library Type": "Tipo de Biblioteca",
    "Library can not be shared to owner.": "La biblioteca no puede ser compartida con su propietario.",
    "Limits": "L\u00edmites",
    "Link": "Enlace",
    "Link has been copied to clipboard": "El enlace ha sido copiado al portapapeles",
    "Link:": "Enlace:",
    "Linked Devices": "Dispositivos vinculados",
    "Links": "Enlaces",
    "List": "Lista",
    "List your account in global address book, so that others can find you by typing your name.": "Incluya su cuenta en la libreta de direcciones global, de manera que otros puedan encontrarlo tipeando su nombre.",
    "Local draft": "Borrador local",
    "Local draft saved": "Borrador local guardado",
    "Location": "Ubicaci\u00f3n",
    "Lock": "Bloquear",
    "Log out": "Desconectarse",
    "Login": "Acceder",
    "Login Background Image": "Imagen de fondo de inicio de sesi\u00f3n",
    "Logs": "Registros",
    "Manage Members": "Administrar Miembros",
    "Manage group members": "Administrar miembros del grupo",
    "Mark all read": "Marcar todo le\u00eddo",
    "Member": "Miembro",
    "Members": "Miembros",
    "Message": "Mensaje",
    "Message (optional):": "Mensaje (opcional):",
    "Mobile": "M\u00f3vil",
    "Modification Details": "Detalles de modificaci\u00f3n",
    "Modified": "Modificado",
    "Modified files": "Archivos modificados",
    "Modifier": "Modific\u00f3",
    "Modify": "Modificar",
    "Month:": "Mes:",
    "Monthly User Traffic": "Tr\u00e1fico Mensual de Usuario",
    "More": "M\u00e1s",
    "More Operations": "M\u00e1s Operaciones",
    "Move": "Mover",
    "Move selected item(s) to:": "Mover item(s) seleccionados a:",
    "Move {num} items": "Mover {num} items",
    "Move {placeholder} to": "Mover {placeholder} a",
    "Moved file": "Archivo movido",
    "Moved folder": "Carpeta movida",
    "My Groups": "Mis grupos",
    "My Libraries": "Mis Bibliotecas",
    "Name": "Nombre",
    "Name is required": "Nombre requerido",
    "Name is required.": "Se requiere nombre.",
    "Name should not include '/'.": "El nombre no debe contener ' / '.",
    "Name(optional)": "Nombre (opcional)",
    "Network error": "Error de red",
    "New": "Nuevo",
    "New Department": "Nuevo Departamento",
    "New Department Library": "Nueva Biblioteca Departamental",
    "New Draft": "Nuevo Borrador",
    "New Excel File": "Nuevo Archivo Excel",
    "New File": "Nuevo archivo",
    "New Folder": "Nueva Carpeta",
    "New Group": "Nuevo Grupo",
    "New Library": "Nueva biblioteca",
    "New Markdown File": "Nuevo Archivo Markdown",
    "New Password": "Nueva Contrase\u00f1a",
    "New Password Again": "Nueva contrase\u00f1a otra vez",
    "New PowerPoint File": "Nuevo Archivo PowerPoint",
    "New Sub-department": "Nuevo Sub-departamento",
    "New Tag": "Nueva etiqueta",
    "New Wiki": "Nuevo Wiki",
    "New Word File": "Nuevo Archivo Word",
    "New directories": "Carpetas nuevas",
    "New file name": "Nuevo nombre de archivo",
    "New files": "Archivos nuevos",
    "New folder name": "Nuevo nombre de carpeta",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": "La nueva contrase\u00f1a fue enviada a tu email {mail}. Por favor verifica tu casilla de correo Si no recibes la contrase\u00f1a, por favor verifica que tu direcci\u00f3n de correo est\u00e9 bien configurada.",
    "New password is too short": "La nueva contrase\u00f1a es demasiado corta",
    "New passwords don't match": "Las contrase\u00f1as no coinciden",
    "Next": "Siguiente",
    "No": "No",
    "No Admin login logs": "No hay registros de ingreso de Admin",
    "No Admin operation logs": "No hay registros de operaciones de Admin",
    "No connected devices": "No hay dispositivos conectados",
    "No deleted libraries": "No hay bibliotecas eliminadas",
    "No departments": "No hay departamentos",
    "No draft yet": "Todav\u00eda no hay borrador",
    "No favorites": "No hay favoritos",
    "No file access logs": "No hay registro de acceso a archivos.",
    "No file update logs": "No hay registros de actualizaci\u00f3n de archivo.",
    "No folders shared": "No hay carpetas compartidas",
    "No groups": "No hay grupos",
    "No guest invitations": "No hay convocaciones a invitados",
    "No invitations": "No hay invitaciones",
    "No libraries": "No hay bibliotecas",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "No se han compartido bibliotecas directamente contigo. Una biblioteca se puede compartir con permisos totales o restringidos. Si necesitas acceder a una biblioteca de otro usuario, solic\u00edtale que la comparta contigo.",
    "No libraries have been shared with this group yet. A library shared with a group can be accessed by all group members. You can share a library with a group in \"My Libraries\". You can also create a new library to be shared with this group by clicking the \"New Library\" button in the menu bar.": "Todav\u00eda no se han compartido bibliotecas con este grupo. Una biblioteca compartida con un grupo puede ser accedida por todos los miembros del grupo. Puedes compartir una biblioteca con un grupo en \"Mis Bibliotecas\". Tambi\u00e9n puedes crear una nueva biblioteca para ser compartida con este grupo haciendo click en el bot\u00f3n \"Nueva Biblioteca\" en la barra del men\u00fa.",
    "No libraries have been shared with you": "No hay bibliotecas compartidas contigo",
    "No libraries have been shared with you from other servers.": "No se han compartido bibliotecas contigo desde otros servidores.",
    "No libraries shared": "No hay bibliotecas compartidas",
    "No libraries shared with this group": "No hay bibliotecas compartidas este grupo",
    "No linked devices": "No hay dispositivos vinculados",
    "No login logs": "No hay registros de ingreso.",
    "No members": "No hay miembros",
    "No notifications": "No hay notificaciones",
    "No permission logs": "No hay registros de permisos.",
    "No preview": "No hay vista previa",
    "No public libraries": "No hay bibliotecas p\u00fablicas",
    "No public libraries have been created yet. A public library is accessible by all users. You can create a public library by clicking the \"Add Library\" button in the menu bar.": "Todav\u00eda no se han creado bibliotecas p\u00fablicas. Una biblioteca p\u00fablica es accesible por todos los usuarios. Puedes crear una biblioteca p\u00fablica haciendo click en el bot\u00f3n \"Agregar Biblioteca\" en la barra del men\u00fa.",
    "No published libraries": "No hay bibliotecas publicadas",
    "No result": "No hay resultados",
    "No results matching.": "No hay resultados que coincidan.",
    "No share links": "No hay enlaces de compartir",
    "No shared libraries": "No hay bibliotecas compartidas",
    "No sub-departments": "No hay sub-departamentos",
    "No sync errors": "No hay errores de sincronizaci\u00f3n",
    "No terms and conditions": "T\u00e9rminos y condiciones",
    "No upload links": "No hay enlaces de subida",
    "None": "Ninguna",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "Nota: las configuraciones via la interfaz web se guardan en una tabla de la base de datos (seahub-db/constance_config). Tienen prioridad sobre las configuraciones en los archivos.",
    "Notification": "Notificaci\u00f3n",
    "Notification Detail": "Detalles de notificaciones",
    "Notifications": "Notificaciones",
    "Notifications of collaboration": "Notificaciones de colaboraci\u00f3n",
    "Notifications of file changes": "Notificaciones de modificaciones en archivos",
    "Number of days that keep user sign in.": "N\u00famero de d\u00edas que el usuario permanece identificado",
    "Number of groups": "N\u00famero de grupos",
    "Off": "No",
    "Old Password": "Contrase\u00f1a anterior",
    "On": "Si",
    "Online Preview": "Vista previa en l\u00ednea",
    "Online Read-Only": "S\u00f3lo lectura en l\u00ednea",
    "Online Read-Only folder": "Carpeta de s\u00f3lo lectura en l\u00ednea",
    "Online Read-Only library": "Biblioteca de s\u00f3lo lectura en l\u00ednea",
    "Online Read-Write": "Lectura / Escritura en l\u00ednea",
    "Online Read-Write folder": "Carpeta de lectura / escritura en l\u00ednea",
    "Online Read-Write library": "Biblioteca de lectura / escritura en l\u00ednea",
    "Online view is not applicable to this file format": "La visualizaci\u00f3n en l\u00ednea no se aplica a este tipo de archivo",
    "Only Show": "S\u00f3lo Mostrar",
    "Only keep a period of history:": "S\u00f3lo mantener el historial por:",
    "Open parent directory": "Abrir carpeta contenedora",
    "Open parent folder": "Abrir carpeta contenedora",
    "Open via Client": "Abrir via el Cliente",
    "Operation": "Operaci\u00f3n",
    "Operation succeeded.": "Operaci\u00f3n exitosa.",
    "Operations": "Operaciones",
    "Organization": "Organizaci\u00f3n",
    "Organization Admin": "Administrador de la Organizaci\u00f3n",
    "Organizations": "Organizaciones",
    "Other": "Otro",
    "Other Libraries": "Otras bibliotecas",
    "Out of quota.": "Cuota agotada.",
    "Owned Libraries": "Bibliotecas Propias",
    "Owner": "Propietario",
    "Owner can use admin panel in an organization, must be a new account.": "El propietario puede utilizar el panel de admin en una organizaci\u00f3n, debe ser una cuenta nueva.",
    "Packaging...": "Empaquetando...",
    "Password": "Contrase\u00f1a ",
    "Password again": "Repetir contrase\u00f1a",
    "Password is too short": "Contrase\u00f1a demasiado corta",
    "Password:": "Contrase\u00f1a:",
    "Passwords do not match.": "Las contrase\u00f1as no coinciden.",
    "Passwords don't match": "Las contrase\u00f1as no coinciden",
    "Path": "Ruta",
    "Per 4 hours": "Por 4 horas",
    "Per day": "Por d\u00eda",
    "Per hour": "Por hora",
    "Per week": "Por semana",
    "Permission": "Permiso",
    "Permission denied": "Permiso denegado",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "Permiso denegado. Por favor intente {placeholder-left}acceder nuevamente.{placeholder-right}",
    "Permission:": "Permiso:",
    "Platform": "Plataforma",
    "Please check the network.": "Por favor verifique la red.",
    "Please choose a .xlsx file.": "Por favor escoja un archivo .xlsx",
    "Please choose an image file.": "Por favor escoja un archivo de imagen.",
    "Please enter 1 or more character": "Por favor ingrese uno o m\u00e1s caracteres",
    "Please enter a new password": "Ingrese una nueva contrase\u00f1a",
    "Please enter a non-negative integer": "Por favor, ingrese un n\u00famero entero no negativo",
    "Please enter a positive integer": "Por favor ingrese un entero positivo",
    "Please enter days": "Ingresa cantidad de d\u00edas",
    "Please enter password": "Ingresa una contrase\u00f1a",
    "Please enter the new password again": "Ingrese la nueva contrase\u00f1a otra vez",
    "Please enter the old password": "Ingrese la contrase\u00f1a anterior",
    "Please enter the password again": "Ingresa la contrase\u00f1a nuevamente",
    "Please input at least an email.": "Ingresa al menos un correo.",
    "Please select a library to share.": "Por favor seleccione una biblioteca para compartir.",
    "Please upload files less than {placeholder}M": "Ppr favor suba archivos de menos de {placeholder}M",
    "Please upload no more than {maxFiles} files at a time.": "Por favor no suba mas de {maxFiles} archivos al mismo tiempo.",
    "Preparing to upload...": "Preparando para subir...",
    "Preview and download": "Vista previa y descargar",
    "Preview only": "Vista previa solamente",
    "Previous": "Anterior",
    "Professional Edition": "Versi\u00f3n Profesional",
    "Profile": "Perfil",
    "Profile Setting": "Configuraci\u00f3n del perfil",
    "Publish": "Publicar",
    "Publish a Library": "Publicar una biblioteca",
    "Publish draft": "Publicar borrador",
    "Published Libraries": "Bibliotecas publicadas",
    "Quota": "Cuota",
    "Quota is invalid.": "La cuota es inv\u00e1lida.",
    "Read-Only": "S\u00f3lo lectura",
    "Read-Only folder": "Carpeta de s\u00f3lo lectura",
    "Read-Only library": "Biblioteca de s\u00f3lo lectura",
    "Read-Write": "Lectura / Escritura",
    "Read-Write folder": "Carpeta de lectura / escritura",
    "Read-Write library": "Biblioteca de lectura / escritura",
    "Really want to delete this group?": "\u00bfSeguro que deseas borrar este grupo?",
    "Really want to delete your account?": "\u00bfSeguro que deseas eliminar tu cuenta?",
    "Really want to leave this group?": "\u00bfSeguro que deseas abandorar este grupo?",
    "Refresh": "Refrescar",
    "Remaining": "Restante",
    "Remove": "Remover",
    "Remove Member": "Eliminar Miembro",
    "Removed all items from trash.": "Todos los items en la papelera eliminados.",
    "Removed items older than {n} days from trash.": "Todos los items de m\u00e1s de {n} d\u00edas en la papelera eliminados.",
    "Rename": "Renombrar",
    "Rename Department": "Renombrar Departmento",
    "Rename File": "Renombrar Archivo",
    "Rename Folder": "Renombrar Carpeta",
    "Rename Group": "Renombrar Grupo",
    "Rename group to": "Renombrar grupo a",
    "Renamed file": "Archivo renombrado",
    "Renamed folder": "Carpeta renombrada",
    "Renamed library": "Biblioteca renombrada",
    "Renamed or Moved files": "Archivos movidos o renombrados",
    "Renaming {name} failed": "Fallo al renombrar {name}",
    "Replace": "Reemplazar",
    "Replace file {filename}?": "\u00bfReemplazar archivo {filename}?",
    "Replacing it will overwrite its content.": "Al reemplazarlo se sobreescribir\u00e1 su contenido.",
    "Report Abuse": "Informar Abuso",
    "Reporter": "Informador",
    "Reports": "Informes",
    "Request a review": "Solicitar una revisi\u00f3n",
    "Required at least three letters.": "Se requieren al menos tres letras.",
    "Reset": "Restablecer",
    "Reset Password": "Reestablecer contrase\u00f1a",
    "Reset library password": "Reestablecer contrase\u00f1a de la biblioteca",
    "ResetPwd": "Restaurar contrase\u00f1a",
    "Resetting user's password, please wait for a moment.": "Resetenado contrase\u00f1a del usuario, por favor espere un momento.",
    "Restore": "Restaurar",
    "Restore Library": "Restaurar biblioteca",
    "Restored file": "Archivo restaurado",
    "Restored folder": "Carpeta restaurada",
    "Restored library": "Biblioteca restaurada",
    "Result": "Resultado",
    "Retry": "Reintentar",
    "Retry All": "Reintentar Todo",
    "Revoke": "Revocar",
    "Revoke Access": "Revocar Acceso",
    "Revoke Admin": "Revocar Privilegios",
    "Role": "Rol",
    "Save": "Guardar",
    "Save as ...": "Guardar como...",
    "Save to:": "Guardar en:",
    "Saving...": "Guardando...",
    "Scan the QR code to view the shared content directly": "Escanear el c\u00f3digo QR para ver el contenido compartido directamente",
    "Seafile": "Seafile",
    "Search": "Buscar",
    "Search Groups": "Buscar Grupos",
    "Search Libraries": "Buscar Bibliotecas",
    "Search Organizations": "Buscar Organizaciones",
    "Search Users": "Buscar Usuarios",
    "Search files in this library": "Buscar archivos en esta biblioteca",
    "Search group members": "Buscar miembros del grupo",
    "Search groups": "Buscar grupos",
    "Search groups by name": "Buscar grupos por nombre",
    "Search libraries by owner": "Buscar bibliotecas por propietario",
    "Search organizations": "Buscar organizaciones",
    "Search users": "Buscar usuarios",
    "Select File": "Seleccionar Archivo",
    "Select Image": "Seleccionar Imagen",
    "Select Tags": "Seleccionar etiquetas",
    "Select a color": "Seleccionar un color",
    "Select a department": "Seleccionar un departamento",
    "Select a group": "Seleccione un grupo",
    "Select a user": "Seleccionar un usuario",
    "Select groups": "Seleccionar grupos",
    "Select libraries to share": "Seleccionar bibliotecas para compartir",
    "Send": "Enviar",
    "Send activation Email after user registration.": "Enviar email de activaci\u00f3n despu\u00e9s del registro del usuario.",
    "Send to:": "Enviar a:",
    "Sending new password...": "Enviando la nueva contrase\u00f1a...",
    "Sending...": "Enviando\u2026",
    "Server": "Servidor",
    "Server Version: ": "Versi\u00f3n del servidor: ",
    "Set Admin": "Establecer Admin",
    "Set Contact Email": "Establecer Email de Contacto",
    "Set Login ID": "Establecer Login ID",
    "Set Name": "Establecer Nombre",
    "Set Password": "Establecer Contrase\u00f1a",
    "Set Quota": "Fijar Cuota",
    "Set Reference ID": "Establecer ID de Referencia",
    "Set max number of members": "Establecer m\u00e1ximo n\u00famero de miembros",
    "Set permission": "Establecer permiso",
    "Set to current": "Establecer actual",
    "Set user contact email": "Establecer email de contacto del usuario",
    "Set user name": "Establecer nombre del usuario",
    "Set user quota": "Establecer cuota del usuario",
    "Set {placeholder}'s permission": "Establecer permiso de  {placeholder}",
    "Setting library history is disabled by Admin.": "Establecer el historial de la biblioteca est\u00e1 deshabilitado por el Administrador.",
    "Settings": "Configuraci\u00f3n",
    "Share": "Compartir",
    "Share Admin": "Admin de Compartidos",
    "Share From": "Compartir desde",
    "Share Link": "Compartir enlace",
    "Share Link Traffic": "Tr\u00e1fico de enlaces compartidos",
    "Share Links": "Enlaces Compartidos",
    "Share To": "Compartir con",
    "Share To:": "Compartir con:",
    "Share existing libraries": "Compartir bibliotecas existentes",
    "Share link download": "Descargar enlace de compartir",
    "Share link is copied to the clipboard.": "Enlace de compartir copiado al portapapeles",
    "Share link upload": "Subir enlace de compartir",
    "Share to group": "Compartir con grupo",
    "Share to other server": "Compartir a otro servidor",
    "Share to user": "Compartir con usuario",
    "Shared By": "Compartida por",
    "Shared Libraries": "Bibliotecas Compartidas",
    "Shared Links": "Enlaces Compartidos",
    "Shared by:": "Compartido por:",
    "Shared by: ": "Compartido por:",
    "Shared from other servers": "Compartido desde otros servidores",
    "Shared with all": "Compartido con todos",
    "Shared with groups": "Compartido con grupos",
    "Shared with me": "Compartido conmigo",
    "Show": "Mostrar",
    "Show Codes": "Mostrar C\u00f3digos",
    "Side Nav Menu": "Men\u00fa Lateral de Navegaci\u00f3n",
    "Site name used in email sending": "Nombre del sitio utilizado en el env\u00edo de email",
    "Site title shown in a browser tab": "T\u00edtulo del sitio mostrado en una pesta\u00f1a del navegador",
    "Size": "Tama\u00f1o",
    "Social Login": "Inicio de Sesi\u00f3n Social",
    "Space Used": "Espacio utilizado",
    "Space Used / Quota": "Espacio utilizado / Cuota",
    "Star": "Marcar",
    "Start date": "Fecha Inicio",
    "Statistic": "Estad\u00edstica",
    "Status": "Estado",
    "Status: enabled": "Status: habilitado",
    "Storage": "Almacenamiento",
    "Storage Backend": "Backend de Almacenamiento",
    "Storage Used": "Espacio Utilizado",
    "Sub-departments": "Sub-departamentos",
    "Submit": "Enviar",
    "Success": "\u00c9xito",
    "Successfully added label(s) for library {placeholder}": "Etiqueta(s) agregada(s) con \u00e9xito para la biblioteca {placeholder}",
    "Successfully added {email_placeholder}": "{email_placeholder} agregado con \u00e9xito",
    "Successfully changed library password.": "Contrase\u00f1a de la biblioteca cambiada con \u00e9xito.",
    "Successfully cleaned all errors.": "Errores eliminados con \u00e9xito.",
    "Successfully cleared trash.": "Papelera vaciada con \u00e9xito.",
    "Successfully copied %(name)s and %(amount)s other items.": "%(name)s y otros %(amount)s elementos copiados con \u00e9xito.",
    "Successfully copied %(name)s and 1 other item.": "%(name)s y 1 otro \u00edtem copiados con \u00e9xito.",
    "Successfully copied %(name)s.": "%(name)s copiados con \u00e9xito.",
    "Successfully copied files to another library.": "Archivos copiados con \u00e9xito a otra biblioteca.",
    "Successfully deleted 1 item": "1 \u00edtem eliminado con \u00e9xito",
    "Successfully deleted 1 item.": "1 \u00edtem eliminado con \u00e9xito",
    "Successfully deleted 1 user.": "1 usuario eliminado con \u00e9xito.",
    "Successfully deleted draft %(draft)s.": "Borrador %(draft)seliminado con \u00e9xito.",
    "Successfully deleted {name}": "Eliminado con \u00e9xito {name}",
    "Successfully deleted {name}.": "{name} eliminado con \u00e9xito.",
    "Successfully deleted {user_number_placeholder} users.": "{user_number_placeholder} usuarios eliminados con \u00e9xito.",
    "Successfully edited labels.": "Etiquetas editadas con \u00e9xito",
    "Successfully invited %(email) and %(num) other people.": "%(email) y  otros %(num) invitados con \u00e9xito.",
    "Successfully invited %(email).": "%(email) invitado con \u00e9xito.",
    "Successfully modified permission.": "Permiso modificado con \u00e9xito.",
    "Successfully moved %(name)s and %(amount)s other items.": "%(name)s y otros %(amount)s elementos movidos con \u00e9xito.",
    "Successfully moved %(name)s and 1 other item.": "%(name)s y 1 otro \u00edtem movidos con \u00e9xito.",
    "Successfully moved %(name)s.": "%(name)s movido con \u00e9xito.",
    "Successfully moved files to another library.": "Archivos movidos con \u00e9xito a otra biblioteca.",
    "Successfully moved {name}.": "Movido con \u00e9xito {name}.",
    "Successfully published draft %(draft)s.": "Borrador %(draft)spublicado con \u00e9xito.",
    "Successfully removed {placeholder}.": "{placeholder} eliminado con \u00e9xito.",
    "Successfully reset password to %(passwd)s for user %(user)s.": "Contrase\u00f1a de %(user)s restablecida a %(passwd)s con \u00e9xito.",
    "Successfully restored 1 item.": "1 \u00edtem restaurado con \u00e9xito.",
    "Successfully restored the library.": "Biblioteca restaurada con \u00e9xito.",
    "Successfully restored.": "Restaurado con \u00e9xito.",
    "Successfully revoke the admin permission of %s": "Los permisos de administrador de %s fueron revocados",
    "Successfully revoked access of user {placeholder}.": "El acceso del usuario {placeholder} fue revocado con \u00e9xito.",
    "Successfully revoked the admin permission of {placeholder}.": "Permisos de {placeholder} fueron revocados con \u00e9xito.",
    "Successfully saved": "Guardado con \u00e9xito",
    "Successfully sent to {placeholder}": "Enviado con \u00e9xito a  {placeholder}",
    "Successfully set %s as admin.": "%s asignado como administrador.",
    "Successfully set it.": "Establecido con \u00e9xito",
    "Successfully set library history.": "Historial de biblioteca establecido con \u00e9xito.",
    "Successfully starred {library_name_placeholder}.": "Marcado con \u00e9xito {library_name_placeholder}.",
    "Successfully transferred the group.": "Grupo transferido con \u00e9xito.",
    "Successfully transferred the library.": "Biblioteca transferida con \u00e9xito.",
    "Successfully unlinked %(name)s.": "Desvinculado exitosamente %(name)s.",
    "Successfully unlinked the device.": "Dispositivo desvinculado con \u00e9xito.",
    "Successfully unshared library {placeholder}": "Se dej\u00f3 de compartir la biblioteca {placeholder} exitosamente",
    "Successfully unshared {name}": "Dejado de compartir con \u00e9xito {name}",
    "Successfully unstarred {library_name_placeholder}.": "Desmarcado con \u00e9xito {library_name_placeholder}.",
    "Suggestion": "Sugerencia",
    "Switch to plain text editor": "Cambiar a editor de texto sin formato",
    "Switch to rich text editor": "Cambiar a editor de texto enriquecido",
    "Sync": "Sincronizar",
    "Sync Download": "Descargar Sinc",
    "Sync Traffic": "Tr\u00e1fico de sincronizaci\u00f3n",
    "Sync Upload": "Subir Sinc",
    "System": "Sistema",
    "System Admin": "Administraci\u00f3n del Sistema",
    "System Info": "Informaci\u00f3n del Sistema",
    "Tag \"{name}\" already exists.": "La etiqueta \"{name}\" ya existe.",
    "Tagged Files": "Archivos Etiquetados",
    "Tags": "R\u00f3tulos",
    "Template": "Plantilla",
    "Terms": "T\u00e9rminos",
    "Terms and Conditions": "T\u00e9rminos y Condiciones",
    "Text": "Texto",
    "Text files": "Archivos de texto",
    "Text is required.": "Se requiere texto.",
    "The URL of the server, like https://seafile.example.com or http://192.168.1.2:8000": "El URL del servidor, como https://seafile.example.com o http://192.168.1.2:8000",
    "The file is too large. Allowed maximum size is 1MB.": "El archivo es demasiado grande. El tama\u00f1o m\u00e1ximo admitido es 1MB.",
    "The internal URL for downloading/uploading files. Users will not be able to download/upload files if this is not set correctly. If you config Seafile behind Nginx/Apache, it should be SERVICE_URL/seafhttp, like https://seafile.example.com/seafhttp .": "El URL interno para descargar/subir archivos. Los usuarios no podr\u00e1n descargar/subir archivos si \u00e9sto no es correcto. Si configuras Seafile utilizando Nginx/Apache, deber\u00eda ser SERVICE_URL/seafhttp, como https://seafile.example.com/seafhttp .",
    "The least number of characters a share/upload link password should include.": "El m\u00ednimo n\u00famero de caracteres que deber\u00eda incluir una contrase\u00f1a de compartir/enlace de subida.",
    "The least number of characters an account password should include.": "El m\u00ednimo n\u00famero de caracteres que deber\u00eda contener la contrase\u00f1a de una cuenta.",
    "The least number of characters an encrypted library password should include.": "El m\u00ednimo n\u00famero de caracteres que deber\u00eda contener la contrase\u00f1a de una biblioteca encriptada.",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "El nivel (1-4) de seguridad de una contrase\u00f1a de compartir/enlace de subida. Por ejemplo, '3' significa que la contrase\u00f1a debe contener al menos 3 de los siguientes: n\u00fameros, may\u00fasculas, min\u00fasculas y otros s\u00edmbolos",
    "The level(1-4) of an account password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "El nivel (1-4) de seguridad de la contrase\u00f1a de una cuenta. Por ejemplo, '3' significa que la contrase\u00f1a debe tener por lo menos 3 de los siguientes: n\u00fameros, letras may\u00fasculas, letras min\u00fasculas y otros s\u00edmbolos",
    "The link is copied to the clipboard.": "Enlace copiado al portapapeles.",
    "The list of added, deleted and modified files will be sent to your mailbox.": "La lista de archivos agregados, eliminados y modificados ser\u00e1 enviada a su casilla de correo.",
    "The maximum number of failed login attempts before showing CAPTCHA.": "El n\u00famero m\u00e1ximo de intentos de acceso fallidos antes de mostrar el CAPTCHA.",
    "The name \"{name}\" is already taken. Please choose a different name.": "El nombre '{name}' ya est\u00e1 en uso, por favor escoja otro nombre.",
    "The owner of this library has run out of space.": "El due\u00f1o de esta biblioteca se qued\u00f3 sin espacio.",
    "The password will be kept in the server for only 1 hour.": "La contrase\u00f1a ser\u00e1 almacenada en el servidor por 1 hora.",
    "This file has been updated.": "Este archivo ha sido actualizado.",
    "This file is in draft stage.": "Este archivo est\u00e1 en la etapa de borrador",
    "This folder has no content at this time.": "Esta carpeta no tiene contenido en este momento.",
    "This is a special group representing a department.": "Este es un grupo especial que representa a un departamento.",
    "This library has been set to read-only by admin and cannot be updated.": "Esta biblioteca ha sido configurada como de s\u00f3lo lectura, y no puede ser actualizada.",
    "This library is password protected": "Esta biblioteca est\u00e1 protegida por contrase\u00f1a",
    "This operation will not be reverted. Please think twice!": "Esta operaci\u00f3n no se puede revertir. \u00bfEst\u00e1s seguro?",
    "Time": "Fecha",
    "Tip: -2 means no limit.": "Ayuda: -2 significa sin l\u00edmite.",
    "Tip: 0 means default limit": "Tip: con 0 se mantiene el l\u00edmite predeterminado",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Consejo: una instant\u00e1nea ser\u00e1 generada despu\u00e9s de cada modificaci\u00f3n, para almacenar el estado posterior a la modificaci\u00f3n.",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "Consejo: bibliotecas eliminadas hace {placeholder} d\u00edas ser\u00e1n removidas autom\u00e1ticamente.",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "Consejo: bibliotecas eliminadas hace {trashReposExpireDays} d\u00edas ser\u00e1n removidas autom\u00e1ticamente.",
    "Tip: you can search by keyword in name.": "Consejo: puede buscar por palabra clave en el nombre.",
    "Token": "Identificador",
    "Token:": "Identificador:",
    "Tools": "Herramientas",
    "Total Devices": "Total de Dispositivos",
    "Total Storage": "Almacenamiento Total",
    "Total Traffic": "Tr\u00e1fico total",
    "Total Users": "Usuarios Total",
    "Traffic": "Tr\u00e1fico",
    "Transfer": "Transferir",
    "Transfer Group": "Tranferir Grupo",
    "Transfer Group {placeholder} to": "Transferir Grupo {placeholder} a",
    "Transfer Library": "Transferir Biblioteca",
    "Transfer Library {library_name}": "Transferir Biblioteca {library_name}",
    "Transfer group to": "Transferir el grupo a",
    "Transfer to department": "Transferir al departamento",
    "Transfer to user": "Transferir al usuario",
    "Transferred group {group_name} from {user_from} to {user_to}": "Grupo {group_name} transferido de {user_from} a {user_to}",
    "Transferred library {library_name} from {user_from} to {user_to}": "Biblioteca {library_name} transferida de  {user_from} a {user_to}",
    "Trash": "Papelera",
    "Two-Factor Authentication": "Autenticaci\u00f3n de dos Factores",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "La autenticaci\u00f3n de dos factores no est\u00e1 habilitada para su cuenta. Habilite autenticaci\u00f3n de dos factores para seguridad mejorada.",
    "Type": "Tipo",
    "Unhandled": "Sin manejar",
    "Unknown": "Desconocido",
    "Unlink": "Desvincular",
    "Unlink device": "Desvincular dispositivo",
    "Unlock": "Desbloquear",
    "Unpublish": "Dejar de publicar",
    "Unpublish Library": "Dejar de publicar Biblioteca",
    "Unshare": "Dejar de compartir",
    "Unshare Library": "Dejar de compartir Biblioteca",
    "Unstar": "Desmarcar",
    "Update": "Actualizar",
    "Update Terms and Conditions": "Actualizar T\u00e9rminos y Condiciones",
    "Update succeeded.": "Actualizaci\u00f3n exitosa.",
    "Updated draft": "Borrador actualizado",
    "Updated file": "Archivo actualizado",
    "Upgrade to Pro Edition": "Actualizar a Versi\u00f3n Pro",
    "Upload": "Subir archivo",
    "Upload Files": "Subir archivos",
    "Upload Folder": "Carpeta de Subida",
    "Upload Link": "Link de subida",
    "Upload Link:": "Enlace de Subida:",
    "Upload Links": "Enlaces de subida",
    "Upload file": "Subir archivo",
    "Upload files to {folder_name_placeholder}": "Subir archivos a {folder_name_placeholder}",
    "Upload license": "Subir licencia",
    "Upload link is copied to the clipboard.": "Enlace de subida copiado al portapapeles",
    "Uploaded": "Subido",
    "Use custom CSS": "Utilizar CSS personalizado",
    "Use draft": "Usar borrador",
    "Used:": "Utilizado:",
    "User": "Usuario",
    "User Email": "Email del Usuario",
    "User Permission": "Permiso del usuario",
    "User Storage": "Almacenamiento de Usuario",
    "User can only view files online via browser. Files can't be downloaded.": "El usuario s\u00f3lo puede ver archivos en l\u00ednea con el navegador. Los archivos no pueden ser descargados.",
    "User can read, download and sync files.": "El usuario puede leer, descargar y sincronizar archivos.",
    "User can read, write, upload, download and sync files.": "El usuario puede leer, escribir, subir, descargar y sincronizar archivos.",
    "User can view and edit file online via browser. Files can't be downloaded.": "El usuario  puede ver y editar archivos en l\u00ednea con el navegador. Los archivos no pueden ser descargados.",
    "User not found": "Usuario no encontrado",
    "User {user_link} has added you to {group_link}": "El usuario {user_link} te ha agregado a {group_link}",
    "Username:": "Nombre de usuario:",
    "Users": "Usuarios",
    "Verify": "Verificar",
    "Version": "Versi\u00f3n",
    "Version Number": "N\u00famero de Versi\u00f3n",
    "Version Number is required.": "Se requiere N\u00famero de Versi\u00f3n.",
    "Version Number must be a number.": "N\u00famero de Versi\u00f3n debe ser un n\u00famero.",
    "Video": "Video",
    "View": "Ver",
    "View Draft": "Ver Borrador",
    "View Link": "Ver Enlace",
    "View Snapshot": "Ver inst\u00e1ntanea",
    "View profile and more": "Ver perfil y m\u00e1s",
    "Virus": "Virus",
    "Virus File": "Archivo de Virus",
    "Virus Scan": "An\u00e1lisis de Virus",
    "Visited": "Visitado",
    "Visits": "Visitas",
    "Web API Auth Token": "Web API Auth Token",
    "Web Download": "Descargar Web",
    "Web Traffic": "Tr\u00e1fico Web",
    "Web Upload": "Subir Web",
    "WebDav Password": "Contrase\u00f1a WebDav",
    "Welcome to {site_name_placeholder}": "Bienvenido a {site_name_placeholder}",
    "Whether the notifications of collaboration such as sharing library or joining group should be sent to your mailbox.": "Si las notificaciones de colaboraci\u00f3n como compartir bibliotecas o unirse a un grupo deben ser enviadas a su casilla de correo.",
    "Wrong password": "Contrase\u00f1a incorrecta",
    "Yes": "S\u00ed",
    "You are not in any groups. Groups allow multiple people to collaborate on libraries. Groups you join will be listed here.": "No est\u00e1s en ning\u00fan grupo. Los grupos permiten que varias personas colaboren en bibliotecas. Los grupos a los que te unas estar\u00e1n listados aqu\u00ed.",
    "You are not in any groups. Groups allow multiple people to collaborate on libraries. You can create a group by clicking the \"New Group\" button in the menu bar.": "No est\u00e1s en ning\u00fan grupo. Los grupos permiten que varias personas colaboren en bibliotecas. Puedes crear un grupo haciendo click en l bot\u00f3n \"Nuevo Grupo\" en la barra del men\u00fa.",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "Tambi\u00e9n puedes agregar un usuario como invitado, que no podr\u00e1 crear bibliotecas ni grupos.",
    "You can create files quickly": "Puedes crear archivos r\u00e1pidamente",
    "You can create libraries by clicking the \"New Library\" button above.": "Puedes crear bibliotecas haciendo click en el bot\u00f3n \"Nueva Biblioteca\" que est\u00e1 arriba.",
    "You can use this field at login.": "Puede utilizar este campo para iniciar sesi\u00f3n",
    "You don't have any favorite items yet": "Todav\u00eda no tienes items favoritos",
    "You don't have any share links": "No tienes enlaces de compartir",
    "You don't have any upload links": "No tienes ning\u00fan enlace de subida",
    "You have an unsaved draft. Do you like to use it?": "Tienes un borrador sin guardar. \u00bfDeseas utilizarlo?",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "Todav\u00eda no has accedido a tus archivos con ning\u00fan cliente (escritorio o m\u00f3vil). Configura clientes en tus dispositivos para acceder a tus datos de una forma m\u00e1s c\u00f3moda.",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "Todavia no has agregado bibliotecas, carpetas o archivos a tu lista de favoritos. La lista de favoritos te brinda un acceso r\u00e1pido a los objetos que ulilizas con mayor frecuencia. Puedes agregar una biblioteca, carpeta o archivo a tu lista de favoritos haciendo click en la esrtella que est\u00e1 a la izquierda de su nombre.",
    "You have not created any libraries yet. A library is a container to organize your files and folders. A library can also be shared with others and synced to your connected devices. You can create a library by clicking the \"New Library\" button in the menu bar.": "Todav\u00eda no has creado bibliotecas. Una biblioteca es un contenedor para organizar tus archivos y carpetas. Una biblioteca tambi\u00e9n puede ser compartida con otros y sincronizada con tus dispositivos conectados. Puedes crear una biblioteca haciendo click en el bot\u00f3n \"Nueva Biblioteca\" en la barra del men\u00fa.",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "Todav\u00eda no has creado enlaces de compartir. Un enlace de compartir se puede utilizar para compartir archivos y carpetas con cualquier persona. Puedes crear un enlace de compartir para un archivo o una carpeta haciendo click en el icono de compartir que est\u00e1 a la derecha de su nombre.",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "Todav\u00eda no has creado enlaces de subida. Un enlace de subida permite que cualquier persona suba archivos a una carpeta o biblioteca. Puedes crear un enlace de subida para una carpeta o biblioteca haciendo click en el icono de compartir que est\u00e1 a la derecha de su nombre.",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "No has eliminado bibliotecas en los \u00faltimos {placeholder} d\u00edas. Una biblioteca eliminada ser\u00e1 removida autom\u00e1ticamente una vez transcurrido este per\u00edodo.",
    "You have not invited any guests yet. A guest can access shared libraries through the web interface allowing more efficient ways to collaborate than through links. You can invite a guest by clicking the \"Invite Guest\" button in the menu bar.": "Todav\u00eda no has convocado invitados. Un invitado puede acceder a bibliotecas compartidas a trav\u00e9s de la interface web permitiendo formas de colaborar m\u00e1s eficientes que mediante el uso de enlaces. Puedes convocar a un invitado haciendo click en el bot\u00f3n \"Convicar Invitado\" en la barra del men\u00fa.",
    "You have not published any libraries yet. A published library can be accessed by anyone, not only users, via its URL. You can publish a library by clicking the \"Publish a Library\" button in the menu bar.": "Todav\u00eda no has publicado bibliotecas. Una biblioteca publicada puede ser accedida por cualquier persona, no s\u00f3lo usuarios, mediante su URL. Puedes publicar una biblioteca haciendo click en el bot\u00f3n \"Publicar Biblioteca\" en la barra del men\u00fa.",
    "You have not shared any folders": "No has compartido ninguna carpeta",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "Todav\u00eda no has compartido carpetas con otros usuarios. Puedes compartir una carpeta con otros usuarios haciendo click en el icono compartir que est\u00e1 a la derecha del nombre de la carpeta.",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "Todav\u00eda no has compartido bibliotecas con otros usuarios. Puedes compartir una biblioteca con otros usuarios haciendo click en el icono compartir que est\u00e1 a la derecha del nombre de la biblioteca en \"Mis Bibliotecas\"",
    "You have only one backup code remaining.": "Le queda solamente un c\u00f3digo de resguardo.",
    "You have {num} backup codes remaining.": "Le quedan  {num} c\u00f3digos de resguardo.",
    "Your notifications will be sent to this email.": "Las notificaciones ser\u00e1n enviadas a esta direcci\u00f3n.",
    "ZIP": "ZIP",
    "ZIP Selected Items": "ZIP elementos seleccionados",
    "activate after registration": "activar despu\u00e9s del registro",
    "all": "todos",
    "all members": "todos los miembros",
    "allow new registrations": "permitir nuevos registros",
    "days": "d\u00edas",
    "deleted": "eliminado",
    "details": "detalles",
    "email is required": "direcci\u00f3n de correo requerida",
    "icon": "icono",
    "keep sign in": "permanecer identificado",
    "library password minimum length": "m\u00edmima longitud de contrase\u00f1a de biblioteca",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "licenciado a {placeholder_license_to},  caduca en {placeholder_license_expiration}",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "licenciado a {placeholder_license_to}, servicio de actualizaci\u00f3n caducado en {placeholder_license_expiration}",
    "locked": "bloqueado",
    "locked by {name}": "bloqueado por {name}",
    "name": "nombre",
    "only show {placeholder}": "mostrar s\u00f3lo {placeholder}",
    "password minimum length": "m\u00edmima longitud de contrase\u00f1a",
    "password strength level": "nivel de seguridad de la contrase\u00f1a",
    "progress": "progreso",
    "result": "resultado",
    "results": "resultados",
    "send activation email": "enviar email de activaci\u00f3n",
    "share/upload link force password": "forzar contrase\u00f1a en compartir/enlace de subida",
    "share/upload link password minimum length": "longitud m\u00ednima de la contrase\u00f1a de compartir/enlace de subida",
    "share/upload link password strength level": "nivel de seguridad de la contrase\u00f1a de compartir/enlace de subida",
    "shared by:": "compartido por:",
    "show more": "ver m\u00e1s",
    "size": "tama\u00f1o",
    "starred": "marcado",
    "state": "estado",
    "successfully added user %s.": "usuario %s  agregado con \u00e9xito.",
    "text file extensions": "extensiones para archivos de texto",
    "to": "para",
    "unstarred": "desmarcado",
    "you can also press \u2190 ": "tambi\u00e9n puedes presionar \u2190",
    "you can also press \u2192": "tambi\u00e9n puedes presionar \u2192 ",
    "{file} and {n} other files": "{file} y {n} otros archivos",
    "{from_user} has sent you a request for {draft_link}.": "{from_user} te ha enviado una solicitud para {draft_link}.",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} d\u00edas",
    "{number_placeholder} / Page": "{number_placeholder} / P\u00e1gina",
    "{placeholder} API Token": "{placeholder} API Token",
    "{placeholder} Folder Permission": "{placeholder} Permiso de Carpeta",
    "{placeholder} Modification History": "Historial de Cambios de {placeholder}",
    "{placeholder} Snapshot": "{placeholder} Instant\u00e1nea",
    "{placeholder} Trash": "{placeholder} Papelera",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from} ha compartido una carpeta llamada {repo_link} al grupo {group_link}.",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} ha compartido una carpeta llamada {repo_link} contigo.",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from} ha compartido una biblioteca llamada {repo_link} al grupo {group_link}.",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} ha compartido una biblioteca llamada {repo_link} contigo.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. However, since you are a guest user now, you can not create libraries.": "{site_name_placeholder} organiza los archivos en bibliotecas. Cada biblioteca se puede sincronizar y compartir por separado. Sin embargo, ya que eres un invitado, no puedes crear bibliotecas.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. We have created a personal library for you. You can create more libraries later.": "{site_name_placeholder} organiza los archivos en bibliotecas. Cada biblioteca se puede sincronizar y compartir por separado. Se ha creado una biblioteca personal. Puedes crear m\u00e1s despu\u00e9s.",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "{userCount} usuario(s) y {repoCount} bibliotecas de esta organizaci\u00f3n tambi\u00e9n ser\u00e1n eliminados.",
    "{user} has transfered a library named {repo_link} to you.": "{user} te ha transferido una biblioteca llamada {repo_link}."
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "j \\d\\e F \\d\\e Y \\a \\l\\a\\s H:i",
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S",
      "%d/%m/%Y %H:%M:%S.%f",
      "%d/%m/%Y %H:%M",
      "%d/%m/%y %H:%M:%S",
      "%d/%m/%y %H:%M:%S.%f",
      "%d/%m/%y %H:%M",
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%Y-%m-%d"
    ],
    "DATE_FORMAT": "j \\d\\e F \\d\\e Y",
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y",
      "%d/%m/%y",
      "%Y-%m-%d"
    ],
    "DECIMAL_SEPARATOR": ",",
    "FIRST_DAY_OF_WEEK": 1,
    "MONTH_DAY_FORMAT": "j \\d\\e F",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "d/m/Y H:i",
    "SHORT_DATE_FORMAT": "d/m/Y",
    "THOUSAND_SEPARATOR": "\u00a0",
    "TIME_FORMAT": "H:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F \\d\\e Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

